/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.better_client.service;

import com.euphony.better_client.BetterClient;
import com.euphony.better_client.utils.records.Timer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_5321;
import net.minecraft.class_8960;
import net.minecraft.class_8967;

public class TimerHandler {
    private static final Map<class_5321<class_1937>, Map<class_2338, Timer>> timers = new ConcurrentHashMap<class_5321<class_1937>, Map<class_2338, Timer>>();

    public static boolean shouldReset(class_8967 state) {
        return state != class_8967.field_47388 && state != class_8967.field_47387;
    }

    public static boolean shouldCreate(class_8967 state) {
        return state == class_8967.field_47388 || state == class_8967.field_47387;
    }

    public static boolean hasTimer(class_1937 level, class_2338 pos) {
        return TimerHandler.getTimer(level, pos) != null;
    }

    public static void insertTimer(class_1937 level, class_2338 pos, long startTime, long cooldownTicks) {
        if (level == null || pos == null) {
            BetterClient.LOGGER.warn("\u5c1d\u8bd5\u63d2\u5165\u8ba1\u65f6\u5668\u65f6\u4f20\u5165 null \u53c2\u6570");
            return;
        }
        class_5321 dimension = level.method_27983();
        Map levelTimers = timers.computeIfAbsent((class_5321<class_1937>)dimension, k -> new ConcurrentHashMap());
        Timer timer = new Timer(startTime, cooldownTicks);
        levelTimers.put(pos.method_10062(), timer);
        BetterClient.LOGGER.debug("\u4e3a\u4f4d\u7f6e {} \u521b\u5efa\u8ba1\u65f6\u5668\uff0c\u51b7\u5374\u65f6\u957f: {} ticks", (Object)pos, (Object)cooldownTicks);
    }

    public static Timer getTimer(class_1937 level, class_2338 pos) {
        if (level == null || pos == null) {
            return null;
        }
        Map<class_2338, Timer> levelTimers = timers.get(level.method_27983());
        if (levelTimers == null) {
            return null;
        }
        return levelTimers.get(pos);
    }

    public static void deleteTimer(class_1937 level, class_2338 pos) {
        if (level == null || pos == null) {
            return;
        }
        class_5321 dimension = level.method_27983();
        Map<class_2338, Timer> levelTimers = timers.get(dimension);
        if (levelTimers == null) {
            return;
        }
        Timer removedTimer = levelTimers.remove(pos);
        if (removedTimer != null) {
            BetterClient.LOGGER.debug("\u5220\u9664\u4f4d\u7f6e {} \u7684\u8ba1\u65f6\u5668\uff0c\u5269\u4f59\u65f6\u95f4: {} ticks", (Object)pos, (Object)removedTimer.getRemainingTicks(level.method_8510()));
        }
        if (levelTimers.isEmpty()) {
            timers.remove(dimension);
        }
    }

    public static void cleanupExpiredTimers(class_1937 level) {
        if (level == null) {
            return;
        }
        Map<class_2338, Timer> levelTimers = timers.get(level.method_27983());
        if (levelTimers == null) {
            return;
        }
        long currentTime = level.method_8510();
        levelTimers.entrySet().removeIf(entry -> {
            boolean expired = ((Timer)entry.getValue()).isExpired(currentTime);
            if (expired) {
                BetterClient.LOGGER.debug("\u6e05\u7406\u8fc7\u671f\u8ba1\u65f6\u5668: {}", entry.getKey());
            }
            return expired;
        });
        if (levelTimers.isEmpty()) {
            timers.remove(level.method_27983());
        }
    }

    public static void clearDimension(class_5321<class_1937> dimension) {
        timers.remove(dimension);
        BetterClient.LOGGER.debug("\u6e05\u7406\u7ef4\u5ea6 {} \u7684\u6240\u6709\u8ba1\u65f6\u5668", dimension);
    }

    public static void clearAll() {
        timers.clear();
        BetterClient.LOGGER.debug("\u6e05\u7406\u6240\u6709\u8ba1\u65f6\u5668");
    }

    public static void onSpawnerBlockUpdate(class_1937 level, class_2338 pos, class_2680 blockState) {
        if (!BetterClient.config.enableTrialSpawnerTimer) {
            return;
        }
        try {
            class_8967 spawnerState = (class_8967)blockState.method_11654((class_2769)class_8960.field_47349);
            TimerHandler.onSpawnerStateUpdate(level, pos, spawnerState);
        }
        catch (Exception e) {
            BetterClient.LOGGER.error("\u5904\u7406\u5237\u602a\u7b3c\u65b9\u5757\u66f4\u65b0\u65f6\u51fa\u9519: {}", (Object)pos, (Object)e);
        }
    }

    public static void onSpawnerStateUpdate(class_1937 level, class_2338 pos, class_8967 state) {
        if (!BetterClient.config.enableTrialSpawnerTimer || level == null || pos == null || state == null) {
            return;
        }
        try {
            if (TimerHandler.shouldCreate(state) && !TimerHandler.hasTimer(level, pos)) {
                long cooldownTicks = BetterClient.config.trialSpawnerCooldown * 20L;
                TimerHandler.insertTimer(level, pos, level.method_8510(), cooldownTicks);
                return;
            }
            if (TimerHandler.shouldReset(state)) {
                TimerHandler.deleteTimer(level, pos);
            }
        }
        catch (Exception e) {
            BetterClient.LOGGER.error("\u5904\u7406\u5237\u602a\u7b3c\u72b6\u6001\u66f4\u65b0\u65f6\u51fa\u9519: {} -> {}", new Object[]{pos, state, e});
        }
    }

    public static int getActiveTimerCount() {
        return timers.values().stream().mapToInt(Map::size).sum();
    }

    public static int getTimerCount(class_5321<class_1937> dimension) {
        Map<class_2338, Timer> levelTimers = timers.get(dimension);
        return levelTimers == null ? 0 : levelTimers.size();
    }
}

