/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.better_client.mixin;

import com.euphony.better_client.BetterClient;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Minecraft.class})
public abstract class MinecraftMixin {
    @Shadow
    @Final
    private SoundManager soundManager;
    @Shadow
    @Final
    public Options options;

    @Inject(method={"pauseGame(Z)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;setScreen(Lnet/minecraft/client/gui/screens/Screen;)V", ordinal=0)})
    private void onPauseGame(boolean bl, CallbackInfo ci) {
        if (BetterClient.config.enableMusicPause) {
            if (BetterClient.config.pauseUiSound) {
                this.soundManager.pauseAllExcept(new SoundSource[0]);
            } else {
                this.soundManager.pauseAllExcept(new SoundSource[]{SoundSource.UI});
            }
        }
    }

    @ModifyExpressionValue(method={"shouldEntityAppearGlowing(Lnet/minecraft/world/entity/Entity;)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;isCurrentlyGlowing()Z")})
    private boolean seenByEyeOfTheForestThenGlow(boolean original, Entity entity) {
        return BetterClient.config.enableGlowingEnderEye ? entity.getType() == EntityType.EYE_OF_ENDER || original : original;
    }
}

