/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.better_client.client.property;

import com.euphony.better_client.BetterClient;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.PrimitiveCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.properties.select.SelectItemModelProperty;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public record AxolotlBucketVariant(float variant) implements SelectItemModelProperty<Float>
{
    public static final PrimitiveCodec<Float> VALUE_CODEC = Codec.FLOAT;
    public static final SelectItemModelProperty.Type<AxolotlBucketVariant, Float> TYPE = SelectItemModelProperty.Type.create((MapCodec)RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.NON_NEGATIVE_FLOAT.optionalFieldOf("variant", (Object)Float.valueOf(0.0f)).forGetter(AxolotlBucketVariant::variant)).apply((Applicative)instance, AxolotlBucketVariant::new)), VALUE_CODEC);

    public Float get(ItemStack stack, ClientLevel level, LivingEntity entity, int seed, ItemDisplayContext itemDisplayContext) {
        Axolotl.Variant customData;
        if (!BetterClient.config.enableAxolotlBucketFix) {
            return Float.valueOf(0.0f);
        }
        int axolotlType = 0;
        DataComponentMap components = stack.getComponents();
        if (components.has(DataComponents.AXOLOTL_VARIANT) && (customData = (Axolotl.Variant)components.get(DataComponents.AXOLOTL_VARIANT)) != null) {
            axolotlType = customData.getId();
        }
        return Float.valueOf((float)axolotlType * 0.01f);
    }

    @NotNull
    public Codec<Float> valueCodec() {
        return VALUE_CODEC;
    }

    @NotNull
    public SelectItemModelProperty.Type<? extends SelectItemModelProperty<Float>, Float> type() {
        return TYPE;
    }
}

