/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.better_client.utils.records;

public record Timer(long startTime, long cooldownTicks) {
    public long getTimerEnd() {
        return this.startTime + this.cooldownTicks;
    }

    public long getRemainingTicks(long currentTime) {
        long remaining = this.getTimerEnd() - currentTime;
        return Math.max(0L, remaining);
    }

    public boolean isExpired(long currentTime) {
        return currentTime >= this.getTimerEnd();
    }

    public double getProgress(long currentTime) {
        if (this.cooldownTicks == 0L) {
            return 1.0;
        }
        long elapsed = currentTime - this.startTime;
        return Math.min(1.0, Math.max(0.0, (double)elapsed / (double)this.cooldownTicks));
    }
}

