/*
 * Decompiled with CFR 0.152.
 */
package com.denfop;

import com.denfop.DataBlock;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.ISubEnum;
import com.denfop.blocks.TileBlockCreator;
import com.denfop.blocks.blockitem.ItemBlockTileEntity;
import com.denfop.mixin.access.DeferredRegisterAccessor;
import com.denfop.register.Register;
import com.denfop.tiles.base.TileEntityBlock;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class DataBlockEntity<T extends Enum<T>> {
    public static TileBlockCreator instance;
    private final Map<T, RegistryObject<BlockTileEntity<T>>> block = new ConcurrentHashMap<T, RegistryObject<BlockTileEntity<T>>>();
    private final Map<Integer, T> elementsMeta = new ConcurrentHashMap<Integer, T>();
    private final T[] collections;
    public int index = 0;
    Map<T, RegistryObject<ItemBlockTileEntity<T>>> registryObjectList = new ConcurrentHashMap<T, RegistryObject<ItemBlockTileEntity<T>>>();
    public static List<RegistryObject<?>> objects;

    public DataBlockEntity(Class<T> typeClass) {
        this(typeClass, "industrialupgrade", Register.BLOCKS, Register.BLOCK_ENTITIES, Register.ITEMS);
    }

    public DataBlockEntity(Class<T> typeClass, String location, DeferredRegister<Block> BLOCKS, DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES, DeferredRegister<Item> ITEMS) {
        Enum[] collections = (Enum[])typeClass.getEnumConstants();
        this.collections = collections;
        for (Enum type : collections) {
            this.elementsMeta.put(((ISubEnum)((Object)type)).getId(), type);
            try {
                ResourceLocation key = new ResourceLocation(location, ((ISubEnum)((Object)type)).getMainPath() + "/" + ((ISubEnum)((Object)type)).m_7912_().toLowerCase());
                Supplier<BlockTileEntity> supplier = () -> TileBlockCreator.instance.create(type, key);
                RegistryObject ret = RegistryObject.create((ResourceLocation)key, (ResourceKey)BLOCKS.getRegistryKey(), (String)location);
                DataBlock.objectsBlock.add(ret);
                Map entries = ((DeferredRegisterAccessor)BLOCKS).getEntries();
                if (entries.putIfAbsent(ret, supplier) != null) {
                    throw new IllegalArgumentException("Duplicate registration " + ((ISubEnum)((Object)type)).getMainPath());
                }
                Supplier<BlockEntityType> supplierType = () -> this.create(Objects.requireNonNull(((IMultiTileBlock)((Object)type)).getTeClass()), ret);
                RegistryObject blockEntityType = RegistryObject.create((ResourceLocation)key, (ResourceKey)BLOCK_ENTITIES.getRegistryKey(), (String)location);
                ((IMultiTileBlock)((Object)type)).setType((RegistryObject<BlockEntityType<? extends TileEntityBlock>>)blockEntityType);
                Map entries1 = ((DeferredRegisterAccessor)BLOCK_ENTITIES).getEntries();
                if (entries1.putIfAbsent(blockEntityType, supplierType) != null) {
                    throw new IllegalArgumentException("Duplicate registration " + ((ISubEnum)((Object)type)).getMainPath());
                }
                this.block.put(type, ret);
                this.registerBlockItem(type, ret, location, ITEMS);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
    }

    public BlockEntityType<? extends TileEntityBlock> create(Class<? extends TileEntityBlock> typeClass, RegistryObject<BlockTileEntity<T>> ... block) {
        Constructor<?> constructor = typeClass.getConstructors()[0];
        return BlockEntityType.Builder.m_155273_((pos, state) -> {
            try {
                return (TileEntityBlock)((Object)((Object)constructor.newInstance(pos, state)));
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }, (Block[])((Block[])Arrays.stream(block).map(RegistryObject::get).toArray(Block[]::new))).m_58966_(null);
    }

    private void registerBlockItem(T type, RegistryObject<BlockTileEntity<T>> block, String location, DeferredRegister<Item> ITEMS) {
        int indexMax = 0;
        if (!((ISubEnum)type).register()) {
            return;
        }
        try {
            ResourceLocation key = new ResourceLocation(location, ((ISubEnum)type).getMainPath() + "/" + ((ISubEnum)type).m_7912_().toLowerCase());
            Supplier<ItemBlockTileEntity> supplier = () -> new ItemBlockTileEntity<Enum>((BlockTileEntity)block.get(), (Enum)type, key);
            if (indexMax < ((ISubEnum)type).getId()) {
                indexMax = ((ISubEnum)type).getId();
            }
            RegistryObject ret = RegistryObject.create((ResourceLocation)key, (ResourceKey)ITEMS.getRegistryKey(), (String)location);
            objects.add(ret);
            Map entries = ((DeferredRegisterAccessor)ITEMS).getEntries();
            if (entries.putIfAbsent(ret, supplier) != null) {
                throw new IllegalArgumentException("Duplicate registration " + type);
            }
            this.registryObjectList.put(type, ret);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public T getElementFromID(int meta) {
        return (T)((Enum)this.elementsMeta.get(meta));
    }

    public BlockTileEntity<T> getBlock(T element) {
        return (BlockTileEntity)this.block.get(element).get();
    }

    public BlockTileEntity<T> getBlock(int meta) {
        return (BlockTileEntity)this.block.get(this.getElementFromID(meta)).get();
    }

    public BlockTileEntity<T> getBlock() {
        return (BlockTileEntity)this.block.get(this.getElementFromID(0)).get();
    }

    public RegistryObject<BlockTileEntity<T>> getObject(int meta) {
        return this.block.get(this.getElementFromID(meta));
    }

    public BlockState getBlockState(int meta) {
        return ((BlockTileEntity)this.block.get(this.getElementFromID(meta)).get()).m_49966_();
    }

    public BlockState getStateFromMeta(int meta) {
        return ((BlockTileEntity)this.block.get(this.getElementFromID(meta)).get()).m_49966_();
    }

    public BlockState getState(T element) {
        return ((BlockTileEntity)this.block.get(element).get()).m_49966_();
    }

    public BlockState getDefaultState() {
        return ((BlockTileEntity)this.block.get(this.collections[0]).get()).m_49966_();
    }

    public ItemBlockTileEntity<T> getItem(T element) {
        return (ItemBlockTileEntity)this.registryObjectList.get(element).get();
    }

    public ItemBlockTileEntity<T> getItem(int meta) {
        return (ItemBlockTileEntity)this.registryObjectList.get(this.getElementFromID(meta)).get();
    }

    public ItemBlockTileEntity<T> getItem() {
        return (ItemBlockTileEntity)this.registryObjectList.get(this.getElementFromID(0)).get();
    }

    public ItemStack getItemStack(T element) {
        return new ItemStack((ItemLike)this.registryObjectList.get(element).get());
    }

    public ItemStack getItemStack(T element, int col) {
        return new ItemStack((ItemLike)this.registryObjectList.get(element).get(), col);
    }

    public ItemStack getItemStack(int meta) {
        return new ItemStack((ItemLike)this.registryObjectList.get(this.getElementFromID(meta)).get());
    }

    public ItemStack getItemStack(int meta, int col) {
        return new ItemStack((ItemLike)this.registryObjectList.get(this.getElementFromID(meta)).get(), col);
    }

    public int getMetaFromItemStack(ItemStack itemStack) {
        for (RegistryObject<ItemBlockTileEntity<T>> item1 : this.registryObjectList.values()) {
            if (item1.get() != itemStack.m_41720_()) continue;
            return ((ISubEnum)((ItemBlockTileEntity)item1.get()).getElement()).getId();
        }
        return 0;
    }

    public boolean contains(ItemStack itemStack) {
        Item item = itemStack.m_41720_();
        for (RegistryObject<ItemBlockTileEntity<T>> item1 : this.registryObjectList.values()) {
            if (item1.get() != item) continue;
            return true;
        }
        return false;
    }

    public ItemBlockTileEntity<T> getItem(ItemStack itemStack) {
        Item item = itemStack.m_41720_();
        for (RegistryObject<ItemBlockTileEntity<T>> item1 : this.registryObjectList.values()) {
            if (item1.get() != item) continue;
            return (ItemBlockTileEntity)item1.get();
        }
        return null;
    }

    public BlockTileEntity<T> getBlock(IMultiTileBlock teBlock) {
        return (BlockTileEntity)this.block.get(this.getElementFromID(teBlock.getId())).get();
    }

    static {
        objects = new LinkedList();
    }
}

