/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.energy;

import com.denfop.api.energy.EnergyForge;
import com.denfop.api.energy.EnergyNetGlobal;
import com.denfop.api.energy.IEnergyEmitter;
import com.denfop.api.energy.IEnergySink;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyForgeSink
extends EnergyForge
implements IEnergySink {
    private double perenergy;
    private double pastEnergy;
    private double tick;
    List<Integer> energyTicks = new LinkedList<Integer>();

    public EnergyForgeSink(BlockEntity blockEntity) {
        super(blockEntity);
    }

    @Override
    public boolean acceptsEnergyFrom(IEnergyEmitter var1, Direction var2) {
        IEnergyStorage energyStorage = (IEnergyStorage)this.storages.get(var2);
        return energyStorage != null && energyStorage.canReceive();
    }

    @Override
    public double getPerEnergy() {
        return this.perenergy;
    }

    @Override
    public double getPastEnergy() {
        return this.pastEnergy;
    }

    @Override
    public void setPastEnergy(double pastEnergy) {
        this.pastEnergy = pastEnergy;
    }

    @Override
    public void addPerEnergy(double setEnergy) {
        this.perenergy += setEnergy;
    }

    @Override
    public void addTick(double tick) {
        this.tick = tick;
    }

    @Override
    public double getTick() {
        return this.tick;
    }

    @Override
    public boolean isSink() {
        return true;
    }

    @Override
    public double getDemandedEnergy() {
        return 0.0;
    }

    @Override
    public double getDemandedEnergy(Direction direction) {
        IEnergyStorage energyStorage = (IEnergyStorage)this.storages.get(direction);
        if (energyStorage == null) {
            return 0.0;
        }
        return (double)energyStorage.receiveEnergy(Integer.MAX_VALUE, true) / 4.0;
    }

    @Override
    public int getSinkTier(Direction direction) {
        IEnergyStorage energyStorage = (IEnergyStorage)this.storages.get(direction);
        return EnergyNetGlobal.instance.getTierFromPower((double)energyStorage.receiveEnergy(Integer.MAX_VALUE, true) / 4.0);
    }

    @Override
    public int getSinkTier() {
        return 1;
    }

    @Override
    public void receiveEnergy(Direction direction, double var2) {
        IEnergyStorage energyStorage = (IEnergyStorage)this.storages.get(direction);
        energyStorage.receiveEnergy((int)(var2 * 4.0), false);
    }

    @Override
    public void receiveEnergy(double var2) {
    }

    @Override
    public List<Integer> getEnergyTickList() {
        return this.energyTicks;
    }
}

