/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.gui;

import com.denfop.Localization;
import com.denfop.api.gui.GuiElement;
import com.denfop.gui.GuiCore;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;

public class FluidItem
extends GuiElement<FluidItem> {
    private final FluidStack fluid;

    public FluidItem(GuiCore<?> gui, int x, int y, FluidStack fluid) {
        super(gui, x, y, 18, 18);
        this.fluid = fluid;
    }

    public static FluidItem createFluidSlot(GuiCore<?> gui, int x, int y, FluidStack fluid) {
        return new FluidItem(gui, x, y, fluid);
    }

    @Override
    public void drawForeground(GuiGraphics poseStack, int mouseX, int mouseY) {
        if (mouseX >= this.x && mouseX < this.x + 18 && mouseY >= this.y && mouseY < this.y + 18) {
            String tooltip;
            List<String> lines = this.getToolTip();
            if (this.getTooltipProvider() != null && (tooltip = (String)this.getTooltipProvider().get()) != null && !tooltip.isEmpty()) {
                FluidItem.addLines(lines, tooltip);
            }
            if (!lines.isEmpty()) {
                this.gui.drawTooltip(mouseX, mouseY, lines);
            }
        }
    }

    @Override
    public void drawBackground(GuiGraphics poseStack, int mouseX, int mouseY) {
        FluidItem.bindCommonTexture();
        FluidStack fs = this.fluid;
        if (!fs.isEmpty() && fs.getAmount() > 0) {
            int fluidX = this.x + 1;
            int fluidY = this.y + 1;
            int fluidWidth = 16;
            int fluidHeight = 16;
            Fluid fluid = fs.getFluid();
            IClientFluidTypeExtensions extensions = IClientFluidTypeExtensions.of((Fluid)fluid);
            TextureAtlasSprite sprite = FluidItem.getBlockTextureMap().m_118316_(extensions.getStillTexture(fs));
            int color = extensions.getTintColor();
            FluidItem.bindBlockTexture();
            this.gui.drawSprite(poseStack, mouseX + fluidX, mouseY + fluidY, fluidWidth, fluidHeight, sprite, color, 1.0, false, false);
        }
        GuiCore.bindTexture(commonTexture1);
    }

    @Override
    protected List<String> getToolTip() {
        List<String> ret = super.getToolTip();
        FluidStack fs = this.fluid;
        if (fs != null && fs.getAmount() > 0) {
            Fluid fluid = fs.getFluid();
            if (fluid != null) {
                ret.add(Localization.translate(fs.getTranslationKey()));
                ret.add("Amount: " + fs.getAmount() + " " + Localization.translate("iu.generic.text.mb"));
                ret.add("Type: Liquid");
            } else {
                ret.add("Invalid FluidStack instance.");
            }
        } else {
            ret.add("No Fluid");
            ret.add("Amount: 0 " + Localization.translate("iu.generic.text.mb"));
            ret.add("Type: Not Available");
        }
        return ret;
    }
}

