/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.gui;

import com.denfop.Localization;
import com.denfop.api.gui.GuiElement;
import com.denfop.api.gui.MouseButton;
import com.denfop.componets.ComponentBioFuelEnergy;
import com.denfop.componets.ComponentSteamEnergy;
import com.denfop.componets.Fluids;
import com.denfop.container.ContainerBase;
import com.denfop.gui.GuiAdvCokeOven;
import com.denfop.gui.GuiBlastFurnace;
import com.denfop.gui.GuiCokeOven;
import com.denfop.gui.GuiCore;
import com.denfop.items.ItemPipette;
import com.denfop.network.packet.PacketDrainFluidPipette;
import com.denfop.tiles.base.TileEntityBlock;
import com.denfop.utils.FluidHandlerFix;
import com.denfop.utils.KeyboardIU;
import com.denfop.utils.ModUtils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class TankGauge
extends GuiElement<TankGauge> {
    public static final int v = 100;
    protected final IFluidTank tank;
    private final TankGuiStyle style;

    public TankGauge(GuiCore<?> gui, int x, int y, int width, int height, IFluidTank tank, TankGuiStyle style) {
        super(gui, x, y, width, height);
        if (tank == null) {
            throw new NullPointerException("null tank");
        }
        this.tank = tank;
        this.style = style;
    }

    public static TankGauge createNormal(GuiCore<?> gui, int x, int y, IFluidTank tank) {
        return new TankGauge(gui, x, y, 20, 55, tank, TankGuiStyle.Normal);
    }

    public static TankGauge createPlain(GuiCore<?> gui, int x, int y, int width, int height, IFluidTank tank) {
        return new TankGauge(gui, x, y, width, height, tank, TankGuiStyle.Plain);
    }

    public static TankGauge createBorderless(GuiCore<?> gui, int x, int y, IFluidTank tank, boolean mirrored) {
        return new TankGauge(gui, x, y, 12, 47, tank, mirrored ? TankGuiStyle.BorderlessMirrored : TankGuiStyle.Borderless);
    }

    public TankGuiStyle getStyle() {
        return this.style;
    }

    @Override
    protected boolean onMouseClick(int mouseX, int mouseY, MouseButton button) {
        IFluidTank iFluidTank;
        if (this.visible() && this.contains(mouseX, mouseY) && !this.tank.getFluid().isEmpty() && (iFluidTank = this.tank) instanceof Fluids.InternalFluidTank) {
            Fluids.InternalFluidTank fluidTank = (Fluids.InternalFluidTank)iFluidTank;
            iFluidTank = Minecraft.m_91087_().f_91074_.f_36096_.m_142621_().m_41720_();
            if (iFluidTank instanceof ItemPipette) {
                ItemPipette pipette = (ItemPipette)iFluidTank;
                IFluidHandlerItem handler = FluidHandlerFix.getFluidHandler(Minecraft.m_91087_().f_91074_.f_36096_.m_142621_());
                TileEntityBlock block = (TileEntityBlock)((Object)((ContainerBase)((Object)this.gui.container)).base);
                ComponentSteamEnergy steamEnergy = block.getComp(ComponentSteamEnergy.class);
                ComponentBioFuelEnergy bioEnergy = block.getComp(ComponentBioFuelEnergy.class);
                if (steamEnergy != null && !steamEnergy.getFluidTank().getFluid().isEmpty() && steamEnergy.getFluidTank().getFluid().getAmount() == this.tank.getFluid().getAmount() && steamEnergy.getFluidTank().getFluid().isFluidEqual(this.tank.getFluid())) {
                    return false;
                }
                if (bioEnergy != null && !bioEnergy.getFluidTank().getFluid().isEmpty() && bioEnergy.getFluidTank().getFluid().getAmount() == this.tank.getFluid().getAmount() && bioEnergy.getFluidTank().getFluid().isFluidEqual(this.tank.getFluid())) {
                    return false;
                }
                if (this.gui instanceof GuiBlastFurnace || this.gui instanceof GuiCokeOven || this.gui instanceof GuiAdvCokeOven) {
                    return false;
                }
                if (handler.getFluidInTank(0).isEmpty() || handler.getFluidInTank(0).isFluidEqual(fluidTank.getFluid())) {
                    this.getGui().getMinecraft().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
                    new PacketDrainFluidPipette((BlockEntity)((ContainerBase)((Object)this.gui.container)).base, fluidTank.getIdentifier(), Math.min(fluidTank.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE).getAmount(), handler.getTankCapacity(0) - handler.getFluidInTank(0).getAmount()));
                }
            }
        }
        return super.onMouseClick(mouseX, mouseY, button);
    }

    @Override
    public void drawBackground(GuiGraphics poseStack, int mouseX, int mouseY) {
        TankGauge.bindCommonTexture();
        FluidStack fs = this.tank.getFluid();
        if (!fs.isEmpty() && fs.getAmount() > 0) {
            if (this.style.withBorder) {
                this.gui.drawTexturedModalRect(poseStack, mouseX + this.x, mouseY + this.y, 70, 100, this.width, this.height);
            }
            int fluidX = this.x;
            int fluidY = this.y;
            int fluidWidth = this.width;
            int fluidHeight = this.height;
            if (this.style.withBorder) {
                fluidX += 4;
                fluidY += 4;
                fluidWidth = 12;
                fluidHeight = 47;
            }
            Fluid fluid = fs.getFluid();
            IClientFluidTypeExtensions extensions = IClientFluidTypeExtensions.of((Fluid)fluid);
            TextureAtlasSprite sprite = TankGauge.getBlockTextureMap().m_118316_(extensions.getStillTexture(fs));
            int color = extensions.getTintColor();
            double renderHeight = (double)fluidHeight * ModUtils.limit((double)fs.getAmount() / (double)this.tank.getCapacity(), 0.0, 1.0);
            TankGauge.bindBlockTexture();
            this.gui.drawSprite(poseStack, mouseX + fluidX, (double)mouseY + (double)(fluidY + fluidHeight) - renderHeight, fluidWidth, renderHeight, sprite, color, 1.0, false, true);
            if (this.style.withGauge) {
                TankGauge.bindCommonTexture();
                int gaugeX = this.x;
                int gaugeY = this.y;
                if (!this.style.withBorder) {
                    gaugeX -= 4;
                    gaugeY -= 4;
                }
                this.gui.drawTexturedModalRect(poseStack, mouseX + gaugeX, mouseY + gaugeY, 38, 100, 20, 55);
            }
        } else if (this.style.withBorder) {
            this.gui.drawTexturedModalRect(poseStack, mouseX + this.x, mouseY + this.y, 70, 100, this.width, this.height);
        } else if (this.style.withGauge) {
            this.gui.drawTexturedModalRect(poseStack, mouseX + this.x, mouseY + this.y, 74, 104, this.width, this.height);
        }
    }

    @Override
    protected List<String> getToolTip() {
        List<String> ret = super.getToolTip();
        FluidStack fs = this.tank.getFluid();
        if (KeyboardIU.isKeyDown(340)) {
            if (this.tank instanceof Fluids.InternalFluidTank) {
                Fluids.InternalFluidTank tank1 = (Fluids.InternalFluidTank)this.tank;
                ret.add(Localization.translate("iu.tank.fluids"));
                ret.addAll(tank1.getFluidList());
            }
        } else if (!fs.isEmpty() && fs.getAmount() > 0) {
            Fluid fluid = fs.getFluid();
            if (fluid != null) {
                ret.add(Localization.translate(fs.getFluid().getFluidType().getDescriptionId()) + ": " + fs.getAmount() + " " + Localization.translate("iu.generic.text.mb"));
            } else {
                ret.add("invalid fluid stack");
            }
        } else {
            ret.add(Localization.translate("iu.generic.text.empty"));
        }
        return ret;
    }

    public static enum TankGuiStyle {
        Normal(true, true, false),
        Borderless(false, true, false),
        BorderlessMirrored(false, true, true),
        Plain(false, false, false);

        public final boolean withBorder;
        public final boolean withGauge;
        public final boolean mirrorGauge;

        private TankGuiStyle(boolean withBorder, boolean withGauge, boolean mirrorGauge) {
            this.withBorder = withBorder;
            this.withGauge = withGauge;
            this.mirrorGauge = mirrorGauge;
        }
    }
}

