/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.pollution;

import com.denfop.api.pollution.LevelPollution;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.INetworkObject;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.ChunkPos;

public class ChunkLevel
implements INetworkObject {
    private ChunkPos pos;
    private ChunkPos defaultPos;
    private LevelPollution levelPollution;
    private double pollution;

    public ChunkLevel(ChunkPos pos, LevelPollution levelPollution, double pollution) {
        this.pos = pos;
        this.defaultPos = pos;
        this.levelPollution = levelPollution;
        this.pollution = pollution;
    }

    public ChunkLevel(CompoundTag tagCompound) {
        this.pollution = tagCompound.m_128459_("pollution");
        this.levelPollution = LevelPollution.values()[tagCompound.m_128445_("level")];
        this.pos = new ChunkPos(tagCompound.m_128451_("x"), tagCompound.m_128451_("z"));
        this.defaultPos = new ChunkPos(tagCompound.m_128451_("x1"), tagCompound.m_128451_("z1"));
    }

    public ChunkLevel(CustomPacketBuffer packetBuffer) {
        this.pollution = packetBuffer.readDouble();
        this.levelPollution = LevelPollution.values()[packetBuffer.readInt()];
        this.pos = new ChunkPos(packetBuffer.readInt(), packetBuffer.readInt());
        this.defaultPos = new ChunkPos(packetBuffer.readInt(), packetBuffer.readInt());
    }

    public CompoundTag writeCompound() {
        CompoundTag tag = new CompoundTag();
        tag.m_128347_("pollution", this.pollution);
        tag.m_128344_("level", (byte)this.levelPollution.ordinal());
        tag.m_128405_("x", this.pos.f_45578_);
        tag.m_128405_("z", this.pos.f_45579_);
        tag.m_128405_("x1", this.defaultPos.f_45578_);
        tag.m_128405_("z1", this.defaultPos.f_45579_);
        return tag;
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer customPacketBuffer = new CustomPacketBuffer();
        customPacketBuffer.writeDouble(this.pollution);
        customPacketBuffer.writeInt(this.levelPollution.ordinal());
        customPacketBuffer.writeInt(this.pos.f_45578_);
        customPacketBuffer.writeInt(this.pos.f_45579_);
        customPacketBuffer.writeInt(this.defaultPos.f_45578_);
        customPacketBuffer.writeInt(this.defaultPos.f_45579_);
        return customPacketBuffer;
    }

    public ChunkPos getDefaultPos() {
        return this.defaultPos;
    }

    public void setDefaultPos(ChunkPos defaultPos) {
        this.defaultPos = defaultPos;
    }

    public ChunkPos getPos() {
        return this.pos;
    }

    public void setPos(ChunkPos pos) {
        this.pos = pos;
    }

    public LevelPollution getLevelPollution() {
        return this.levelPollution;
    }

    public void setLevelPollution(LevelPollution levelPollution) {
        this.levelPollution = levelPollution;
    }

    public double getPollution() {
        return this.pollution;
    }

    public void setPollution(double pollution) {
        this.pollution = pollution;
    }

    public void addChunkPos(int x, int z) {
        this.pos = new ChunkPos(this.pos.f_45578_ + x, this.pos.f_45579_ + z);
    }

    public boolean removePollution(double pollution) {
        boolean removed;
        if (this.levelPollution == LevelPollution.VERY_LOW) {
            if (this.pollution == 0.0) {
                return false;
            }
            if (this.pollution == 124.0 && pollution == 125.0) {
                this.pollution = 0.0;
                return true;
            }
            if (this.pollution < pollution) {
                this.pollution = 0.0;
                return false;
            }
        }
        if (this.levelPollution == LevelPollution.LOW) {
            pollution /= 10.0;
        }
        if (this.levelPollution == LevelPollution.MEDIUM) {
            pollution /= 100.0;
        }
        if (this.levelPollution == LevelPollution.HIGH) {
            pollution /= 1000.0;
        }
        if (this.levelPollution == LevelPollution.VERY_HIGH) {
            pollution /= 10000.0;
        }
        if (this.pollution - pollution == 0.0) {
            this.pollution = this.levelPollution != LevelPollution.VERY_LOW ? 125.0 : 0.0;
            this.levelPollution = LevelPollution.values()[Math.max(this.levelPollution.ordinal() - 1, 0)];
            removed = true;
        } else if (this.pollution - pollution < 0.0) {
            this.pollution = 125.0 - (pollution - this.pollution);
            this.levelPollution = LevelPollution.values()[Math.max(this.levelPollution.ordinal() - 1, 0)];
            removed = true;
        } else {
            this.pollution -= pollution;
            pollution = 0.0;
            removed = true;
        }
        return removed;
    }

    public void addPollution(double pollution) {
        while (pollution > 0.0) {
            if (this.levelPollution == LevelPollution.LOW) {
                pollution /= 10.0;
            }
            if (this.levelPollution == LevelPollution.MEDIUM) {
                pollution /= 100.0;
            }
            if (this.levelPollution == LevelPollution.HIGH) {
                pollution /= 1000.0;
            }
            if (this.levelPollution == LevelPollution.VERY_HIGH) {
                pollution /= 10000.0;
            }
            if (this.pollution + pollution == 125.0) {
                pollution = 0.0;
                this.levelPollution = LevelPollution.values()[Math.min(this.levelPollution.ordinal() + 1, LevelPollution.values().length - 1)];
                continue;
            }
            if (this.pollution + pollution > 125.0) {
                this.pollution = 0.0;
                pollution -= 125.0 - this.pollution;
                this.levelPollution = LevelPollution.values()[Math.min(this.levelPollution.ordinal() + 1, LevelPollution.values().length - 1)];
                continue;
            }
            this.pollution += pollution;
            pollution = 0.0;
        }
    }
}

