/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.pollution;

import com.denfop.IUPotion;
import com.denfop.ModConfig;
import com.denfop.api.pollution.ChunkLevel;
import com.denfop.api.pollution.EventHandler;
import com.denfop.api.pollution.IPollutionMechanism;
import com.denfop.api.pollution.LevelPollution;
import com.denfop.api.pollution.Vec2f;
import com.denfop.api.windsystem.EnumTypeWind;
import com.denfop.api.windsystem.EnumWindSide;
import com.denfop.api.windsystem.IWindSystem;
import com.denfop.api.windsystem.WindSystem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;

public class PollutionManager {
    public static PollutionManager pollutionManager;
    private final IWindSystem wind;
    private final Random random;
    Map<ChunkPos, ChunkLevel> pollutionAir = new HashMap<ChunkPos, ChunkLevel>();
    Map<ChunkPos, List<IPollutionMechanism>> pollutionAirChunks = new HashMap<ChunkPos, List<IPollutionMechanism>>();
    Map<ChunkPos, List<IPollutionMechanism>> pollutionSoilChunks = new HashMap<ChunkPos, List<IPollutionMechanism>>();
    Map<ChunkPos, ChunkLevel> pollutionSoil = new HashMap<ChunkPos, ChunkLevel>();

    public PollutionManager() {
        this.wind = WindSystem.windSystem;
        this.random = new Random();
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
    }

    public void work(Player player) {
        if (player.m_9236_().m_46472_() != Level.f_46428_ || player.m_9236_().f_46443_) {
            return;
        }
        if (player.m_9236_().m_46467_() % 200L == 0L) {
            ChunkPos pos = new ChunkPos(player.m_20183_());
            ChunkLevel pollution = this.pollutionSoil.get(pos);
            if (((Boolean)ModConfig.COMMON.soilPollution.get()).booleanValue() && pollution != null && pollution.getLevelPollution().ordinal() >= 2) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 200, 0));
                if (pollution.getLevelPollution().ordinal() >= 3) {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 200, 0));
                    if (pollution.getLevelPollution().ordinal() >= 4) {
                        player.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 200, 0));
                    }
                }
            }
            pollution = this.pollutionAir.get(pos);
            if (((Boolean)ModConfig.COMMON.airPollution.get()).booleanValue() && pollution != null && pollution.getLevelPollution().ordinal() >= 2) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 200, 0));
                if (pollution.getLevelPollution().ordinal() >= 3) {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 200, 0));
                    if (pollution.getLevelPollution().ordinal() >= 4) {
                        player.m_7292_(new MobEffectInstance((MobEffect)IUPotion.poison_gas, 200, 0));
                    }
                }
            }
        }
    }

    public void addAirPollutionMechanism(IPollutionMechanism pollutionMechanism) {
        List<IPollutionMechanism> pollution = this.pollutionAirChunks.get(pollutionMechanism.getChunkPos());
        if (pollution == null) {
            pollution = new ArrayList<IPollutionMechanism>();
            pollution.add(pollutionMechanism);
            this.pollutionAirChunks.put(pollutionMechanism.getChunkPos(), pollution);
        } else {
            pollution.add(pollutionMechanism);
        }
    }

    public void removeAirPollutionMechanism(IPollutionMechanism pollutionMechanism) {
        if (pollutionMechanism == null) {
            return;
        }
        List pollution = this.pollutionAirChunks.computeIfAbsent(pollutionMechanism.getChunkPos(), k -> new ArrayList());
        pollution.remove(pollutionMechanism);
    }

    public void removeSoilPollutionMechanism(IPollutionMechanism pollutionMechanism) {
        if (pollutionMechanism == null) {
            return;
        }
        List pollution = this.pollutionSoilChunks.computeIfAbsent(pollutionMechanism.getChunkPos(), k -> new ArrayList());
        pollution.remove(pollutionMechanism);
    }

    public void loadData(CompoundTag tagCompound) {
        ChunkLevel chunkLevel;
        int i;
        this.pollutionSoil.clear();
        this.pollutionAir.clear();
        this.pollutionAirChunks.clear();
        this.pollutionSoilChunks.clear();
        CompoundTag soil = tagCompound.m_128469_("soil");
        CompoundTag air = tagCompound.m_128469_("air");
        int size = soil.m_128451_("size");
        int size1 = air.m_128451_("size");
        for (i = 0; i < size; ++i) {
            chunkLevel = new ChunkLevel(soil.m_128469_(String.valueOf(i)));
            this.pollutionSoil.put(chunkLevel.getPos(), chunkLevel);
        }
        for (i = 0; i < size1; ++i) {
            chunkLevel = new ChunkLevel(air.m_128469_(String.valueOf(i)));
            this.pollutionAir.put(chunkLevel.getPos(), chunkLevel);
        }
    }

    public CompoundTag writeCompound() {
        CompoundTag nbtTagCompound = new CompoundTag();
        CompoundTag soil = new CompoundTag();
        CompoundTag air = new CompoundTag();
        try {
            ChunkLevel chunkLevel;
            int i;
            List<ChunkLevel> pollutionSoilChunk = this.pollutionSoil.values().stream().toList();
            List<ChunkLevel> pollutionAirChunk = this.pollutionAir.values().stream().toList();
            soil.m_128405_("size", pollutionSoilChunk.size());
            air.m_128405_("size", pollutionAirChunk.size());
            for (i = 0; i < pollutionSoilChunk.size(); ++i) {
                chunkLevel = pollutionSoilChunk.get(i);
                if (chunkLevel == null) continue;
                soil.m_128365_(String.valueOf(i), (Tag)chunkLevel.writeCompound());
            }
            for (i = 0; i < pollutionAirChunk.size(); ++i) {
                chunkLevel = pollutionAirChunk.get(i);
                if (chunkLevel == null) continue;
                air.m_128365_(String.valueOf(i), (Tag)chunkLevel.writeCompound());
            }
            nbtTagCompound.m_128365_("air", (Tag)air);
            nbtTagCompound.m_128365_("soil", (Tag)soil);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return nbtTagCompound;
    }

    public void addSoilPollutionMechanism(IPollutionMechanism pollutionMechanism) {
        if (pollutionMechanism == null) {
            return;
        }
        List<IPollutionMechanism> pollution = this.pollutionSoilChunks.get(pollutionMechanism.getChunkPos());
        if (pollution == null) {
            pollution = new ArrayList<IPollutionMechanism>();
            pollution.add(pollutionMechanism);
            this.pollutionSoilChunks.put(pollutionMechanism.getChunkPos(), pollution);
        } else {
            pollution.add(pollutionMechanism);
        }
    }

    public ChunkLevel getChunkLevelAir(ChunkPos chunkPos) {
        return this.pollutionAir.get(chunkPos);
    }

    public ChunkLevel getChunkLevelSoil(ChunkPos chunkPos) {
        return this.pollutionSoil.get(chunkPos);
    }

    public void addChunkLevelSoil(ChunkLevel level) {
        this.pollutionSoil.put(level.getPos(), level);
    }

    public Vec2f getVector(EnumWindSide windSide) {
        switch (windSide) {
            case E: {
                return new Vec2f(1, 0);
            }
            case W: {
                return new Vec2f(-1, 0);
            }
            case N: {
                return new Vec2f(0, 1);
            }
            case S: {
                return new Vec2f(0, -1);
            }
            case NE: {
                return new Vec2f(1, 1);
            }
            case NW: {
                return new Vec2f(-1, 1);
            }
            case SE: {
                return new Vec2f(1, -1);
            }
            case SW: {
                return new Vec2f(-1, -1);
            }
        }
        return new Vec2f(0, 0);
    }

    public void tick(Level world) {
        ChunkLevel chunkLevel;
        if (world.m_46467_() % 20L != 0L) {
            return;
        }
        HashSet<Map.Entry<ChunkPos, ChunkLevel>> entries = new HashSet<Map.Entry<ChunkPos, ChunkLevel>>(this.pollutionAir.entrySet());
        EnumWindSide windSide = this.wind.getWindSide();
        Vec2f vector = this.getVector(windSide);
        EnumTypeWind windLevel = this.wind.getEnumTypeWind();
        if (((Boolean)ModConfig.COMMON.airPollution.get()).booleanValue()) {
            entries.parallelStream().forEach(entry -> {
                ChunkLevel chunkLevel = (ChunkLevel)entry.getValue();
                double distance = this.calculateDistance(chunkLevel.getDefaultPos(), chunkLevel.getPos());
                if (this.canChange(windLevel) && distance <= 10.0) {
                    this.pollutionAir.remove(entry.getKey());
                    chunkLevel.addChunkPos(vector.x, vector.y);
                    this.pollutionAir.put(chunkLevel.getPos(), chunkLevel);
                }
            });
        }
        if (((Boolean)ModConfig.COMMON.soilPollution.get()).booleanValue() && world.m_46467_() % 6000L == 0L) {
            for (Map.Entry<ChunkPos, ChunkLevel> entry2 : this.pollutionSoil.entrySet()) {
                chunkLevel = entry2.getValue();
                if (chunkLevel == null) continue;
                chunkLevel.setPollution(chunkLevel.getPollution() / 2.0);
                if (!(chunkLevel.getPollution() < 2.0) || chunkLevel.getLevelPollution() == LevelPollution.VERY_LOW) continue;
                chunkLevel.setPollution(10.0);
                chunkLevel.setLevelPollution(LevelPollution.values()[Math.max(0, chunkLevel.getLevelPollution().ordinal() - 1)]);
            }
        }
        if (world.m_46467_() % 6000L == 0L && ((Boolean)ModConfig.COMMON.airPollution.get()).booleanValue()) {
            for (Map.Entry<ChunkPos, Object> entry3 : this.pollutionAir.entrySet()) {
                chunkLevel = (ChunkLevel)entry3.getValue();
                if (chunkLevel == null) continue;
                chunkLevel.setPollution(chunkLevel.getPollution() / 2.0);
                if (!(chunkLevel.getPollution() < 2.0) || chunkLevel.getLevelPollution() == LevelPollution.VERY_LOW) continue;
                chunkLevel.setPollution(10.0);
                chunkLevel.setLevelPollution(LevelPollution.values()[Math.max(0, chunkLevel.getLevelPollution().ordinal() - 1)]);
            }
        }
        if (((Boolean)ModConfig.COMMON.airPollution.get()).booleanValue()) {
            for (Map.Entry<ChunkPos, Object> entry4 : this.pollutionAirChunks.entrySet()) {
                chunkLevel = this.pollutionAir.get(entry4.getKey());
                if (chunkLevel == null) {
                    chunkLevel = new ChunkLevel(entry4.getKey(), LevelPollution.VERY_LOW, 0.0);
                    for (IPollutionMechanism pollutionMechanism : (List)entry4.getValue()) {
                        chunkLevel.addPollution(pollutionMechanism.getPollution());
                    }
                    this.pollutionAir.put(chunkLevel.getPos(), chunkLevel);
                    continue;
                }
                for (IPollutionMechanism pollutionMechanism : (List)entry4.getValue()) {
                    chunkLevel.addPollution(pollutionMechanism.getPollution());
                }
            }
        }
        if (((Boolean)ModConfig.COMMON.soilPollution.get()).booleanValue()) {
            for (Map.Entry<ChunkPos, Object> entry5 : this.pollutionSoilChunks.entrySet()) {
                chunkLevel = this.pollutionSoil.get(entry5.getKey());
                if (chunkLevel == null) {
                    chunkLevel = new ChunkLevel(entry5.getKey(), LevelPollution.VERY_LOW, 0.0);
                    for (IPollutionMechanism pollutionMechanism : (List)entry5.getValue()) {
                        chunkLevel.addPollution(pollutionMechanism.getPollution());
                    }
                    this.pollutionSoil.put(chunkLevel.getPos(), chunkLevel);
                    continue;
                }
                for (IPollutionMechanism pollutionMechanism : (List)entry5.getValue()) {
                    chunkLevel.addPollution(pollutionMechanism.getPollution());
                }
            }
        }
    }

    public double calculateDistance(ChunkPos pos1, ChunkPos pos2) {
        int xDiff = pos1.f_45578_ - pos2.f_45578_;
        int zDiff = pos1.f_45579_ - pos2.f_45579_;
        return Math.sqrt(xDiff * xDiff + zDiff * zDiff);
    }

    private boolean canChange(EnumTypeWind windLevel) {
        return this.random.nextInt(100 - windLevel.ordinal() * 5) == 0;
    }
}

