/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.reactors;

import com.denfop.api.reactors.IGraphiteReactor;
import com.denfop.api.reactors.LogicComponent;
import com.denfop.api.reactors.LogicReactor;
import com.denfop.blocks.FluidName;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class LogicGraphiteReactor
extends LogicReactor {
    private final IGraphiteReactor graphiteReactor;
    public double temp_heat = 0.0;
    Map<Integer, Double> mapGraphiteConsume;

    public LogicGraphiteReactor(IGraphiteReactor advReactor) {
        super(advReactor);
        this.graphiteReactor = advReactor;
    }

    @Override
    public void calculateComponent() {
        super.calculateComponent();
        this.mapGraphiteConsume = new HashMap<Integer, Double>();
        for (int i = 0; i < this.x; ++i) {
            double col = 0.0;
            for (LogicComponent component : this.rodsList) {
                if (component.getX() != i) continue;
                col += component.heat * 0.83 / 160.0;
            }
            this.mapGraphiteConsume.put(i, col);
        }
    }

    @Override
    public void onTick() {
        if (this.rodsList.isEmpty()) {
            if (this.temp_heat >= 1.0) {
                this.temp_heat -= (double)rand.nextInt((int)this.temp_heat);
            }
            this.reactor.setOutput(0.0);
        } else {
            if (this.graphiteReactor.canWorkWithGraphite()) {
                super.onTick();
                if (!this.graphiteReactor.isFull()) {
                    return;
                }
                if (this.temp_heat < this.getMaxHeat() && this.getMaxHeat() != 0.0) {
                    double temp = this.getMaxHeat() - this.temp_heat;
                    this.temp_heat += (double)rand.nextInt(Math.max((int)temp, 1));
                }
                this.temp_heat = this.graphiteReactor.workCoolant(this.temp_heat);
                for (int i = 0; i < this.reactor.getWidth(); ++i) {
                    if (this.mapGraphiteConsume.get(i) == 0.0) continue;
                    double col = this.mapGraphiteConsume.get(i);
                    if (this.graphiteReactor.getFuelGraphite(i) > col) {
                        this.graphiteReactor.consumeFuelGraphite(i, col);
                        int level = this.graphiteReactor.getLevelGraphite(i);
                        if ((double)this.graphiteReactor.getWaterTank().getFluidAmount() >= col * (double)level) {
                            if ((double)this.graphiteReactor.getSteamTank().getFluidAmount() + col * (double)level <= (double)this.graphiteReactor.getSteamTank().getCapacity()) {
                                this.graphiteReactor.getWaterTank().drain((int)(col * (double)level), IFluidHandler.FluidAction.EXECUTE);
                                this.graphiteReactor.getSteamTank().fill(new FluidStack((Fluid)FluidName.fluidsteam.getInstance().get(), (int)(col * (double)level)), IFluidHandler.FluidAction.EXECUTE);
                                if (this.temp_heat > this.getMaxHeat()) {
                                    this.temp_heat -= (double)rand.nextInt((int)(this.temp_heat - this.getMaxHeat()));
                                    if (this.temp_heat < 0.0) {
                                        this.temp_heat = 0.0;
                                    }
                                }
                                if (!((double)this.graphiteReactor.getSteamTank().getFluidAmount() >= col) || !((double)this.graphiteReactor.getCoalDioxideTank().getFluidAmount() >= col * (double)level)) continue;
                                if ((double)this.graphiteReactor.getOxideTank().getFluidAmount() + col * (double)level <= (double)this.graphiteReactor.getOxideTank().getFluidAmount()) {
                                    this.graphiteReactor.getSteamTank().drain((int)col, IFluidHandler.FluidAction.EXECUTE);
                                }
                                this.graphiteReactor.getCoalDioxideTank().drain((int)(col * (double)level), IFluidHandler.FluidAction.EXECUTE);
                                this.graphiteReactor.getOxideTank().fill(new FluidStack((Fluid)FluidName.fluidoxy.getInstance().get(), (int)(col * (double)level)), IFluidHandler.FluidAction.EXECUTE);
                                this.temp_heat -= (double)rand.nextInt((int)(10.0 * col));
                                if (!(this.temp_heat < 0.0)) continue;
                                this.temp_heat = 0.0;
                                continue;
                            }
                            this.temp_heat += (double)rand.nextInt(50);
                            continue;
                        }
                        if ((double)this.graphiteReactor.getCoalDioxideTank().getFluidAmount() + col * (double)level <= (double)this.graphiteReactor.getCoalDioxideTank().getCapacity()) {
                            if ((double)this.graphiteReactor.getSteamTank().getFluidAmount() >= col) {
                                if (!((double)this.graphiteReactor.getCoalDioxideTank().getFluidAmount() >= col * (double)level) || !((double)this.graphiteReactor.getOxideTank().getFluidAmount() + col * (double)level <= (double)this.graphiteReactor.getOxideTank().getFluidAmount())) continue;
                                this.graphiteReactor.getSteamTank().drain((int)col, IFluidHandler.FluidAction.EXECUTE);
                                this.graphiteReactor.getCoalDioxideTank().drain((int)(col * (double)level), IFluidHandler.FluidAction.EXECUTE);
                                this.graphiteReactor.getOxideTank().fill(new FluidStack((Fluid)FluidName.fluidoxy.getInstance().get(), (int)(col * (double)level)), IFluidHandler.FluidAction.EXECUTE);
                                this.temp_heat -= (double)rand.nextInt((int)(10.0 * col));
                                if (!(this.temp_heat < 0.0)) continue;
                                this.temp_heat = 0.0;
                                continue;
                            }
                            this.temp_heat += (double)rand.nextInt(50);
                            continue;
                        }
                        this.temp_heat += (double)rand.nextInt(100);
                        continue;
                    }
                    if (!this.graphiteReactor.getGraphite(i).m_41619_()) {
                        this.graphiteReactor.consumeGraphite(i);
                        if (this.graphiteReactor.getFuelGraphite(i) < col) {
                            this.temp_heat += (double)rand.nextInt(100);
                            continue;
                        }
                        this.graphiteReactor.consumeFuelGraphite(i, col);
                        continue;
                    }
                    this.temp_heat += (double)rand.nextInt((int)(30.0 * col));
                }
            } else {
                this.temp_heat += (double)rand.nextInt(200);
                this.reactor.setOutput(0.0);
            }
            if (this.temp_heat < 0.0) {
                this.temp_heat = 0.0;
            }
            this.graphiteReactor.setHeat(this.temp_heat);
        }
    }

    public double getTemp_heat() {
        return this.temp_heat;
    }

    public void setTemp_heat(double temp_heat) {
        this.temp_heat = temp_heat;
    }
}

