/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.space.colonies;

import com.denfop.api.space.IBody;
import com.denfop.api.space.SpaceNet;
import com.denfop.api.space.colonies.api.IColony;
import com.denfop.api.space.colonies.api.IColonyBuilding;
import com.denfop.api.space.colonies.api.building.IBuildingHouse;
import com.denfop.api.space.colonies.api.building.IColonyMiningFactory;
import com.denfop.api.space.colonies.api.building.IColonyStorage;
import com.denfop.api.space.colonies.api.building.IEntertainment;
import com.denfop.api.space.colonies.api.building.IFactory;
import com.denfop.api.space.colonies.api.building.IGenerator;
import com.denfop.api.space.colonies.api.building.IOxygenFactory;
import com.denfop.api.space.colonies.api.building.IProtectionBuilding;
import com.denfop.api.space.colonies.api.building.IStorage;
import com.denfop.api.space.colonies.building.ColonyEntertainment;
import com.denfop.api.space.colonies.building.ColonyHouse;
import com.denfop.api.space.colonies.building.ColonyPanelFactory;
import com.denfop.api.space.colonies.building.Factory;
import com.denfop.api.space.colonies.building.FluidFactory;
import com.denfop.api.space.colonies.building.ItemFactory;
import com.denfop.api.space.colonies.building.OxygenFactory;
import com.denfop.api.space.colonies.building.ProtectionBuilding;
import com.denfop.api.space.colonies.building.StorageBuilding;
import com.denfop.api.space.colonies.enums.EnumHouses;
import com.denfop.api.space.colonies.enums.EnumProblems;
import com.denfop.network.packet.CustomPacketBuffer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class Colony
implements IColony {
    private final IBody body;
    byte tick = 0;
    private UUID fakeplayer;
    private List<IColonyBuilding> list;
    private List<IBuildingHouse> buildingHouseList;
    private List<IFactory> factories;
    private List<IColonyMiningFactory> buildingMiningList;
    private List<IGenerator> generators;
    private List<IOxygenFactory> oxygenFactoriesList;
    private List<EnumProblems> enumProblemsList;
    private List<IStorage> storageList;
    private int energy;
    private int food;
    private int maxenergy = 0;
    private int oxygen = 0;
    private int maxoxygen = 0;
    private int freeWorkers = 0;
    private int workers = 0;
    private short needWorkers = 0;
    private byte toDelete;
    private int protection;
    private List<IProtectionBuilding> protections;
    private List<IEntertainment> entertainments;
    private List<IColonyStorage> colonyStorages;
    private short entertainment;
    private short level;
    private int experience;
    private int generationEnergy;
    private int generationFood;
    private int generationOxygen;
    private int usingEnergy;
    private int usingFood;
    private int usingOxygen;
    private byte timeUsingResetEnergy;
    private byte timeUsingResetFood;
    private byte timeUsingResetOxygen;
    private byte timeResetEnergy;
    private byte timeResetFood;
    private byte timeResetOxygen;
    private boolean auto;
    private byte timeWork = 0;
    private short timeToSend = (short)300;

    public Colony(IBody body, UUID player) {
        this.body = body;
        this.list = new ArrayList<IColonyBuilding>();
        this.toDelete = (byte)120;
        this.fakeplayer = player;
        this.level = 1;
        this.experience = 0;
        this.enumProblemsList = new LinkedList<EnumProblems>();
        this.storageList = new LinkedList<IStorage>();
        this.colonyStorages = new LinkedList<IColonyStorage>();
        this.buildingHouseList = new LinkedList<IBuildingHouse>();
        this.buildingMiningList = new LinkedList<IColonyMiningFactory>();
        this.oxygenFactoriesList = new LinkedList<IOxygenFactory>();
        this.protections = new LinkedList<IProtectionBuilding>();
        this.factories = new LinkedList<IFactory>();
        this.generators = new LinkedList<IGenerator>();
        this.entertainments = new LinkedList<IEntertainment>();
        this.food = 300;
        this.energy = 300;
    }

    public Colony(CustomPacketBuffer packetBuffer) {
        int i;
        this.enumProblemsList = new LinkedList<EnumProblems>();
        this.storageList = new LinkedList<IStorage>();
        this.buildingHouseList = new LinkedList<IBuildingHouse>();
        this.buildingMiningList = new LinkedList<IColonyMiningFactory>();
        this.oxygenFactoriesList = new LinkedList<IOxygenFactory>();
        this.entertainments = new LinkedList<IEntertainment>();
        this.factories = new LinkedList<IFactory>();
        this.colonyStorages = new LinkedList<IColonyStorage>();
        this.generators = new LinkedList<IGenerator>();
        this.protections = new LinkedList<IProtectionBuilding>();
        this.body = SpaceNet.instance.getBodyFromName(packetBuffer.readString());
        this.level = packetBuffer.readShort();
        this.experience = packetBuffer.readInt();
        this.fakeplayer = packetBuffer.m_130259_();
        this.energy = packetBuffer.readInt();
        this.oxygen = packetBuffer.readInt();
        this.food = packetBuffer.readInt();
        this.needWorkers = packetBuffer.readShort();
        this.workers = packetBuffer.readInt();
        this.toDelete = packetBuffer.readByte();
        int size = packetBuffer.readInt();
        this.generationOxygen = packetBuffer.readInt();
        this.generationEnergy = packetBuffer.readInt();
        this.generationFood = packetBuffer.readInt();
        this.usingOxygen = packetBuffer.readInt();
        this.usingEnergy = packetBuffer.readInt();
        this.usingFood = packetBuffer.readInt();
        this.entertainment = (short)packetBuffer.readInt();
        this.auto = packetBuffer.readBoolean();
        int size1 = packetBuffer.readByte();
        this.enumProblemsList = new ArrayList<EnumProblems>();
        for (i = 0; i < size1; ++i) {
            this.enumProblemsList.add(EnumProblems.values()[packetBuffer.readByte()]);
        }
        this.list = new LinkedList<IColonyBuilding>();
        block12: for (i = 0; i < size; ++i) {
            byte type = packetBuffer.readByte();
            switch (type) {
                case 5: {
                    new OxygenFactory(packetBuffer, this);
                    continue block12;
                }
                case 7: {
                    new StorageBuilding(packetBuffer, this);
                    continue block12;
                }
                case 0: {
                    new ColonyHouse(packetBuffer, this);
                    continue block12;
                }
                case 1: {
                    new ColonyPanelFactory(packetBuffer, this);
                    continue block12;
                }
                case 2: {
                    new Factory(packetBuffer, this);
                    continue block12;
                }
                case 6: {
                    new ProtectionBuilding(packetBuffer, this);
                    continue block12;
                }
                case 3: {
                    new FluidFactory(packetBuffer, this);
                    continue block12;
                }
                case 4: {
                    new ItemFactory(packetBuffer, this);
                    continue block12;
                }
                case 8: {
                    new ColonyEntertainment(packetBuffer, this);
                }
            }
        }
    }

    public Colony(CompoundTag tag, UUID fakeplayer) {
        this.body = SpaceNet.instance.getBodyFromName(tag.m_128461_("name"));
        this.fakeplayer = fakeplayer;
        this.enumProblemsList = new LinkedList<EnumProblems>();
        this.storageList = new LinkedList<IStorage>();
        this.buildingHouseList = new LinkedList<IBuildingHouse>();
        this.buildingMiningList = new LinkedList<IColonyMiningFactory>();
        this.oxygenFactoriesList = new LinkedList<IOxygenFactory>();
        this.factories = new LinkedList<IFactory>();
        this.generators = new LinkedList<IGenerator>();
        this.entertainments = new LinkedList<IEntertainment>();
        this.protections = new LinkedList<IProtectionBuilding>();
        this.colonyStorages = new LinkedList<IColonyStorage>();
        ListTag list1 = tag.m_128437_("building", 10);
        this.list = new LinkedList<IColonyBuilding>();
        block11: for (int i = 0; i < list1.size(); ++i) {
            CompoundTag nbt = list1.m_128728_(i);
            byte type = nbt.m_128445_("type");
            switch (type) {
                case 5: {
                    new OxygenFactory(nbt, (IColony)this);
                    continue block11;
                }
                case 7: {
                    new StorageBuilding(nbt, (IColony)this);
                    continue block11;
                }
                case 0: {
                    new ColonyHouse(nbt, (IColony)this);
                    continue block11;
                }
                case 1: {
                    new ColonyPanelFactory(nbt, (IColony)this);
                    continue block11;
                }
                case 2: {
                    new Factory(nbt, (IColony)this);
                    continue block11;
                }
                case 6: {
                    new ProtectionBuilding(nbt, (IColony)this);
                    continue block11;
                }
                case 3: {
                    new FluidFactory(nbt, (IColony)this);
                    continue block11;
                }
                case 4: {
                    new ItemFactory(nbt, (IColony)this);
                    continue block11;
                }
                case 8: {
                    new ColonyEntertainment(nbt, (IColony)this);
                }
            }
        }
        this.list = new ArrayList<IColonyBuilding>(this.list);
        this.energy = tag.m_128451_("energy");
        this.oxygen = tag.m_128451_("oxygen");
        this.food = tag.m_128451_("food");
        this.needWorkers = tag.m_128448_("needWorkers");
        this.workers = tag.m_128451_("workers");
        this.level = tag.m_128448_("level");
        this.experience = tag.m_128451_("experience");
        this.toDelete = tag.m_128445_("toDelete");
        this.auto = tag.m_128471_("auto");
        this.timeToSend = tag.m_128448_("timeToSend");
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer customPacketBuffer = new CustomPacketBuffer();
        customPacketBuffer.writeString(this.body.getName());
        customPacketBuffer.writeShort(this.level);
        customPacketBuffer.writeInt(this.experience);
        customPacketBuffer.m_130077_(this.fakeplayer);
        customPacketBuffer.writeInt(this.energy);
        customPacketBuffer.writeInt(this.oxygen);
        customPacketBuffer.writeInt(this.food);
        customPacketBuffer.writeShort(this.needWorkers);
        customPacketBuffer.writeInt(this.workers);
        customPacketBuffer.writeByte(this.toDelete);
        customPacketBuffer.writeInt(this.list.size());
        customPacketBuffer.writeInt(this.generationOxygen);
        customPacketBuffer.writeInt(this.generationEnergy);
        customPacketBuffer.writeInt(this.generationFood);
        customPacketBuffer.writeInt(this.usingOxygen);
        customPacketBuffer.writeInt(this.usingEnergy);
        customPacketBuffer.writeInt(this.usingFood);
        customPacketBuffer.writeInt(this.entertainment);
        customPacketBuffer.writeBoolean(this.auto);
        customPacketBuffer.writeByte(this.enumProblemsList.size());
        for (EnumProblems problems : this.enumProblemsList) {
            customPacketBuffer.writeByte((byte)problems.ordinal());
        }
        for (IColonyBuilding building : this.list) {
            building.writePacket(customPacketBuffer);
        }
        return customPacketBuffer;
    }

    @Override
    public List<ItemStack> getStacksFromStorage() {
        LinkedList<ItemStack> itemStackList = new LinkedList<ItemStack>();
        for (IStorage storage : this.storageList) {
            itemStackList.addAll(storage.getStacks());
        }
        return new ArrayList<ItemStack>(itemStackList);
    }

    @Override
    public List<FluidStack> getFluidsFromStorage() {
        LinkedList<FluidStack> itemStackList = new LinkedList<FluidStack>();
        for (IStorage storage : this.storageList) {
            itemStackList.addAll(storage.getFluidStacks());
        }
        return new ArrayList<FluidStack>(itemStackList);
    }

    @Override
    public boolean isAuto() {
        return this.auto;
    }

    @Override
    public void setAuto(boolean auto) {
        this.auto = auto;
    }

    @Override
    public int getProtection() {
        return this.protection;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public int getExperience() {
        return this.experience;
    }

    @Override
    public int getAvailableBuilding() {
        return this.getMaxBuilding() - this.list.size();
    }

    @Override
    public int getMaxBuilding() {
        return (int)(8.0 + (double)(this.level - 1) * 2.5);
    }

    @Override
    public int getMaxExperience() {
        return 900 + 400 * (this.level - 1);
    }

    @Override
    public boolean matched(IBody body) {
        return this.body == body;
    }

    @Override
    public IBody getBody() {
        return this.body;
    }

    @Override
    public UUID getFakePlayer() {
        return this.fakeplayer;
    }

    @Override
    public List<EnumProblems> getProblems() {
        return this.enumProblemsList;
    }

    @Override
    public int getEnergy() {
        return this.energy;
    }

    @Override
    public int getMaxEnergy() {
        return this.maxenergy;
    }

    @Override
    public int getOxygen() {
        return this.oxygen;
    }

    @Override
    public int getTimeToDelete() {
        return this.toDelete;
    }

    @Override
    public int getMaxOxygen() {
        return this.maxoxygen;
    }

    @Override
    public byte getTick() {
        return this.tick;
    }

    @Override
    public void update() {
        if (!this.enumProblemsList.isEmpty()) {
            if (this.toDelete > 0 && this.workers == 0) {
                this.toDelete = (byte)(this.toDelete - 1);
            }
            this.enumProblemsList.clear();
        } else {
            if (this.toDelete < 120) {
                this.toDelete = (byte)120;
                this.tick = 0;
            }
            if (this.level < 100 && this.tick == 10) {
                this.tick = 0;
                this.experience += this.workers;
                if (this.experience >= this.getMaxExperience()) {
                    this.level = (short)(this.level + 1);
                    this.experience = 0;
                }
            }
        }
        this.tick = (byte)(this.tick + 1);
        if (this.tick > 10) {
            this.tick = 0;
        }
        if (this.auto) {
            this.timeToSend = (short)(this.timeToSend - 1);
            if (this.timeToSend == 0) {
                this.timeToSend = (short)300;
                SpaceNet.instance.getColonieNet().sendResourceToPlanet(this.getFakePlayer(), this.body);
            }
        } else {
            this.timeToSend = (short)300;
        }
        if (this.needWorkers > 0) {
            if (this.freeWorkers > 0) {
                block0: for (IBuildingHouse buildingHouse : this.buildingHouseList) {
                    int addWorkers;
                    int needWorkers;
                    if (buildingHouse.getFreeWorkers() <= 0) continue;
                    int free = buildingHouse.getFreeWorkers();
                    for (IFactory iFactory : this.factories) {
                        needWorkers = iFactory.needWorkers();
                        if (needWorkers <= 0) continue;
                        addWorkers = Math.min(needWorkers, free);
                        iFactory.addWorkers(addWorkers);
                        this.needWorkers = (short)(this.needWorkers - (short)addWorkers);
                        this.workers += addWorkers;
                        this.freeWorkers -= addWorkers;
                        buildingHouse.removeFreeWorkers(addWorkers);
                        if (this.needWorkers > 0 && (free -= addWorkers) > 0) continue;
                        break;
                    }
                    if (this.needWorkers > 0 && free > 0) {
                        for (IColonyMiningFactory iColonyMiningFactory : this.buildingMiningList) {
                            needWorkers = iColonyMiningFactory.needWorkers();
                            if (needWorkers <= 0) continue;
                            addWorkers = Math.min(needWorkers, free);
                            iColonyMiningFactory.addWorkers(addWorkers);
                            this.workers += addWorkers;
                            this.needWorkers = (short)(this.needWorkers - addWorkers);
                            this.freeWorkers -= addWorkers;
                            buildingHouse.removeFreeWorkers(addWorkers);
                            if (this.needWorkers > 0 && (free -= addWorkers) > 0) continue;
                            break;
                        }
                    }
                    if (this.needWorkers > 0 && free > 0) {
                        for (IOxygenFactory iOxygenFactory : this.oxygenFactoriesList) {
                            needWorkers = iOxygenFactory.needWorkers();
                            if (needWorkers <= 0) continue;
                            addWorkers = Math.min(needWorkers, free);
                            iOxygenFactory.addWorkers(addWorkers);
                            this.workers += addWorkers;
                            this.needWorkers = (short)(this.needWorkers - addWorkers);
                            this.freeWorkers -= addWorkers;
                            buildingHouse.removeFreeWorkers(addWorkers);
                            if (this.needWorkers > 0 && (free -= addWorkers) > 0) continue;
                            break;
                        }
                    }
                    if (this.needWorkers > 0 && free > 0) {
                        for (IProtectionBuilding iProtectionBuilding : this.protections) {
                            needWorkers = iProtectionBuilding.needWorkers();
                            if (needWorkers <= 0) continue;
                            addWorkers = Math.min(needWorkers, free);
                            iProtectionBuilding.addWorkers(addWorkers);
                            this.workers += addWorkers;
                            this.needWorkers = (short)(this.needWorkers - addWorkers);
                            this.freeWorkers -= addWorkers;
                            buildingHouse.removeFreeWorkers(addWorkers);
                            if (this.needWorkers > 0 && (free -= addWorkers) > 0) continue;
                            break;
                        }
                    }
                    if (this.needWorkers > 0 && free > 0) {
                        for (IGenerator iGenerator : this.generators) {
                            needWorkers = iGenerator.needWorkers();
                            if (needWorkers <= 0) continue;
                            addWorkers = Math.min(needWorkers, free);
                            iGenerator.addWorkers(addWorkers);
                            this.workers += addWorkers;
                            this.needWorkers = (short)(this.needWorkers - addWorkers);
                            this.freeWorkers -= addWorkers;
                            buildingHouse.removeFreeWorkers(addWorkers);
                            if (this.needWorkers > 0 && (free -= addWorkers) > 0) continue;
                            break;
                        }
                    }
                    if (this.needWorkers > 0 && free > 0) {
                        for (IEntertainment iEntertainment : this.entertainments) {
                            needWorkers = iEntertainment.needWorkers();
                            if (needWorkers <= 0) continue;
                            addWorkers = Math.min(needWorkers, free);
                            iEntertainment.addWorkers(addWorkers);
                            this.workers += addWorkers;
                            this.needWorkers = (short)(this.needWorkers - addWorkers);
                            this.freeWorkers -= addWorkers;
                            buildingHouse.removeFreeWorkers(addWorkers);
                            if (this.needWorkers > 0 && (free -= addWorkers) > 0) continue;
                            break;
                        }
                    }
                    if (this.needWorkers <= 0 || free <= 0) continue;
                    for (IColonyStorage iColonyStorage : this.colonyStorages) {
                        needWorkers = iColonyStorage.needWorkers();
                        if (needWorkers <= 0) continue;
                        addWorkers = Math.min(needWorkers, free);
                        iColonyStorage.addWorkers(addWorkers);
                        this.workers += addWorkers;
                        this.needWorkers = (short)(this.needWorkers - addWorkers);
                        this.freeWorkers -= addWorkers;
                        buildingHouse.removeFreeWorkers(addWorkers);
                        if (this.needWorkers > 0 && (free -= addWorkers) > 0) continue;
                        continue block0;
                    }
                }
            }
            if (this.needWorkers > 0) {
                this.enumProblemsList.add(EnumProblems.WORKERS);
            }
            return;
        }
        this.entertainment = 0;
        this.protection = 0;
        for (IProtectionBuilding protectionBuilding : this.protections) {
            protectionBuilding.work();
        }
        for (IEntertainment entertainment : this.entertainments) {
            entertainment.work();
        }
        for (IColonyBuilding building : this.list) {
            if (building.isIgnore()) continue;
            building.work();
        }
        if (this.list.size() * 2 > this.protection) {
            this.enumProblemsList.add(EnumProblems.PROTECTION);
        }
    }

    @Override
    public List<IEntertainment> getEntertainments() {
        return this.entertainments;
    }

    @Override
    public double getPercentEntertainment() {
        if (this.level < 7) {
            return 1.0;
        }
        if (this.entertainment == 0) {
            return 0.8;
        }
        return Math.min(1.5, Math.max(0.8, (double)this.entertainment * 1.0 / (double)this.workers));
    }

    @Override
    public void useEnergy(int energy) {
        if (this.timeUsingResetEnergy != this.tick) {
            this.timeUsingResetEnergy = this.tick;
            this.usingEnergy = 0;
        }
        this.usingEnergy += energy;
        this.energy -= energy;
    }

    @Override
    public List<IColonyBuilding> getColonyBuilding() {
        return this.list;
    }

    @Override
    public void useOxygen(int oxygen) {
        if (this.timeUsingResetOxygen != this.tick) {
            this.timeUsingResetOxygen = this.tick;
            this.usingOxygen = 0;
        }
        this.usingOxygen += oxygen;
        this.oxygen -= (short)oxygen;
    }

    @Override
    public void addOxygen(int oxygen) {
        if (this.timeResetOxygen != this.tick) {
            this.timeResetOxygen = this.tick;
            this.generationOxygen = 0;
        }
        this.generationOxygen += oxygen;
        this.oxygen += oxygen;
        if (this.oxygen >= this.maxoxygen) {
            this.oxygen = this.maxoxygen;
        }
    }

    @Override
    public List<IBuildingHouse> getBuildingHouseList() {
        return this.buildingHouseList;
    }

    @Override
    public List<IColonyMiningFactory> getBuildingMiningList() {
        return this.buildingMiningList;
    }

    @Override
    public byte getToDelete() {
        return this.toDelete;
    }

    @Override
    public int getWorkers() {
        return this.workers;
    }

    @Override
    public int getFreeWorkers() {
        return this.freeWorkers;
    }

    @Override
    public List<IFactory> getFactories() {
        return this.factories;
    }

    @Override
    public List<IGenerator> getGenerators() {
        return this.generators;
    }

    @Override
    public short getNeedWorkers() {
        return this.needWorkers;
    }

    @Override
    public int getMaxenergy() {
        return this.maxenergy;
    }

    @Override
    public int getMaxoxygen() {
        return this.maxoxygen;
    }

    @Override
    public List<EnumProblems> getEnumProblemsList() {
        return this.enumProblemsList;
    }

    @Override
    public List<IColonyBuilding> getList() {
        return this.list;
    }

    @Override
    public List<IOxygenFactory> getOxygenFactoriesList() {
        return this.oxygenFactoriesList;
    }

    @Override
    public List<IProtectionBuilding> getProtections() {
        return this.protections;
    }

    @Override
    public int getGenerationEnergy() {
        return this.generationEnergy;
    }

    @Override
    public int getGenerationFood() {
        return this.generationFood;
    }

    @Override
    public int getGenerationOxygen() {
        return this.generationOxygen;
    }

    @Override
    public void addEnergy(int energy) {
        if (this.timeResetEnergy != this.tick) {
            this.timeResetEnergy = this.tick;
            this.generationEnergy = 0;
        }
        this.generationEnergy += energy;
        this.energy += energy;
        if (this.energy >= this.maxenergy) {
            this.energy = this.maxenergy;
        }
    }

    @Override
    public void addMaxOxygen(int oxygen) {
        this.maxoxygen += oxygen;
    }

    @Override
    public void addMaxEnergy(int energy) {
        this.maxenergy += energy;
    }

    @Override
    public CompoundTag writeNBT(CompoundTag tag) {
        tag.m_128359_("name", this.body.getName());
        tag.m_128405_("workers", (int)((short)this.workers));
        tag.m_128376_("needWorkers", this.needWorkers);
        tag.m_128405_("energy", this.energy);
        tag.m_128405_("food", this.food);
        tag.m_128405_("oxygen", this.oxygen);
        tag.m_128344_("toDelete", this.toDelete);
        tag.m_128376_("level", this.level);
        tag.m_128379_("auto", this.auto);
        tag.m_128376_("timeToSend", this.timeToSend);
        tag.m_128405_("experience", this.experience);
        ListTag tagList = new ListTag();
        for (IColonyBuilding iColonyBuilding : this.list) {
            tagList.add((Object)iColonyBuilding.writeTag(new CompoundTag()));
        }
        tag.m_128365_("building", (Tag)tagList);
        return tag;
    }

    @Override
    public List<IColonyBuilding> getBuildingList() {
        return this.list;
    }

    @Override
    public void addBuilding(IColonyBuilding building) {
        this.list.add(building);
        switch (building.getTypeBuilding()) {
            case HOUSES: {
                this.freeWorkers += ((IBuildingHouse)building).getFreeWorkers();
                this.buildingHouseList.add((IBuildingHouse)building);
                break;
            }
            case FABRIC: {
                if (building instanceof IFactory) {
                    this.needWorkers = (short)(this.needWorkers + ((IFactory)building).needWorkers());
                    this.factories.add((IFactory)building);
                    break;
                }
                if (!(building instanceof IColonyMiningFactory)) break;
                this.needWorkers = (short)(this.needWorkers + ((IColonyMiningFactory)building).needWorkers());
                this.buildingMiningList.add((IColonyMiningFactory)building);
                break;
            }
            case OXYGEN: {
                this.needWorkers = (short)(this.needWorkers + ((IOxygenFactory)((Object)building)).needWorkers());
                this.oxygenFactoriesList.add((IOxygenFactory)((Object)building));
                break;
            }
            case GENERATORS: {
                this.needWorkers = (short)(this.needWorkers + ((IGenerator)building).needWorkers());
                this.generators.add((IGenerator)building);
                break;
            }
            case PROTECTION: {
                this.needWorkers = (short)(this.needWorkers + ((IProtectionBuilding)building).needWorkers());
                this.protections.add((IProtectionBuilding)building);
                break;
            }
            case ENTERTAINMENT: {
                this.needWorkers = (short)(this.needWorkers + ((IEntertainment)building).needWorkers());
                this.entertainments.add((IEntertainment)building);
                break;
            }
            case STORAGE: {
                this.needWorkers = (short)(this.needWorkers + ((IColonyStorage)((Object)building)).needWorkers());
                this.colonyStorages.add((IColonyStorage)((Object)building));
            }
        }
    }

    @Override
    public List<IStorage> getStorageList() {
        return this.storageList;
    }

    @Override
    public void addStorage(IStorage storage) {
        this.storageList.add(storage);
    }

    @Override
    public int getNeededWorkers() {
        return this.needWorkers;
    }

    @Override
    public int getMaxWorkers() {
        return this.workers;
    }

    @Override
    public void removeWorkers(int i) {
        int addWorkers;
        int needWorkers;
        for (IFactory iFactory : this.factories) {
            needWorkers = iFactory.getWorkers();
            if (needWorkers <= 0) continue;
            addWorkers = Math.min(needWorkers, i);
            iFactory.removeWorkers(addWorkers);
            this.needWorkers = (short)(this.needWorkers + addWorkers);
            this.workers -= addWorkers;
            if ((i -= addWorkers) != 0) continue;
            break;
        }
        if (i > 0) {
            for (IColonyMiningFactory iColonyMiningFactory : this.buildingMiningList) {
                needWorkers = iColonyMiningFactory.getWorkers();
                if (needWorkers <= 0) continue;
                addWorkers = Math.min(needWorkers, i);
                iColonyMiningFactory.removeWorkers(addWorkers);
                this.needWorkers = (short)(this.needWorkers + addWorkers);
                this.workers -= addWorkers;
                if ((i -= addWorkers) != 0) continue;
                break;
            }
        }
        if (i > 0) {
            for (IOxygenFactory iOxygenFactory : this.oxygenFactoriesList) {
                needWorkers = iOxygenFactory.getWorkers();
                if (needWorkers <= 0) continue;
                addWorkers = Math.min(needWorkers, i);
                iOxygenFactory.removeWorkers(addWorkers);
                this.needWorkers = (short)(this.needWorkers + addWorkers);
                this.workers -= addWorkers;
                if ((i -= addWorkers) != 0) continue;
                break;
            }
        }
        if (i > 0) {
            for (IGenerator iGenerator : this.generators) {
                needWorkers = iGenerator.getWorkers();
                if (needWorkers <= 0) continue;
                addWorkers = Math.min(needWorkers, i);
                iGenerator.removeWorkers(addWorkers);
                this.needWorkers = (short)(this.needWorkers + addWorkers);
                this.workers -= addWorkers;
                if ((i -= addWorkers) != 0) continue;
                break;
            }
        }
        if (i > 0) {
            for (IProtectionBuilding iProtectionBuilding : this.protections) {
                needWorkers = iProtectionBuilding.getWorkers();
                if (needWorkers <= 0) continue;
                addWorkers = Math.min(needWorkers, i);
                iProtectionBuilding.removeWorkers(addWorkers);
                this.needWorkers = (short)(this.needWorkers + addWorkers);
                this.workers -= addWorkers;
                if ((i -= addWorkers) != 0) continue;
                break;
            }
        }
        if (i > 0) {
            for (IColonyStorage iColonyStorage : this.colonyStorages) {
                needWorkers = iColonyStorage.getWorkers();
                if (needWorkers <= 0) continue;
                addWorkers = Math.min(needWorkers, i);
                iColonyStorage.removeWorkers(addWorkers);
                this.needWorkers = (short)(this.needWorkers + addWorkers);
                this.workers -= addWorkers;
                if ((i -= addWorkers) != 0) continue;
                break;
            }
        }
        if (i > 0) {
            for (IEntertainment iEntertainment : this.entertainments) {
                needWorkers = iEntertainment.getWorkers();
                if (needWorkers <= 0) continue;
                addWorkers = Math.min(needWorkers, i);
                iEntertainment.removeWorkers(addWorkers);
                this.needWorkers = (short)(this.needWorkers + addWorkers);
                this.workers -= addWorkers;
                if ((i -= addWorkers) != 0) continue;
                break;
            }
        }
    }

    @Override
    public int getUsingEnergy() {
        return this.usingEnergy;
    }

    @Override
    public int getUsingFood() {
        return this.usingFood;
    }

    @Override
    public int getUsingOxygen() {
        return this.usingOxygen;
    }

    @Override
    public List<IColonyStorage> getColonyStorages() {
        return this.colonyStorages;
    }

    @Override
    public int getFood() {
        return this.food;
    }

    @Override
    public void useFood(int food) {
        if (this.timeUsingResetFood != this.tick) {
            this.timeUsingResetFood = this.tick;
            this.usingFood = 0;
        }
        this.usingFood += food;
        this.food -= food;
    }

    @Override
    public void addFood(int food) {
        if (this.timeResetFood != this.tick) {
            this.timeResetFood = this.tick;
            this.generationFood = 0;
        }
        this.generationFood += food;
        this.food += food;
        if (this.food >= (this.workers + this.freeWorkers) * 15) {
            this.food = (this.workers + this.freeWorkers) * 15;
        }
    }

    @Override
    public void addProtection(int protection) {
        this.protection += protection;
    }

    @Override
    public boolean consumeEnergy(int energy) {
        if (this.energy < energy) {
            this.energy = 0;
            return false;
        }
        this.energy -= energy;
        return true;
    }

    @Override
    public void addEntertainment(short entertainment) {
        this.entertainment = (short)(this.entertainment + entertainment);
    }

    @Override
    public short getEntertainment() {
        return this.entertainment;
    }

    @Override
    public boolean canUseFood(EnumHouses houses) {
        int prev = this.generationFood - this.usingFood;
        return prev - 1 >= 0;
    }

    @Override
    public boolean canUseOxygen(EnumHouses houses) {
        int prev = this.generationOxygen - this.usingOxygen;
        return (double)prev - houses.getConsumeOxygen() >= 0.0;
    }

    @Override
    public void addFreeWorkers(int prev) {
        this.freeWorkers += prev;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Colony colony = (Colony)o;
        return this.fakeplayer.equals(colony.fakeplayer) && this.body.equals(colony.body);
    }
}

