/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blocks;

import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.api.tile.IWrenchable;
import com.denfop.blocks.TileBlockCreator;
import com.denfop.blocks.blockitem.ItemBlockTileEntity;
import com.denfop.blocks.state.HarvestTool;
import com.denfop.blocks.state.State;
import com.denfop.blocks.state.TypeProperty;
import com.denfop.datagen.blocktags.BlockTagsProvider;
import com.denfop.datagen.blocktags.IBlockTag;
import com.denfop.tiles.base.TileEntityBlock;
import com.denfop.utils.ModUtils;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import oshi.util.tuples.Pair;

public class BlockTileEntity<T extends Enum<T>>
extends Block
implements EntityBlock,
IWrenchable,
IPlantable,
IBlockTag {
    public static final Map<BlockPos, TileEntityBlock> teBlockDrop = new HashMap<BlockPos, TileEntityBlock>();
    public static final Property<Direction> ALL_FACING_PROPERTY = DirectionProperty.m_61543_((String)"facing", ModUtils.allFacings);
    public static final Property<Direction> HORIZONTAL_FACING_PROPERTY = DirectionProperty.m_61543_((String)"facing", ModUtils.horizontalFacings);
    public static final Property<Direction> VERTICAL_FACING_PROPERTY = DirectionProperty.m_61543_((String)"facing", ModUtils.verticalFacings);
    public static final Property<Direction> DOWN_FACING_PROPERTY = DirectionProperty.m_61543_((String)"facing", ModUtils.downSideFacings);
    public static final BooleanProperty NORTH = BlockStateProperties.f_61368_;
    public static final BooleanProperty EAST = BlockStateProperties.f_61369_;
    public static final BooleanProperty SOUTH = BlockStateProperties.f_61370_;
    public static final BooleanProperty WEST = BlockStateProperties.f_61371_;
    public static final BooleanProperty UP = BlockStateProperties.f_61366_;
    public static final BooleanProperty DOWN = BlockStateProperties.f_61367_;
    public static final Map<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = ImmutableMap.copyOf((Map)((Map)Util.m_137469_((Object)Maps.newEnumMap(Direction.class), p_55164_ -> {
        p_55164_.put(Direction.NORTH, NORTH);
        p_55164_.put(Direction.EAST, EAST);
        p_55164_.put(Direction.SOUTH, SOUTH);
        p_55164_.put(Direction.WEST, WEST);
        p_55164_.put(Direction.UP, UP);
        p_55164_.put(Direction.DOWN, DOWN);
    })));
    private static final BlockEntityTicker<TileEntityBlock> TICKER = (level, blockPos, blockState, tileEntityBlock) -> tileEntityBlock.tick();
    public static TypeProperty currentTypeProperty;
    private static IMultiTileBlock preValue;
    public final Property<Direction> facingProperty;
    public final TileBlockCreator.InfoAboutTile<?> teInfo;
    private final ResourceLocation identifier;
    private final T value;
    public ItemBlockTileEntity<T> item;
    public TypeProperty typeProperty = this.getTypeProperty();

    public BlockTileEntity(BlockBehaviour.Properties properties, T value, ResourceLocation identifier, TileBlockCreator.InfoAboutTile<T> teInfo) {
        super(properties);
        this.value = value;
        this.teInfo = teInfo;
        this.identifier = identifier;
        this.facingProperty = this.f_49792_.m_61081_("facing");
        BlockState state = (BlockState)this.m_49966_().m_61124_((Property)this.typeProperty, (Comparable)this.typeProperty.getState((IMultiTileBlock)value, ""));
        if (this.facingProperty != null) {
            state = (BlockState)state.m_61124_(this.facingProperty, (Comparable)this.getPlacementFacing(null, Direction.SOUTH));
        }
        if (((IMultiTileBlock)value).getMaterial() == IMultiTileBlock.CABLE) {
            ((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false));
        }
        this.m_49959_(state);
        ((IMultiTileBlock)value).setDefaultState(this.m_49966_());
        BlockTagsProvider.list.add(this);
    }

    public static <T extends Enum<T>> BlockTileEntity<T> create(T value, ResourceLocation identifier, TileBlockCreator.InfoAboutTile<T> infoAboutTile) {
        currentTypeProperty = new TypeProperty(identifier, (IMultiTileBlock)((Object)value));
        preValue = (IMultiTileBlock)((Object)value);
        BlockBehaviour.Properties prop = BlockBehaviour.Properties.m_284310_().m_284180_(((IMultiTileBlock)((Object)value)).getMaterial()).m_280658_(NoteBlockInstrument.FLUTE).m_60978_(((IMultiTileBlock)((Object)value)).getHardness()).m_60924_((p_61036_, p_61037_, p_61038_) -> {
            TileEntityBlock te = BlockTileEntity.getTe(p_61037_, p_61038_);
            return te != null && te.canConnectRedstone();
        }).m_60955_().m_60918_(((IMultiTileBlock)((Object)value)).getMaterial() == MapColor.f_283930_ ? SoundType.f_56745_ : SoundType.f_56742_);
        if (((IMultiTileBlock)((Object)value)).getMaterial() == MapColor.f_283915_) {
            prop = prop.m_60910_();
        }
        if (((IMultiTileBlock)((Object)value)).getMaterial() == IMultiTileBlock.CABLE) {
            prop = prop.m_155956_(300.0f);
        }
        if (((IMultiTileBlock)((Object)value)).getHarvestTool() != HarvestTool.None) {
            prop = prop.m_60999_();
        }
        BlockTileEntity<T> ret = new BlockTileEntity<T>(prop, value, identifier, infoAboutTile);
        currentTypeProperty = null;
        return ret;
    }

    public float m_7749_(BlockState p_48731_, BlockGetter p_48732_, BlockPos p_48733_) {
        return 1.0f;
    }

    public boolean m_7420_(BlockState p_48740_, BlockGetter p_48741_, BlockPos p_48742_) {
        return true;
    }

    public boolean m_6104_(BlockState p_53972_, BlockState p_53973_, Direction p_53974_) {
        if (!p_53973_.m_61138_((Property)this.typeProperty)) {
            return super.m_6104_(p_53972_, p_53973_, p_53974_);
        }
        IMultiTileBlock type = ((State)p_53973_.m_61143_((Property)this.typeProperty)).teBlock;
        return this.value == type || super.m_6104_(p_53972_, p_53973_, p_53974_);
    }

    private static TileEntityBlock getTe(Level world, BlockPos pos) {
        BlockEntity te = world.m_7702_(pos);
        return te instanceof TileEntityBlock ? (TileEntityBlock)te : null;
    }

    private static TileEntityBlock getTe(BlockGetter getter, BlockPos pos) {
        BlockEntity blockEntity = getter.m_7702_(pos);
        if (blockEntity instanceof TileEntityBlock) {
            TileEntityBlock te = (TileEntityBlock)blockEntity;
            return te;
        }
        return null;
    }

    public void setItem(ItemBlockTileEntity<T> item) {
        this.item = item;
    }

    public T getValue() {
        return this.value;
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof TileEntityBlock) {
            TileEntityBlock te = (TileEntityBlock)blockEntity;
            te.onEntityCollision(entity);
        }
    }

    public void m_6402_(Level level, BlockPos blockPos, BlockState blockState, LivingEntity livingEntity, ItemStack itemStack) {
        TileEntityBlock tileEntityBlock = BlockTileEntity.getTe(level, blockPos);
        if (tileEntityBlock != null) {
            tileEntityBlock.onPlaced(itemStack, livingEntity, tileEntityBlock.getFacing());
        }
    }

    public int m_7753_(BlockState state, BlockGetter world, BlockPos pos) {
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof TileEntityBlock) {
            return ((TileEntityBlock)te).getLightOpacity();
        }
        return 0;
    }

    public int m_6782_(BlockState state, Level world, BlockPos pos) {
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof TileEntityBlock) {
            return ((TileEntityBlock)te).getComparatorInputOverride();
        }
        return 0;
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext collisionContext) {
        TileEntityBlock te = BlockTileEntity.getTe(world, pos);
        return te == null ? super.m_5940_(state, world, pos, collisionContext) : Shapes.m_83064_((AABB)te.getVisualBoundingBox());
    }

    public boolean m_49967_() {
        return true;
    }

    public VoxelShape m_6079_(BlockState state, BlockGetter world, BlockPos pos) {
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof TileEntityBlock) {
            return Shapes.m_83064_((AABB)((TileEntityBlock)te).getOutlineBoundingBox());
        }
        return super.m_6079_(state, world, pos);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (!this.f_60443_) {
            return Shapes.m_83040_();
        }
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof TileEntityBlock) {
            return Shapes.m_83064_((AABB)((TileEntityBlock)te).getPhysicsBoundingBox());
        }
        return super.m_5939_(state, world, pos, context);
    }

    @NotNull
    public VoxelShape m_7952_(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos) {
        TileEntityBlock te = BlockTileEntity.getTe(world, pos);
        return te == null ? super.m_7952_(state, world, pos) : Shapes.m_83064_((AABB)te.getPhysicsBoundingBox());
    }

    private TypeProperty getTypeProperty() {
        if (this.typeProperty != null) {
            return this.typeProperty;
        }
        this.typeProperty = currentTypeProperty;
        return this.typeProperty;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_49915_) {
        super.m_7926_(p_49915_);
        Set<Direction> set = preValue.getSupportedFacings();
        if (set.equals(ModUtils.allFacings)) {
            p_49915_.m_61104_(new Property[]{ALL_FACING_PROPERTY});
        } else if (set.equals(ModUtils.horizontalFacings)) {
            p_49915_.m_61104_(new Property[]{HORIZONTAL_FACING_PROPERTY});
        } else if (set.equals(ModUtils.verticalFacings)) {
            p_49915_.m_61104_(new Property[]{VERTICAL_FACING_PROPERTY});
        } else if (set.equals(ModUtils.downSideFacings)) {
            p_49915_.m_61104_(new Property[]{DOWN_FACING_PROPERTY});
        }
        p_49915_.m_61104_(new Property[]{this.getTypeProperty()});
        if (preValue.getMaterial() == IMultiTileBlock.CABLE) {
            PROPERTY_BY_DIRECTION.values().forEach(xva$0 -> p_49915_.m_61104_(new Property[]{xva$0}));
        }
    }

    @Override
    public Direction getFacing(Level world, BlockPos pos) {
        TileEntityBlock te = BlockTileEntity.getTe(world, pos);
        return te == null ? Direction.DOWN : te.getFacing();
    }

    @Override
    public boolean setFacing(Level world, BlockPos pos, Direction newDirection, Player player) {
        TileEntityBlock te = BlockTileEntity.getTe(world, pos);
        return te != null && te.canSetFacingWrench(newDirection, player);
    }

    @Override
    public boolean wrenchCanRemove(Level world, BlockPos pos, Player player) {
        TileEntityBlock te = BlockTileEntity.getTe(world, pos);
        return te != null && te.wrenchCanRemove(player);
    }

    @Override
    public List<ItemStack> getWrenchDrops(Level var1, BlockPos var2, BlockState var3, BlockEntity te, Player player, int fortune) {
        List<ItemStack> list = ((TileEntityBlock)te).getWrenchDrops(player, fortune);
        return list;
    }

    @Override
    public void wrenchBreak(Level world, BlockPos pos) {
        TileEntityBlock tileEntityBlock = (TileEntityBlock)world.m_7702_(pos);
        if (tileEntityBlock != null) {
            tileEntityBlock.wrenchBreak();
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        try {
            return Objects.requireNonNull(((IMultiTileBlock)this.value).getTeClass()).getConstructor(BlockPos.class, BlockState.class).newInstance(blockPos, blockState);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public void m_6786_(LevelAccessor p_49860_, BlockPos p_49861_, BlockState p_49862_) {
    }

    public void m_5707_(Level p_176208_1_, BlockPos p_176208_2_, BlockState p_176208_3_, Player p_176208_4_) {
        this.m_142387_(p_176208_1_, p_176208_4_, p_176208_2_, p_176208_3_);
        p_176208_1_.m_5594_(p_176208_4_, p_176208_2_, this.f_60446_.m_56775_(), SoundSource.BLOCKS, this.f_60446_.m_56773_() * 0.5f, this.f_60446_.m_56774_() * 0.75f);
    }

    public boolean m_7278_(BlockState p_60457_) {
        return true;
    }

    public int m_6378_(BlockState p_60483_, BlockGetter p_60484_, BlockPos p_60485_, Direction p_60486_) {
        BlockEntity te = p_60484_.m_7702_(p_60485_);
        if (te instanceof TileEntityBlock) {
            return ((TileEntityBlock)te).getWeakPower(p_60486_);
        }
        return 0;
    }

    public void m_6240_(Level p_49827_, Player p_49828_, BlockPos p_49829_, BlockState p_49830_, @Nullable BlockEntity p_49831_, ItemStack p_49832_) {
        super.m_6240_(p_49827_, p_49828_, p_49829_, p_49830_, p_49831_, p_49832_);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level world, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        TileEntityBlock te = BlockTileEntity.getTe(world, pos);
        if (te != null) {
            if (!te.onRemovedByPlayer(player, willHarvest)) {
                return false;
            }
            teBlockDrop.put(pos, te);
        }
        return super.onDestroyedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    public ItemStack getItemStack() {
        return new ItemStack(this.item, 1);
    }

    public void m_6861_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Block block, @NotNull BlockPos neighbor, boolean p_60514_) {
        this.onNeighborChange(state, (LevelReader)level, pos, neighbor);
    }

    public void onNeighborChange(BlockState state, LevelReader level, BlockPos pos, BlockPos neighbor) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof TileEntityBlock) {
            TileEntityBlock te = (TileEntityBlock)blockEntity;
            te.onNeighborChange(level.m_8055_(neighbor), neighbor);
        }
    }

    public <E extends BlockEntity> BlockEntityTicker<E> m_142354_(@NotNull Level level, @NotNull BlockState blockState, @NotNull BlockEntityType<E> blockEntityType) {
        return TICKER;
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof TileEntityBlock) {
            TileEntityBlock te = (TileEntityBlock)blockEntity;
            return te.getLightValue();
        }
        return super.getLightEmission(state, level, pos);
    }

    public BlockState m_7417_(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pPos, BlockPos pNeighborPos) {
        return super.m_7417_(pState, pDirection, pNeighborState, pLevel, pPos, pNeighborPos);
    }

    private Direction getPlacementFacing(LivingEntity livingEntity, Direction direction) {
        Set<Direction> set = ((IMultiTileBlock)this.value).getSupportedFacings();
        if (set.isEmpty()) {
            return Direction.DOWN;
        }
        if (livingEntity != null) {
            Vec3 vec3 = livingEntity.m_20154_();
            Direction direction2 = null;
            double d = Double.NEGATIVE_INFINITY;
            for (Direction direction3 : set) {
                double d2 = vec3.m_82526_(Vec3.m_82528_((Vec3i)direction3.m_122424_().m_122436_()));
                if (!(d2 > d)) continue;
                d = d2;
                direction2 = direction3;
            }
            return direction2;
        }
        return direction != null && set.contains(direction.m_122424_()) ? direction.m_122424_() : ((IMultiTileBlock)this.value).getSupportedFacings().iterator().next();
    }

    public BlockState m_5573_(@NotNull BlockPlaceContext blockPlaceContext) {
        BlockState blockState = super.m_5573_(blockPlaceContext);
        if (this.facingProperty != null) {
            blockState = (BlockState)blockState.m_61124_(this.facingProperty, (Comparable)this.getPlacementFacing((LivingEntity)blockPlaceContext.m_43723_(), blockPlaceContext.m_7820_()));
        }
        blockState = (BlockState)blockState.m_61124_((Property)this.typeProperty, (Comparable)this.typeProperty.getState((IMultiTileBlock)this.value));
        if (((IMultiTileBlock)this.value).getMaterial() == IMultiTileBlock.CABLE) {
            blockState = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)blockState.m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false));
        }
        return blockState;
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState blockState, @NotNull Level level, @NotNull BlockPos blockPos, Player player, @NotNull InteractionHand interactionHand, @NotNull BlockHitResult blockHitResult) {
        if (player.m_36341_()) {
            TileEntityBlock te = BlockTileEntity.getTe(level, blockPos);
            return te == null ? InteractionResult.PASS : this.getResult(te.onSneakingActivated(player, interactionHand, blockHitResult.m_82434_(), blockHitResult.m_82450_()));
        }
        TileEntityBlock te = BlockTileEntity.getTe(level, blockPos);
        return te == null ? InteractionResult.PASS : (te.getCooldownTracker().getTick() == 0 ? this.getResult(te.onActivated(player, interactionHand, blockHitResult.m_82434_(), blockHitResult.m_82450_())) : InteractionResult.PASS);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        TileEntityBlock te = BlockTileEntity.getTe(level, pos);
        return te == null ? ModUtils.emptyStack : te.getPickBlock(player, target);
    }

    public List<ItemStack> m_49635_(BlockState p_60537_, LootParams.Builder p_60538_) {
        BlockEntity blockEntity = null;
        try {
            blockEntity = (BlockEntity)p_60538_.m_287261_(LootContextParams.f_81462_);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (blockEntity == null) {
            Vec3 vec3 = (Vec3)p_60538_.m_287261_(LootContextParams.f_81460_);
            return this.getDrops((Level)p_60538_.m_287258_(), new BlockPos((int)vec3.f_82479_, (int)vec3.f_82480_, (int)vec3.f_82481_), p_60537_, (Entity)p_60538_.m_287261_(LootContextParams.f_81455_));
        }
        Entity entity = null;
        try {
            entity = (Entity)p_60538_.m_287261_(LootContextParams.f_81455_);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.getDrops((Level)p_60538_.m_287258_(), blockEntity.m_58899_(), p_60537_, entity);
    }

    public boolean canHarvestBlock(BlockState state, BlockGetter world, BlockPos pos, Player player) {
        boolean ret = super.canHarvestBlock(state, world, pos, player);
        if (ret) {
            return ret;
        }
        TileEntityBlock te = BlockTileEntity.getTe(world, pos);
        if (te == null) {
            return false;
        }
        if (te.canEntityDestroy((Entity)player)) {
            switch (te.teBlock.getHarvestTool()) {
                case None: {
                    return true;
                }
                case Axe: {
                    ItemStack stack = player.m_21205_();
                    if (stack.m_41619_()) break;
                    return stack.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("forge", "tools/axes")));
                }
                case Pickaxe: {
                    ItemStack stack = player.m_21205_();
                    if (stack.m_41619_()) break;
                    return stack.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("forge", "tools/pickaxes")));
                }
                case Shovel: {
                    ItemStack stack = player.m_21205_();
                    if (stack.m_41619_()) break;
                    return stack.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("forge", "tools/shovels")));
                }
                case Wrench: {
                    ItemStack stack = player.m_21205_();
                    if (stack.m_41619_()) break;
                    return stack.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("forge", "tools/wrench")));
                }
                default: {
                    return false;
                }
            }
        }
        return false;
    }

    public List<ItemStack> getDrops(Level world, BlockPos pos, BlockState state, Entity player) {
        ItemStack stack;
        TileEntityBlock te = BlockTileEntity.getTe(world, pos);
        if (te == null) {
            ItemStack stack2;
            te = teBlockDrop.remove(teBlockDrop.keySet().stream().toList().get(0));
            if (te == null) {
                return new ArrayList<ItemStack>();
            }
            ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
            boolean wasWrench = false;
            if (player instanceof Player && !(stack2 = ((Player)player).m_21205_()).m_41619_()) {
                wasWrench = stack2.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("forge", "tools/wrench")));
            }
            int chance = te.m_58904_().f_46441_.m_188503_(100);
            ret.addAll(te.getSelfDrops(chance, wasWrench));
            ret.addAll(te.getAuxDrops(chance));
            teBlockDrop.remove(pos);
            return ret;
        }
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        boolean wasWrench = false;
        if (player instanceof Player && !(stack = ((Player)player).m_21205_()).m_41619_()) {
            wasWrench = stack.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("forge", "tools/wrench")));
        }
        int chance = te.m_58904_().f_46441_.m_188503_(100);
        ret.addAll(te.getSelfDrops(chance, wasWrench));
        ret.addAll(te.getAuxDrops(chance));
        return ret;
    }

    public void m_6810_(BlockState blockState, @NotNull Level level, @NotNull BlockPos blockPos, BlockState blockState2, boolean b) {
        TileEntityBlock te = BlockTileEntity.getTe(level, blockPos);
        if (te != null && blockState2.m_60734_() != blockState.m_60734_()) {
            te.onBlockBreak(false);
            te.onUnloaded();
            level.m_7471_(te.getPos(), false);
        }
        super.m_6810_(blockState, level, blockPos, blockState2, b);
    }

    public void m_6256_(BlockState p_60499_, Level world, BlockPos pos, Player player) {
        super.m_6256_(p_60499_, world, pos, player);
        TileEntityBlock te = BlockTileEntity.getTe(world, pos);
        if (te != null) {
            te.onClicked(player);
        }
    }

    public boolean m_180643_(BlockState p_181242_, BlockGetter p_181243_, BlockPos p_181244_) {
        return super.m_180643_(p_181242_, p_181243_, p_181244_);
    }

    public InteractionResult getResult(boolean result) {
        return result ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    public BlockState getPlant(BlockGetter level, BlockPos pos) {
        return level.m_8055_(pos);
    }

    public PlantType getPlantType(BlockGetter level, BlockPos pos) {
        TileEntityBlock te = (TileEntityBlock)level.m_7702_(pos);
        return te == null ? TileEntityBlock.noCrop : te.getPlantType();
    }

    @Override
    public Block getBlock() {
        return this;
    }

    @Override
    public Pair<String, Integer> getHarvestLevel() {
        return new Pair((Object)((IMultiTileBlock)this.value).getHarvestTool().toolClass, (Object)1);
    }
}

