/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.events.client;

import com.denfop.api.guidebook.GuideBookCore;
import com.denfop.api.guidebook.GuideTab;
import com.denfop.api.guidebook.Quest;
import com.denfop.network.packet.PacketUpdateCompleteQuest;
import com.denfop.toast.GuideToast;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class EventAutoQuests {
    private static int tabIndex = 0;
    private static int questIndex = 0;
    private static final int QUESTS_PER_TICK = 10;

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onWorldTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        List<GuideTab> guideTabs = GuideBookCore.instance.getGuideTabs();
        if (guideTabs.isEmpty()) {
            return;
        }
        Map<String, List<String>> map = GuideBookCore.uuidGuideMap.get(event.player.m_20148_());
        if (map == null) {
            return;
        }
        GuideTab guideTab = guideTabs.get(tabIndex);
        List<Quest> quests = GuideBookCore.instance.getQuests(tabIndex);
        if (questIndex >= quests.size()) {
            questIndex = 0;
            if (++tabIndex >= guideTabs.size()) {
                tabIndex = 0;
            }
            return;
        }
        for (int processed = 0; questIndex < quests.size() && processed < 10; ++processed) {
            boolean isUnlocked;
            Quest quest = quests.get(questIndex);
            ++questIndex;
            List<ItemStack> stacks = this.mergeStacks(quest.itemStacks);
            boolean hasPrev = quest.hasPrev;
            List<String> completedQuests = map.get(guideTab.unLocalized);
            boolean bl = isUnlocked = hasPrev && completedQuests.contains(quest.prevName);
            if (stacks.isEmpty() || !this.isComplete(event.player, tabIndex, isUnlocked, stacks, quest)) continue;
            this.complete(event.player, tabIndex, quest);
        }
    }

    private List<ItemStack> mergeStacks(List<ItemStack> input) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (ItemStack stack : input) {
            boolean merged = false;
            for (ItemStack existing : stacks) {
                if (!ItemStack.m_41656_((ItemStack)existing, (ItemStack)stack)) continue;
                existing.m_41769_(stack.m_41613_());
                merged = true;
                break;
            }
            if (merged) continue;
            stacks.add(stack.m_41777_());
        }
        return stacks;
    }

    public boolean hasAllItems(Player player, List<ItemStack> requiredItems, Quest quest) {
        for (FluidStack fluidStack : quest.fluidStacks) {
            int amount = fluidStack.getAmount();
            for (int i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
                IFluidHandlerItem handler;
                ItemStack inInventory = (ItemStack)player.m_150109_().f_35974_.get(i);
                if (FluidUtil.getFluidHandler((ItemStack)inInventory).orElse(null) == null || (handler = (IFluidHandlerItem)FluidUtil.getFluidHandler((ItemStack)inInventory).orElse(null)).getFluidInTank(0).isEmpty() || !handler.getFluidInTank(0).isFluidEqual(fluidStack)) continue;
                if (handler.getFluidInTank(0).getAmount() < fluidStack.getAmount()) {
                    amount -= handler.getFluidInTank(0).getAmount();
                    continue;
                }
                amount = 0;
                break;
            }
            if (amount == 0) continue;
            return false;
        }
        for (ItemStack required : requiredItems) {
            ItemStack inInventory;
            int neededCount = required.m_41613_();
            int foundCount = 0;
            for (int i = 0; !(i >= player.m_150109_().f_35974_.size() || ItemStack.m_41656_((ItemStack)(inInventory = (ItemStack)player.m_150109_().f_35974_.get(i)), (ItemStack)required) && (foundCount += inInventory.m_41613_()) >= neededCount); ++i) {
            }
            if (foundCount >= neededCount) continue;
            return false;
        }
        return true;
    }

    public boolean isComplete(Player player, int tab, boolean isUnlocked, List<ItemStack> stacks, Quest quest) {
        if (this.hasAllItems(player, stacks, quest) && !isUnlocked) {
            return GuideBookCore.uuidGuideMap.get(player.m_20148_()).get(GuideBookCore.instance.getGuideTabs().get((int)tab).unLocalized).contains(quest.unLocalizedName);
        }
        return false;
    }

    public void complete(Player player, int tab, Quest quest) {
        Minecraft.m_91087_().m_91300_().m_94922_((Toast)new GuideToast(quest));
        new PacketUpdateCompleteQuest(player, GuideBookCore.instance.getGuideTabs().get((int)tab).unLocalized, quest.unLocalizedName);
    }
}

