/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.gui;

import com.denfop.Localization;
import com.denfop.api.gui.GuiElement;
import com.denfop.api.gui.GuiSlider;
import com.denfop.api.gui.GuiVerticalSlider;
import com.denfop.api.gui.GuiVerticalSliderList;
import com.denfop.api.gui.MouseButton;
import com.denfop.api.gui.ScrollDirection;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.IUpgradeItem;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.api.upgrades.UpgradeRegistry;
import com.denfop.container.ContainerBase;
import com.denfop.container.SlotInvSlot;
import com.denfop.mixin.access.AbstractContainerScreenAccessor;
import com.denfop.recipe.IInputItemStack;
import com.denfop.utils.Keyboard;
import com.denfop.utils.ModUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.util.Pair;
import java.awt.Rectangle;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.client.gui.screens.inventory.tooltip.TooltipRenderUtil;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.ContainerScreenEvent;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class GuiCore<T extends ContainerBase<? extends IAdvInventory>>
extends AbstractContainerScreen<T>
implements MenuAccess<T> {
    public static final int textHeight = 8;
    protected static Runnable closeHandler;
    public static ResourceLocation currentTexture;
    public final T container;
    protected final List<GuiElement<?>> elements;
    private final Queue<Tooltip> queuedTooltips;
    public int guiLeft;
    public int guiTop;
    private boolean fixKeyEvents = false;

    public GuiCore(T container) {
        this(container, 176, 166);
    }

    public GuiCore(T container, int ySize) {
        this(container, 176, ySize);
    }

    public GuiCore(T t, int n, int n2) {
        super(t, ((ContainerBase)((Object)t)).getInventory(), (Component)Component.m_237119_());
        this.container = t;
        this.queuedTooltips = new ArrayDeque<Tooltip>();
        this.elements = new ArrayList();
        this.f_97727_ = n2;
        this.f_97726_ = n;
    }

    public void drawSplitString(GuiGraphics poseStack, Font font, String str, int x, int y, int wrapWidth, int textColor) {
        List strs = font.m_92923_(FormattedText.m_130775_((String)str), wrapWidth);
        for (FormattedCharSequence s : strs) {
            poseStack.m_280649_(font, s, x, y, textColor, false);
            y += 9;
        }
    }

    public void drawSplitString(GuiGraphics poseStack, String str, int x, int y, int wrapWidth, int textColor) {
        if (this.f_96547_ == null) {
            this.f_96547_ = Minecraft.m_91087_().f_91062_;
        }
        List strs = this.f_96547_.m_92923_(FormattedText.m_130775_((String)str), wrapWidth);
        for (FormattedCharSequence s : strs) {
            poseStack.m_280649_(this.f_96547_, s, x, y, textColor, false);
            y += 9;
        }
    }

    private static List<ItemStack> getCompatibleUpgrades(IUpgradableBlock block) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        Set<UpgradableProperty> properties = block.getUpgradableProperties();
        for (ItemStack stack : UpgradeRegistry.getUpgrades()) {
            IUpgradeItem item = (IUpgradeItem)stack.m_41720_();
            if (!item.isSuitableFor(stack, properties)) continue;
            ret.add(stack);
        }
        return ret;
    }

    public static void bindTexture(ResourceLocation resourceLocation) {
        currentTexture = resourceLocation;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)resourceLocation);
    }

    public static void bindTexture(int i, ResourceLocation resourceLocation) {
        currentTexture = resourceLocation;
        RenderSystem.setShaderTexture((int)i, (ResourceLocation)resourceLocation);
    }

    public float adjustTextScale(String text, int canvasWidth, int canvasHeight, float scale, float scaleStep) {
        float newScale;
        block4: {
            newScale = scale;
            float min = 70.0f;
            float max = 0.0f;
            boolean prevScaleDecrease = false;
            boolean prevScaleIncrease = false;
            while (true) {
                if (newScale < min) {
                    min = newScale;
                }
                if (newScale > max) {
                    max = newScale;
                }
                List<String> lines = this.splitTextToLines(text, canvasWidth, newScale);
                int n = lines.size();
                Objects.requireNonNull(this.f_96547_);
                int totalTextHeight = (int)((float)(n * 9) * newScale);
                if (this.isTextTooLarge(lines, canvasWidth, canvasHeight, newScale)) {
                    newScale *= 1.0f - scaleStep;
                    prevScaleDecrease = true;
                    if (!prevScaleIncrease) continue;
                    newScale = (min + max) * 0.95f / 2.0f;
                    break block4;
                }
                if (!((float)totalTextHeight < (float)canvasHeight * 0.8f)) break block4;
                prevScaleIncrease = true;
                newScale *= 1.0f + scaleStep;
                if (prevScaleDecrease) break;
            }
            newScale = (min + max) * 1.2f / 2.0f;
        }
        return newScale;
    }

    public boolean isTextTooLarge(List<String> lines, int canvasWidth, int canvasHeight, float scale) {
        int n = lines.size();
        Objects.requireNonNull(this.f_96547_);
        int totalHeight = (int)((float)(n * 9) * scale);
        for (String line : lines) {
            int lineWidth = (int)((float)this.f_96547_.m_92895_(line) * scale);
            if (lineWidth <= canvasWidth) continue;
            return true;
        }
        return totalHeight > canvasHeight;
    }

    public List<String> wrapTextWithNewlines(String text, int maxWidth) {
        String[] paragraphs;
        ArrayList<String> lines = new ArrayList<String>();
        for (String paragraph : paragraphs = text.split("\n")) {
            lines.addAll(this.wrapText(paragraph, maxWidth));
        }
        return lines;
    }

    public List<String> wrapText(String text, int maxWidth) {
        String[] words;
        ArrayList<String> lines = new ArrayList<String>();
        StringBuilder currentLine = new StringBuilder();
        for (String word : words = text.split(" ")) {
            if (this.f_96547_.m_92895_(currentLine + word) <= maxWidth) {
                currentLine.append(word).append(" ");
                continue;
            }
            lines.add(currentLine.toString().trim());
            currentLine.setLength(0);
            currentLine.append(word).append(" ");
        }
        if (currentLine.length() > 0) {
            lines.add(currentLine.toString().trim());
        }
        return lines;
    }

    public void drawTextInCanvas(GuiGraphics graphics, String text, int canvasX, int canvasY, int canvasWidth, int canvasHeight, float scale) {
        int maxWidth = (int)((float)canvasWidth / scale);
        Objects.requireNonNull(this.f_96547_);
        int lineHeight = (int)(9.0f * scale);
        int x = canvasX;
        int y = canvasY;
        PoseStack poseStack = graphics.m_280168_();
        List<String> lines = this.wrapTextWithNewlines(text, maxWidth);
        for (String line : lines) {
            if (y + lineHeight > canvasY + canvasHeight) break;
            poseStack.m_85836_();
            poseStack.m_85841_(scale, scale, scale);
            graphics.m_280056_(this.f_96547_, line, (int)((float)x / scale), (int)((float)y / scale), 0xFFFFFF, false);
            poseStack.m_85849_();
            y += lineHeight;
        }
    }

    public void drawTextInCanvas(GuiGraphics graphics, String text, int canvasX, int canvasY, int canvasWidth, int canvasHeight, float scale, int color) {
        int maxWidth = (int)((float)canvasWidth / scale);
        Objects.requireNonNull(this.f_96547_);
        int lineHeight = (int)(9.0f * scale);
        int x = canvasX;
        int y = canvasY;
        List<String> lines = this.wrapTextWithNewlines(text, maxWidth);
        PoseStack poseStack = graphics.m_280168_();
        for (String line : lines) {
            if (y + lineHeight > canvasY + canvasHeight) break;
            poseStack.m_85836_();
            poseStack.m_85841_(scale, scale, scale);
            graphics.m_280056_(this.f_96547_, line, (int)((float)x / scale), (int)((float)y / scale), color, false);
            poseStack.m_85849_();
            y += lineHeight;
        }
    }

    public List<String> splitTextToLines(String text, int canvasWidth, float scale) {
        String[] manualLines;
        ArrayList<String> lines = new ArrayList<String>();
        for (String manualLine : manualLines = text.split("\n")) {
            String[] words;
            StringBuilder currentLine = new StringBuilder();
            for (String word : words = manualLine.split(" ")) {
                Object testLine = currentLine.length() == 0 ? word : currentLine + " " + word;
                int lineWidth = (int)((float)this.f_96547_.m_92895_((String)testLine) * scale);
                if (lineWidth > canvasWidth) {
                    lines.add(currentLine.toString());
                    currentLine = new StringBuilder(word);
                    continue;
                }
                currentLine.append((String)(currentLine.isEmpty() ? word : " " + word));
            }
            if (currentLine.isEmpty()) continue;
            lines.add(currentLine.toString());
        }
        return lines;
    }

    public final T getContainer() {
        return (T)((Object)((ContainerBase)this.f_97732_));
    }

    public final int guiLeft() {
        return this.f_97735_;
    }

    public final int guiTop() {
        return this.f_97736_;
    }

    public final Slot getFocusedSlot() {
        return this.f_97734_;
    }

    public boolean m_97774_(Slot p_97775_, double p_97776_, double p_97777_) {
        return this.m_6774_(p_97775_.f_40220_, p_97775_.f_40221_, 16, 16, p_97776_, p_97777_);
    }

    public void m_280211_(GuiGraphics guiGraphics, ItemStack stack, int x, int y, String text) {
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 232.0f);
        guiGraphics.m_280480_(stack, x, y);
        Font font = IClientItemExtensions.of((ItemStack)stack).getFont(stack, IClientItemExtensions.FontContext.ITEM_COUNT);
        guiGraphics.m_280302_(font == null ? this.f_96547_ : font, stack, x, y - (((AbstractContainerScreenAccessor)((Object)this)).getDraggingItem().m_41619_() ? 0 : 8), text);
        guiGraphics.m_280168_().m_85849_();
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        ItemStack itemstack;
        this.guiLeft = this.getGuiLeft();
        this.guiTop = this.getGuiTop();
        this.m_280273_(guiGraphics);
        int i = this.f_97735_;
        int j = this.f_97736_;
        this.m_7286_(guiGraphics, partialTick, mouseX, mouseY);
        MinecraftForge.EVENT_BUS.post((Event)new ContainerScreenEvent.Render.Background((AbstractContainerScreen)this, guiGraphics, mouseX, mouseY));
        RenderSystem.disableDepthTest();
        for (Renderable renderable : this.f_169369_) {
            renderable.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        }
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_((float)i, (float)j, 0.0f);
        this.f_97734_ = null;
        for (int k = 0; k < ((ContainerBase)this.f_97732_).f_38839_.size(); ++k) {
            Slot slot = (Slot)((ContainerBase)this.f_97732_).f_38839_.get(k);
            if (slot.m_6659_()) {
                this.m_280092_(guiGraphics, slot);
            }
            if (!this.m_97774_(slot, mouseX, mouseY) || !slot.m_6659_()) continue;
            this.f_97734_ = slot;
            int j2 = slot.f_40220_;
            int k2 = slot.f_40221_;
            if (this.f_97734_.m_280329_()) {
                GuiCore.renderSlotHighlight((GuiGraphics)guiGraphics, (int)j2, (int)k2, (int)0, (int)this.getSlotColor(k));
            }
            if (!(slot instanceof SlotInvSlot) || !((SlotInvSlot)slot).invSlot.hasItemList() || !Keyboard.isKeyDown(340)) continue;
            this.renderItemTooltipGrid(guiGraphics, ((SlotInvSlot)slot).invSlot.getStacks(((SlotInvSlot)slot).index), mouseX - this.guiLeft + 5, mouseY - this.guiTop + 5);
        }
        this.m_280003_(guiGraphics, mouseX, mouseY);
        MinecraftForge.EVENT_BUS.post((Event)new ContainerScreenEvent.Render.Foreground((AbstractContainerScreen)this, guiGraphics, mouseX, mouseY));
        ItemStack itemStack = itemstack = ((AbstractContainerScreenAccessor)((Object)this)).getDraggingItem().m_41619_() ? ((ContainerBase)this.f_97732_).m_142621_() : ((AbstractContainerScreenAccessor)((Object)this)).getDraggingItem();
        if (!itemstack.m_41619_()) {
            int j2 = ((AbstractContainerScreenAccessor)((Object)this)).getDraggingItem().m_41619_() ? 8 : 16;
            String s = null;
            if (!((AbstractContainerScreenAccessor)((Object)this)).getDraggingItem().m_41619_() && ((AbstractContainerScreenAccessor)((Object)this)).getIsSplittingStack()) {
                itemstack = itemstack.m_255036_(Mth.m_14167_((float)((float)itemstack.m_41613_() / 2.0f)));
            } else if (this.f_97738_ && this.f_97737_.size() > 1 && (itemstack = itemstack.m_255036_(((AbstractContainerScreenAccessor)((Object)this)).getQuickCraftingType())).m_41619_()) {
                s = String.valueOf(ChatFormatting.YELLOW) + "0";
            }
            this.m_280211_(guiGraphics, itemstack, mouseX - i - 8, mouseY - j - j2, s);
        }
        if (!((AbstractContainerScreenAccessor)((Object)this)).getSnapbackItem().m_41619_()) {
            float f = (float)(Util.m_137550_() - ((AbstractContainerScreenAccessor)((Object)this)).getSnapbackTime()) / 100.0f;
            if (f >= 1.0f) {
                f = 1.0f;
                ((AbstractContainerScreenAccessor)((Object)this)).setSnapbackItem(ItemStack.f_41583_);
            }
            int j2 = ((AbstractContainerScreenAccessor)((Object)this)).getSnapbackEnd().f_40220_ - ((AbstractContainerScreenAccessor)((Object)this)).getSnapbackStartX();
            int k2 = ((AbstractContainerScreenAccessor)((Object)this)).getSnapbackEnd().f_40221_ - ((AbstractContainerScreenAccessor)((Object)this)).getSnapbackStartY();
            int j1 = ((AbstractContainerScreenAccessor)((Object)this)).getSnapbackStartX() + (int)((float)j2 * f);
            int k1 = ((AbstractContainerScreenAccessor)((Object)this)).getSnapbackStartY() + (int)((float)k2 * f);
            this.m_280211_(guiGraphics, ((AbstractContainerScreenAccessor)((Object)this)).getSnapbackItem(), j1, k1, null);
        }
        guiGraphics.m_280168_().m_85849_();
        RenderSystem.enableDepthTest();
        this.changeParams();
    }

    public void changeParams() {
    }

    public boolean needRenderForeground() {
        return true;
    }

    public void m_280092_(GuiGraphics guiGraphics, Slot slot) {
        Pair pair;
        int i = slot.f_40220_;
        int j = slot.f_40221_;
        ItemStack itemstack = slot.m_7993_();
        boolean flag = false;
        boolean flag1 = slot == ((AbstractContainerScreenAccessor)((Object)this)).getClickedSlot() && !((AbstractContainerScreenAccessor)((Object)this)).getDraggingItem().m_41619_() && !((AbstractContainerScreenAccessor)((Object)this)).getIsSplittingStack();
        ItemStack itemstack1 = ((ContainerBase)this.f_97732_).m_142621_();
        String s = null;
        if (slot == ((AbstractContainerScreenAccessor)((Object)this)).getClickedSlot() && !((AbstractContainerScreenAccessor)((Object)this)).getDraggingItem().m_41619_() && ((AbstractContainerScreenAccessor)((Object)this)).getIsSplittingStack() && !itemstack.m_41619_()) {
            itemstack = itemstack.m_255036_(itemstack.m_41613_() / 2);
        } else if (this.f_97738_ && this.f_97737_.contains(slot) && !itemstack1.m_41619_()) {
            if (this.f_97737_.size() == 1) {
                return;
            }
            if (AbstractContainerMenu.m_38899_((Slot)slot, (ItemStack)itemstack1, (boolean)true) && ((ContainerBase)this.f_97732_).m_5622_(slot)) {
                flag = true;
                int k = Math.min(itemstack1.m_41741_(), slot.m_5866_(itemstack1));
                int l = slot.m_7993_().m_41619_() ? 0 : slot.m_7993_().m_41613_();
                int i1 = AbstractContainerMenu.m_278794_((Set)this.f_97737_, (int)((AbstractContainerScreenAccessor)((Object)this)).getQuickCraftingType(), (ItemStack)itemstack1) + l;
                if (i1 > k) {
                    i1 = k;
                    String var10000 = ChatFormatting.YELLOW.toString();
                    s = var10000 + k;
                }
                itemstack = itemstack1.m_255036_(i1);
            } else {
                this.f_97737_.remove(slot);
                this.m_97818_();
            }
        }
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 100.0f);
        if (itemstack.m_41619_() && slot.m_6659_() && (pair = slot.m_7543_()) != null) {
            TextureAtlasSprite textureatlassprite = (TextureAtlasSprite)this.f_96541_.m_91258_((ResourceLocation)pair.getFirst()).apply((ResourceLocation)pair.getSecond());
            guiGraphics.m_280159_(i, j, 0, 16, 16, textureatlassprite);
            flag1 = true;
        }
        if (!flag1) {
            if (flag) {
                guiGraphics.m_280509_(i, j, i + 16, j + 16, -2130706433);
            }
            guiGraphics.m_280256_(itemstack, i, j, slot.f_40220_ + slot.f_40221_ * this.f_97726_);
            guiGraphics.m_280302_(this.f_96547_, itemstack, i, j, s);
        }
        guiGraphics.m_280168_().m_85849_();
    }

    public void m_97818_() {
        ItemStack itemstack = ((ContainerBase)this.f_97732_).m_142621_();
        if (!itemstack.m_41619_() && this.f_97738_) {
            if (((AbstractContainerScreenAccessor)((Object)this)).getQuickCraftingType() == 2) {
                ((AbstractContainerScreenAccessor)((Object)this)).setQuickCraftingRemainder(itemstack.m_41741_());
            } else {
                ((AbstractContainerScreenAccessor)((Object)this)).setQuickCraftingRemainder(itemstack.m_41613_());
                for (Slot slot : this.f_97737_) {
                    ItemStack itemstack1 = slot.m_7993_();
                    int i = itemstack1.m_41619_() ? 0 : itemstack1.m_41613_();
                    int j = Math.min(itemstack.m_41741_(), slot.m_5866_(itemstack));
                    int k = Math.min(AbstractContainerMenu.m_278794_((Set)this.f_97737_, (int)((AbstractContainerScreenAccessor)((Object)this)).getQuickCraftingType(), (ItemStack)itemstack) + i, j);
                    ((AbstractContainerScreenAccessor)((Object)this)).setQuickCraftingRemainder(((AbstractContainerScreenAccessor)((Object)this)).getQuickCraftingRemainder() - (k - i));
                }
            }
        }
    }

    public void m_181908_() {
        super.m_181908_();
        for (GuiElement<?> element : this.elements) {
            GuiElement<?> guiElement = element;
            if (!guiElement.visible()) continue;
            guiElement.tick();
        }
    }

    protected void m_7286_(@NotNull GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        this.drawBackgroundAndTitle(graphics, partialTick, mouseX - this.f_97735_, mouseY - this.f_97736_);
        for (GuiElement<?> element : this.elements) {
            GuiElement<?> guiElement = element;
            if (!guiElement.visible()) continue;
            guiElement.drawBackground(graphics, this.f_97735_, this.f_97736_);
        }
    }

    public void drawItemStack(GuiGraphics graphics, int x, int y, ItemStack stack) {
        graphics.m_280480_(stack, x + this.guiLeft(), y + this.guiTop());
        graphics.m_280370_(this.f_96547_, stack, x + this.guiLeft(), y + this.guiTop());
    }

    public void drawItemStack(GuiGraphics graphics, ItemStack stack, int x, int y) {
        graphics.m_280480_(stack, x + this.guiLeft(), y + this.guiTop());
        graphics.m_280370_(this.f_96547_, stack, x + this.guiLeft(), y + this.guiTop());
    }

    protected void drawBackgroundAndTitle(@NotNull GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        GuiCore.bindTexture(this.getTexture());
        graphics.m_280218_(currentTexture, this.getGuiLeft(), this.getGuiTop(), 0, 0, this.getXSize(), this.getYSize());
        graphics.m_280653_(this.f_96547_, this.f_96539_, this.f_97726_ / 2, 6, 0x404040);
    }

    protected void m_280003_(@NotNull GuiGraphics graphics, int mouseX, int mouseY) {
        this.drawForegroundLayer(graphics, mouseX - this.f_97735_, mouseY - this.f_97736_);
        this.flushTooltips(graphics);
        this.m_280072_(graphics, mouseX - this.f_97735_, mouseY - this.f_97736_ - 5);
    }

    protected void draw(GuiGraphics poseStack, String s, int i, int i1, int i2) {
        poseStack.m_280056_(Minecraft.m_91087_().f_91062_, s, i, i1, i2, false);
    }

    protected void draw(GuiGraphics poseStack, FormattedCharSequence s, int i, int i1, int i2) {
        poseStack.m_280649_(Minecraft.m_91087_().f_91062_, s, i, i1, i2, false);
    }

    protected void draw(GuiGraphics poseStack, Component s, int i, int i1, int i2) {
        poseStack.m_280614_(Minecraft.m_91087_().f_91062_, s, i, i1, i2, false);
    }

    protected void drawForegroundLayer(@NotNull GuiGraphics graphics, int mouseX, int mouseY) {
        if (((ContainerBase)this.f_97732_).base instanceof IUpgradableBlock) {
            this.handleUpgradeTooltip(mouseX, mouseY);
        }
        for (int k = 0; k < ((ContainerBase)this.f_97732_).f_38839_.size(); ++k) {
            Slot slot = (Slot)((ContainerBase)this.f_97732_).f_38839_.get(k);
            if (!(slot instanceof SlotInvSlot)) continue;
            int j2 = slot.f_40220_;
            int k2 = slot.f_40221_;
            if (!this.m_97774_(slot, mouseX, mouseY) || !((SlotInvSlot)slot).invSlot.hasItemList() || !Keyboard.isKeyDown(340)) continue;
            this.renderItemTooltipGrid(graphics, ((SlotInvSlot)slot).invSlot.getStacks(((SlotInvSlot)slot).index), this.guiLeft + j2, this.guiTop + k2);
        }
        for (GuiElement<?> element : this.elements) {
            GuiElement<?> guiElement = element;
            if (!guiElement.visible()) continue;
            guiElement.drawForeground(graphics, mouseX, mouseY);
        }
    }

    private void handleUpgradeTooltip(int n, int n2) {
        if (n >= 0 && n <= 12 && n2 >= 0 && n2 <= 12) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(Localization.translate("iu.generic.text.upgrade"));
            for (ItemStack itemStack : GuiCore.getCompatibleUpgrades((IUpgradableBlock)((ContainerBase)this.f_97732_).base)) {
                arrayList.add(itemStack.m_41786_().getString());
            }
            this.drawTooltip(n, n2, arrayList);
        }
    }

    public boolean m_6050_(double d, double d2, double d3) {
        ScrollDirection scrollDirection = d3 != 0.0 ? (d3 < 0.0 ? ScrollDirection.down : ScrollDirection.up) : ScrollDirection.stopped;
        for (GuiElement<?> element : this.elements) {
            GuiElement<?> guiElement = element;
            if (!guiElement.visible() || !guiElement.contains((int)d, (int)d2)) continue;
            guiElement.onMouseScroll((int)d, (int)d2, scrollDirection);
        }
        List listButton = this.f_169369_;
        for (Renderable button : listButton) {
            AbstractWidget slider;
            if (button instanceof GuiVerticalSliderList) {
                slider = (GuiVerticalSliderList)button;
                if (scrollDirection != ScrollDirection.stopped) {
                    slider.handleMouseWheel(scrollDirection, (int)d, (int)d2);
                }
            }
            if (button instanceof GuiSlider) {
                slider = (GuiSlider)button;
                if (scrollDirection != ScrollDirection.stopped) {
                    slider.handleMouseWheel(scrollDirection, (int)d, (int)d2);
                }
            }
            if (!(button instanceof GuiVerticalSlider)) continue;
            slider = (GuiVerticalSlider)button;
            if (scrollDirection == ScrollDirection.stopped) continue;
            slider.handleMouseWheel(scrollDirection, (int)d, (int)d2);
        }
        return super.m_6050_(d, d2, d3);
    }

    protected void mouseClicked(int i, int j, int k) {
        for (Renderable widget : this.f_169369_) {
            if (!(widget instanceof GuiEventListener)) continue;
            ((GuiEventListener)widget).m_6375_((double)i, (double)j, k);
        }
    }

    public boolean m_6375_(double d, double d2, int n) {
        MouseButton mouseButton = MouseButton.get(n);
        boolean bl = false;
        d -= (double)this.f_97735_;
        d2 -= (double)this.f_97736_;
        for (GuiElement<?> element : this.elements) {
            GuiElement<?> guiElement = element;
            if (!guiElement.visible()) continue;
            bl |= guiElement.onMouseClick((int)d, (int)d2, mouseButton, guiElement.contains((int)d, (int)d2));
        }
        if (bl) {
            return true;
        }
        this.mouseClicked((int)(d += (double)this.f_97735_), (int)(d2 += (double)this.f_97736_), n);
        return super.m_6375_(d, d2, n);
    }

    public boolean m_7979_(double d, double d2, int n, double d3, double d4) {
        MouseButton mouseButton = MouseButton.get(n);
        boolean bl = false;
        d -= (double)this.f_97735_;
        d2 -= (double)this.f_97736_;
        for (GuiElement<?> element : this.elements) {
            GuiElement<?> guiElement = element;
            if (!guiElement.visible()) continue;
            bl |= guiElement.onMouseDrag((int)d, (int)d2, mouseButton, (long)d3, guiElement.contains((int)d, (int)d2));
        }
        if (bl) {
            return true;
        }
        d += (double)this.f_97735_;
        d2 += (double)this.f_97736_;
        for (Renderable widget : this.f_169369_) {
            if (!(widget instanceof GuiEventListener)) continue;
            ((GuiEventListener)widget).m_7979_(d, d2, n, d3, d4);
        }
        return super.m_7979_(d, d2, n, d3, d4);
    }

    public boolean m_6348_(double d, double d2, int n) {
        MouseButton mouseButton = MouseButton.get(n);
        boolean bl = false;
        d -= (double)this.f_97735_;
        d2 -= (double)this.f_97736_;
        for (GuiElement<?> element : this.elements) {
            GuiElement<?> guiElement = element;
            if (!guiElement.visible()) continue;
            bl |= guiElement.onMouseRelease((int)d, (int)d2, mouseButton, guiElement.contains((int)d, (int)d2));
        }
        if (bl) {
            return true;
        }
        return super.m_6348_(d += (double)this.f_97735_, d2 += (double)this.f_97736_, n);
    }

    public boolean m_5534_(char c, int n) {
        boolean bl = false;
        for (GuiElement<?> element : this.elements) {
            GuiElement<?> guiElement = element;
            if (!guiElement.visible()) continue;
            bl |= guiElement.onKeyTyped(c, n);
        }
        if (bl) {
            return true;
        }
        return super.m_5534_(c, n);
    }

    public void m_7861_() {
        super.m_7861_();
        if (closeHandler != null) {
            closeHandler.run();
        }
    }

    public void drawTexturedRect(GuiGraphics graphics, double x, double y, double width, double height, double texX, double texY) {
        this.drawTexturedRect(graphics, x, y, width, height, texX, texY, false);
    }

    public void drawTexturedRect(GuiGraphics graphics, double x, double y, double width, double height, double texX, double texY, boolean mirrorX) {
        this.drawTexturedRect(graphics, x, y, width, height, texX / 256.0, texY / 256.0, (texX + width) / 256.0, (texY + height) / 256.0, mirrorX);
    }

    public void drawTexturedRect(GuiGraphics graphics, double x, double y, double width, double height, double uS, double vS, double uE, double vE, boolean mirrorX) {
        double xE = (x += (double)this.guiLeft()) + width;
        double yE = (y += (double)this.guiTop()) + height;
        if (mirrorX) {
            double tmp = uS;
            uS = uE;
            uE = tmp;
        }
        graphics.m_280218_(currentTexture, (int)x, (int)y, (int)uS, (int)vS, (int)width, (int)height);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tessellator.m_85915_();
        Matrix4f matrix = graphics.m_280168_().m_85850_().m_252922_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferBuilder.m_252986_(matrix, (float)x, (float)y, 0.0f).m_7421_((float)uS, (float)vS).m_5752_();
        bufferBuilder.m_252986_(matrix, (float)x, (float)yE, 0.0f).m_7421_((float)uS, (float)vE).m_5752_();
        bufferBuilder.m_252986_(matrix, (float)xE, (float)yE, 0.0f).m_7421_((float)uE, (float)vE).m_5752_();
        bufferBuilder.m_252986_(matrix, (float)xE, (float)y, 0.0f).m_7421_((float)uE, (float)vS).m_5752_();
        tessellator.m_85914_();
    }

    public void drawSprite1(GuiGraphics graphics, double x, double y, double width, double height, TextureAtlasSprite sprite, int color, double textureSize, boolean wrapX, boolean wrapY) {
        if (sprite == null) {
            sprite = ((TextureAtlas)this.f_96541_.m_91097_().m_118506_(InventoryMenu.f_39692_)).m_118316_(MissingTextureAtlasSprite.m_118071_());
        }
        textureSize *= 16.0;
        for (double xS = x; xS < x + width; xS += textureSize) {
            for (double yS = y; yS < y + height; yS += textureSize) {
                double segmentWidth = Math.min(textureSize, x + width - xS);
                double segmentHeight = Math.min(textureSize, y + height - yS);
                graphics.m_280159_((int)xS, (int)yS, color, (int)segmentWidth, (int)segmentHeight, sprite);
            }
        }
    }

    public void drawSprite(GuiGraphics graphics, double x, double y, double width, double height, TextureAtlasSprite sprite, int color, double textureSize, boolean wrapX, boolean wrapY) {
        double tileWidth;
        if (sprite == null) {
            sprite = ((TextureAtlas)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_)).m_118316_(MissingTextureAtlasSprite.m_118071_());
        }
        double startX = x;
        double startY = y;
        double tileSize = 16.0;
        double u0 = sprite.m_118409_();
        double v0 = sprite.m_118411_();
        double u1 = sprite.m_118410_();
        double v1 = sprite.m_118412_();
        double uSize = u1 - u0;
        double vSize = v1 - v0;
        int alpha = color >> 24 & 0xFF;
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        Matrix4f matrix = graphics.m_280168_().m_85850_().m_252922_();
        RenderSystem.setShader(GameRenderer::m_172820_);
        BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        double remX = width % tileSize;
        double remY = height % tileSize;
        for (double tileX = startX; tileX < startX + width; tileX += tileWidth) {
            double tileHeight;
            tileWidth = tileSize;
            double uStart = u0;
            if (tileX == startX && remX > 0.0) {
                tileWidth = remX;
                uStart = u0 + uSize * (1.0 - remX / tileSize);
            }
            if (tileX + tileWidth > startX + width) {
                tileWidth = startX + width - tileX;
                uStart = u0;
            }
            double tileXEnd = tileX + tileWidth;
            double uEnd = uStart + (tileXEnd - tileX) / tileSize * uSize;
            for (double tileY = startY; tileY < startY + height; tileY += tileHeight) {
                tileHeight = tileSize;
                double vStart = v0;
                if (tileY == startY && remY > 0.0) {
                    tileHeight = remY;
                    vStart = v0 + vSize * (1.0 - remY / tileSize);
                }
                if (tileY + tileHeight > startY + height) {
                    tileHeight = startY + height - tileY;
                    vStart = v0;
                }
                double tileYEnd = tileY + tileHeight;
                double vEnd = vStart + (tileYEnd - tileY) / tileSize * vSize;
                buffer.m_252986_(matrix, (float)tileX, (float)tileY, 0.0f).m_7421_((float)uStart, (float)vStart).m_6122_(red, green, blue, alpha).m_5752_();
                buffer.m_252986_(matrix, (float)tileX, (float)tileYEnd, 0.0f).m_7421_((float)uStart, (float)vEnd).m_6122_(red, green, blue, alpha).m_5752_();
                buffer.m_252986_(matrix, (float)tileXEnd, (float)tileYEnd, 0.0f).m_7421_((float)uEnd, (float)vEnd).m_6122_(red, green, blue, alpha).m_5752_();
                buffer.m_252986_(matrix, (float)tileXEnd, (float)tileY, 0.0f).m_7421_((float)uEnd, (float)vStart).m_6122_(red, green, blue, alpha).m_5752_();
            }
        }
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
    }

    public void drawItem(GuiGraphics graphics, int x, int y, ItemStack itemStack) {
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        graphics.m_280480_(itemStack, x + this.guiLeft(), y + this.guiTop());
    }

    public void drawColoredRect(GuiGraphics poseStack, int x, int y, int width, int height, int color, BufferBuilder bufferBuilder) {
        int alpha = color >>> 24;
        boolean translucent = alpha != 255 && alpha != 0;
        Matrix4f matrix4f = poseStack.m_280168_().m_85850_().m_252922_();
        int x2 = (x += this.f_97735_) + width;
        int y2 = (y += this.f_97736_) + height;
        boolean z = false;
        if (translucent) {
            RenderSystem.enableBlend();
        }
        bufferBuilder.m_252986_(matrix4f, (float)x, (float)y, (float)z).m_193479_(color).m_5752_();
        bufferBuilder.m_252986_(matrix4f, (float)x, (float)y2, (float)z).m_193479_(color).m_5752_();
        bufferBuilder.m_252986_(matrix4f, (float)x2, (float)y2, (float)z).m_193479_(color).m_5752_();
        bufferBuilder.m_252986_(matrix4f, (float)x2, (float)y, (float)z).m_193479_(color).m_5752_();
        if (translucent) {
            RenderSystem.disableBlend();
        }
    }

    public int drawString(GuiGraphics poseStack, String text, int x, int y, int color) {
        if (this.f_96547_ == null) {
            this.f_96547_ = Minecraft.m_91087_().f_91062_;
        }
        poseStack.m_280056_(this.f_96547_, text, x + this.guiLeft - this.f_97735_, y + this.guiTop - this.f_97736_, color, false);
        return x;
    }

    public int drawString(GuiGraphics poseStack, int x, int y, String text, int color) {
        if (this.f_96547_ == null) {
            this.f_96547_ = Minecraft.m_91087_().f_91062_;
        }
        poseStack.m_280056_(this.f_96547_, text, x + this.guiLeft - this.f_97735_, y + this.guiTop - this.f_97736_, color, false);
        return x;
    }

    public int drawString(GuiGraphics poseStack, int x, int y, String text, int color, boolean shadow) {
        if (this.f_96547_ == null) {
            this.f_96547_ = Minecraft.m_91087_().f_91062_;
        }
        poseStack.m_280056_(this.f_96547_, text, x + this.guiLeft - this.f_97735_, y + this.guiTop - this.f_97736_, color, shadow);
        return x;
    }

    public void drawXCenteredString(GuiGraphics graphics, int n, int n2, Component component, int n3, boolean bl) {
        this.drawCenteredString(graphics, n, n2, component, n3, bl, true, false);
    }

    public void drawXCenteredString(GuiGraphics graphics, int n, int n2, String component, int n3, boolean bl) {
        this.drawCenteredString(graphics, n, n2, component, n3, bl, true, false);
    }

    public void drawXYCenteredString(GuiGraphics graphics, int n, int n2, String string, int n3, boolean bl) {
        this.drawCenteredString(graphics, n, n2, string, n3, bl, true, true);
    }

    public void drawCenteredString(GuiGraphics graphics, int n, int n2, String string, int n3, boolean bl, boolean bl2, boolean bl3) {
        if (bl2) {
            n -= this.getStringWidth(string) / 2;
        }
        if (bl3) {
            n2 -= 4;
        }
        graphics.m_280056_(this.f_96547_, string, this.getGuiLeft() + n, this.getGuiTop() + n2, n3, false);
    }

    public void drawCenteredString(GuiGraphics graphics, int n, int n2, Component component, int n3, boolean bl, boolean bl2, boolean bl3) {
        if (bl2) {
            n -= this.getStringWidth(component) / 2;
        }
        if (bl3) {
            n2 -= 4;
        }
        graphics.m_280056_(this.f_96547_, component.getString(), this.getGuiLeft() + n, this.getGuiTop() + n2, n3, false);
    }

    public int getStringWidth(String string) {
        return this.f_96547_.m_92895_(string);
    }

    public int getStringWidth(Component component) {
        return this.f_96547_.m_92852_((FormattedText)component);
    }

    public String trimStringToWidth(String string, int n) {
        return this.f_96547_.m_92837_(string, n, false);
    }

    public String trimStringToWidthReverse(String string, int n) {
        return this.f_96547_.m_92837_(string, n, true);
    }

    public void renderItemTooltipGrid(GuiGraphics graphics, List<IInputItemStack> items, int mouseX, int mouseY) {
        int columns;
        Minecraft mc = Minecraft.m_91087_();
        int screenWidth = this.f_96543_ - mouseX;
        int screenHeight = this.f_96544_ - mouseY;
        int itemSize = 18;
        int padding = 6;
        int maxColumns = Math.min(12, Math.max(1, (screenWidth - 20) / itemSize));
        int itemsPerRow = columns = Math.min(maxColumns, items.size());
        int maxRows = Math.max(1, (screenHeight - 40) / itemSize);
        int itemsPerPage = itemsPerRow * maxRows;
        int totalPages = (int)Math.ceil((double)items.size() / (double)itemsPerPage);
        if (totalPages <= 0) {
            totalPages = 1;
        }
        int currentPage = (int)(System.currentTimeMillis() / 2000L % (long)totalPages);
        int startIndex = currentPage * itemsPerPage;
        int endIndex = Math.min(startIndex + itemsPerPage, items.size());
        List<IInputItemStack> visibleItems = items.subList(startIndex, endIndex);
        int rows = (int)Math.ceil((double)visibleItems.size() / (double)columns);
        int tooltipWidth = columns * itemSize + padding * 2;
        int tooltipHeight = rows * itemSize + padding * 2;
        int x = mouseX + 12;
        int y = mouseY - 12;
        if (x + tooltipWidth > screenWidth) {
            x = screenWidth - tooltipWidth - 4;
        }
        if (y + tooltipHeight > screenHeight) {
            y = screenHeight - tooltipHeight - 4;
        }
        if (x < 4) {
            x = 4;
        }
        if (y < 4) {
            y = 4;
        }
        TooltipRenderUtil.m_280205_((GuiGraphics)graphics, (int)x, (int)y, (int)tooltipWidth, (int)tooltipHeight, (int)400);
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(0.0f, 0.0f, 400.0f);
        RenderSystem.enableDepthTest();
        long tick = System.currentTimeMillis() / 1000L;
        for (int i = 0; i < visibleItems.size(); ++i) {
            int col = i % columns;
            int row = i / columns;
            int drawX = x + padding + col * itemSize;
            int drawY = y + padding + row * itemSize;
            List<ItemStack> stacks = visibleItems.get(i).getInputs();
            ItemStack stack = stacks.get((int)(tick % (long)stacks.size()));
            graphics.m_280480_(stack, drawX, drawY);
        }
        RenderSystem.disableDepthTest();
        graphics.m_280168_().m_85849_();
    }

    protected void m_280072_(GuiGraphics pGuiGraphics, int pX, int pY) {
        if (((ContainerBase)this.f_97732_).m_142621_().m_41619_() && this.f_97734_ != null && this.f_97734_.m_6657_()) {
            ItemStack itemstack = this.f_97734_.m_7993_();
            pGuiGraphics.renderTooltip(this.f_96547_, this.m_280553_(itemstack), itemstack.m_150921_(), itemstack, pX, pY);
        }
    }

    public void drawTooltip(GuiGraphics poseStack, int x, int y, ItemStack stack) {
        assert (!ModUtils.isEmpty(stack));
        poseStack.m_280153_(this.f_96547_, stack, x, y);
    }

    public void drawTooltipOnlyName(GuiGraphics poseStack, int x, int y, ItemStack stack, List<String> strings) {
        if (stack.m_41619_()) {
            return;
        }
        ArrayList<Component> tooltipComponents = new ArrayList<Component>();
        tooltipComponents.add(stack.m_41611_());
        strings.forEach(s -> tooltipComponents.add((Component)Component.m_237113_((String)s)));
        poseStack.m_280666_(this.f_96547_, tooltipComponents, x, y);
    }

    public void drawTooltip(int n, int n2, List<String> list) {
        this.queuedTooltips.add(new Tooltip(list, n, n2));
    }

    protected void flushTooltips(GuiGraphics graphics) {
        ArrayList<Tooltip> tooltips = new ArrayList<Tooltip>(this.queuedTooltips);
        ArrayList<Tooltip> tooltipsToRender = new ArrayList<Tooltip>();
        ArrayList<Rectangle> usedAreas = new ArrayList<Rectangle>();
        for (int i = tooltips.size() - 1; i >= 0; --i) {
            Tooltip tooltip = (Tooltip)tooltips.get(i);
            int maxWidth = 0;
            for (FormattedText formattedText : tooltip.text) {
                int lineWidth = Minecraft.m_91087_().f_91062_.m_92852_(formattedText);
                if (lineWidth <= maxWidth) continue;
                maxWidth = lineWidth;
            }
            int tooltipWidth = maxWidth + 8;
            int n = tooltip.text.size() * 10 + 8;
            Rectangle tooltipArea = new Rectangle(tooltip.x, tooltip.y, tooltipWidth, n);
            boolean overlaps = false;
            for (Rectangle area : usedAreas) {
                if (!tooltipArea.intersects(area)) continue;
                overlaps = true;
                break;
            }
            if (overlaps) continue;
            usedAreas.add(tooltipArea);
            tooltipsToRender.add(tooltip);
        }
        Collections.reverse(tooltipsToRender);
        for (Tooltip tooltip : tooltipsToRender) {
            graphics.m_280677_(this.f_96547_, tooltip.text, Optional.empty(), tooltip.x, tooltip.y);
        }
        this.queuedTooltips.clear();
    }

    protected void addElement(GuiElement<?> guiElement) {
        this.elements.add(guiElement);
    }

    public final void bindTexture() {
        GuiCore.bindTexture(this.getTexture());
    }

    protected ResourceLocation getTexture() {
        return new ResourceLocation("missing");
    }

    public void drawTexturedModalRect(GuiGraphics poseStack, int i, int i1, int i2, int i3, int i4, int i5) {
        poseStack.m_280218_(currentTexture, i, i1, i2, i3, i4, i5);
    }

    public void drawTextInCanvasWithScissor(GuiGraphics poseStack, String text, int canvasX, int canvasY, int canvasWidth, int canvasHeight, int scale) {
        int maxWidth = canvasWidth / 1;
        int lineHeight = 10;
        int x = canvasX;
        int y = canvasY;
        List<String> lines = this.splitTextToLines(text, maxWidth, 1.0f);
        for (int i = scale - 1; i < lines.size(); ++i) {
            String line = lines.get(i);
            if (y + lineHeight > canvasY + canvasHeight) break;
            poseStack.m_280168_().m_85836_();
            poseStack.m_280168_().m_85841_(1.0f, 1.0f, 1.0f);
            this.drawString(poseStack, line, x / 1, y / 1, 0xFFFFFF);
            poseStack.m_280168_().m_85849_();
            y += lineHeight;
        }
    }

    private static class Tooltip {
        final int x;
        final int y;
        final List<Component> text = new LinkedList<Component>();

        Tooltip(List<String> list, int n, int n2) {
            list.forEach(s -> this.text.add((Component)Component.m_237113_((String)s)));
            this.x = n;
            this.y = n2;
        }
    }
}

