/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.gui;

import com.denfop.Localization;
import com.denfop.api.energy.EnergyNetGlobal;
import com.denfop.api.gui.Area;
import com.denfop.container.ContainerElectricBlock;
import com.denfop.gui.GuiIU;
import com.denfop.tiles.base.TileElectricBlock;
import com.denfop.utils.ListInformationUtils;
import com.denfop.utils.ModUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;

public class GuiElectricBlock<T extends ContainerElectricBlock>
extends GuiIU<ContainerElectricBlock> {
    private static final ResourceLocation background = new ResourceLocation("industrialupgrade", "textures/gui/GUIElectricBlockEuRf.png".toLowerCase());
    private final ContainerElectricBlock container;
    private final String armorInv;
    private final String name;

    public GuiElectricBlock(ContainerElectricBlock container1) {
        super(container1);
        this.f_97727_ = 167;
        this.componentList.clear();
        this.container = container1;
        this.armorInv = Localization.translate("EUStorage.gui.info.armor");
        this.name = Localization.translate(((TileElectricBlock)this.container.base).getName());
    }

    @Override
    protected ResourceLocation getTexture() {
        if (((TileElectricBlock)this.container.base).energy.getSourceTier() == 1) {
            return new ResourceLocation("industrialupgrade", "textures/gui/GUIElectricBlockEuRf1.png".toLowerCase());
        }
        if (((TileElectricBlock)this.container.base).energy.getSourceTier() == 2) {
            return new ResourceLocation("industrialupgrade", "textures/gui/GUIElectricBlockEuRf2.png".toLowerCase());
        }
        return new ResourceLocation("industrialupgrade", "textures/gui/GUIElectricBlockEuRf.png".toLowerCase());
    }

    @Override
    protected void drawForegroundLayer(GuiGraphics poseStack, int par1, int par2) {
        super.drawForegroundLayer(poseStack, par1, par2);
        this.draw(poseStack, this.name, (int)((float)(this.f_97726_ - this.getStringWidth(this.name)) / 2.0f), 6, 0x404040);
        String tooltip = "EF: " + ModUtils.getString(((TileElectricBlock)this.container.base).energy.getEnergy()) + "/" + ModUtils.getString(((TileElectricBlock)this.container.base).energy.getCapacity());
        ((Area)new Area(this, 62, 27, 79, 22).withTooltip(tooltip)).drawForeground(poseStack, par1, par2);
        String output = Localization.translate("EUStorage.gui.info.output", ModUtils.getString(EnergyNetGlobal.instance.getPowerFromTier(((TileElectricBlock)this.container.base).energy.getSourceTier())));
        this.draw(poseStack, output, 77, 17, 0x404040);
        this.handleUpgradeTooltip(par1, par2);
    }

    @Override
    protected void drawBackgroundAndTitle(GuiGraphics poseStack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiElectricBlock.bindTexture(this.getTexture());
        int j = this.guiLeft;
        int k = this.guiTop;
        this.drawTexturedModalRect(poseStack, j, k, 0, 0, this.f_97726_, this.f_97727_);
        GuiElectricBlock.bindTexture(new ResourceLocation("industrialupgrade", "textures/gui/infobutton.png"));
        this.drawTexturedModalRect(poseStack, j + 3, k + 3, 0, 0, 10, 10);
        GuiElectricBlock.bindTexture(this.getTexture());
        if (((TileElectricBlock)this.container.base).energy.getEnergy() > 0.0) {
            int i1 = (int)(78.0f * ((TileElectricBlock)this.container.base).getChargeLevel());
            this.drawTexturedModalRect(poseStack, j + 62, k + 27, 176, 0, i1 + 1, 22);
        }
    }

    private void handleUpgradeTooltip(int mouseX, int mouseY) {
        if (mouseX >= 0 && mouseX <= 12 && mouseY >= 0 && mouseY <= 12) {
            ArrayList<String> text = new ArrayList<String>();
            text.add(Localization.translate("iu.electricstorageinformation"));
            List<String> compatibleUpgrades = ListInformationUtils.storageinform;
            for (String itemstack : compatibleUpgrades) {
                text.add(itemstack);
            }
            this.drawTooltip(mouseX, mouseY, text);
        }
    }
}

