/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.gui;

import com.denfop.Localization;
import com.denfop.api.gui.Component;
import com.denfop.api.gui.EnumTypeComponent;
import com.denfop.api.gui.GuiComponent;
import com.denfop.api.gui.SteamImageInterface;
import com.denfop.api.gui.TankGauge;
import com.denfop.componets.ComponentProgress;
import com.denfop.componets.ComponentSteamEnergy;
import com.denfop.componets.EnumTypeStyle;
import com.denfop.componets.PressureComponent;
import com.denfop.container.ContainerSteamDryer;
import com.denfop.gui.GuiIU;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.tiles.mechanism.steam.TileEntitySteamDryer;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fluids.IFluidTank;

public class GuiSteamDryer<T extends ContainerSteamDryer>
extends GuiIU<ContainerSteamDryer> {
    public final ContainerSteamDryer container;

    public GuiSteamDryer(ContainerSteamDryer container1) {
        super(container1, EnumTypeStyle.STEAM);
        this.container = container1;
        this.addElement(new SteamImageInterface(this, 0, 0, this.f_97726_, this.f_97727_));
        this.addElement(TankGauge.createNormal(this, 43, 21, (IFluidTank)((TileEntitySteamDryer)this.container.base).fluidTank1));
        this.addComponent(new GuiComponent(this, 7, 64, EnumTypeComponent.STEAM_FLUID, new Component<ComponentSteamEnergy>(((TileEntitySteamDryer)this.container.base).steam)));
        this.addComponent(new GuiComponent(this, 10, 54, EnumTypeComponent.NULL, new Component<PressureComponent>(((TileEntitySteamDryer)this.container.base).pressure)));
        this.addComponent(new GuiComponent(this, 70, 40, EnumTypeComponent.STEAM_PROCESS2, new Component<1>(new ComponentProgress((TileEntityInventory)this.container.base, 1, 0){

            @Override
            public double getBar() {
                return ((TileEntitySteamDryer)GuiSteamDryer.this.container.base).getProgress();
            }
        })));
    }

    private void handleUpgradeTooltip(int mouseX, int mouseY) {
        if (mouseX >= 3 && mouseX <= 13 && mouseY >= 3 && mouseY <= 13) {
            ArrayList<String> text = new ArrayList<String>();
            text.add(Localization.translate("steam_machine.info"));
            ArrayList<String> compatibleUpgrades = new ArrayList<String>();
            for (int i = 1; i < 11; ++i) {
                compatibleUpgrades.add(Localization.translate("steam_machine.info" + i));
            }
            for (String itemstack : compatibleUpgrades) {
                text.add(itemstack);
            }
            this.drawTooltip(mouseX - 60, mouseY, text);
        }
    }

    @Override
    protected void drawForegroundLayer(GuiGraphics poseStack, int par1, int par2) {
        super.drawForegroundLayer(poseStack, par1, par2);
        this.handleUpgradeTooltip(par1, par2);
    }

    @Override
    protected void drawBackgroundAndTitle(GuiGraphics poseStack, float partialTicks, int mouseX, int mouseY) {
        this.bindTexture();
        this.drawTexturedModalRect(poseStack, this.guiLeft, this.guiTop, 0, 0, this.f_97726_, this.f_97727_);
        GuiSteamDryer.bindTexture(new ResourceLocation("industrialupgrade", "textures/gui/infobutton.png"));
        this.drawTexturedRect(poseStack, 3.0, 3.0, 10.0, 10.0, 0.0, 0.0);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(GuiGraphics poseStack, float f, int x, int y) {
        super.drawGuiContainerBackgroundLayer(poseStack, f, x, y);
        GuiSteamDryer.bindTexture(this.getTexture());
        int progress = (int)(32.0 * ((TileEntitySteamDryer)this.container.base).getProgress());
        int xoffset = this.guiLeft;
        int yoffset = this.guiTop;
        if (progress > 0) {
            this.drawTexturedModalRect(poseStack, xoffset + 88, yoffset + 40, 177, 41, progress, 19);
        }
        String name = Localization.translate(((TileEntitySteamDryer)this.container.base).getName());
        this.drawXCenteredString(poseStack, this.f_97726_ / 2 + 15, 5, name, 0x404040, false);
    }

    @Override
    public ResourceLocation getTexture() {
        return new ResourceLocation("industrialupgrade", "textures/gui/guimachine.png");
    }
}

