/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.crops;

import com.denfop.api.agriculture.CropNetwork;
import com.denfop.api.agriculture.ICrop;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;

public class CropHandler {
    private static final List<CropHandler> recipes = new ArrayList<CropHandler>();
    public final ICrop output;

    public CropHandler(ICrop output) {
        this.output = output;
    }

    public static List<CropHandler> getRecipes() {
        if (recipes.isEmpty()) {
            CropHandler.initRecipes();
        }
        return recipes;
    }

    public static CropHandler addRecipe(ICrop output) {
        CropHandler recipe = new CropHandler(output);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public ItemStack getInputs() {
        return this.output.getStack();
    }

    public ICrop getOutput() {
        return this.output;
    }

    public ItemStack getOutputs() {
        return this.output.getDrop().isEmpty() ? ItemStack.f_41583_ : this.output.getDrop().get(0);
    }

    public static CropHandler getRecipe(ItemStack is) {
        if (is == null || is.m_41619_()) {
            return null;
        }
        return recipes.get(0);
    }

    public static void initRecipes() {
        CropNetwork.instance.getCropMap().forEach((integer, crop) -> {
            if (crop.getId() != 3) {
                CropHandler.addRecipe(crop);
            }
        });
    }
}

