/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.genstone;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.gui.ItemStackImage;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.gui.GuiIU;
import com.denfop.integration.jei.IRecipeCategory;
import com.denfop.integration.jei.JeiInform;
import com.denfop.integration.jei.genstone.GenStoneHandler;
import com.denfop.recipes.ItemStackHelper;
import com.denfop.tiles.mechanism.TileEntityNuclearWasteRecycler;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public class GenStoneCategory
extends GuiIU
implements IRecipeCategory<GenStoneHandler> {
    private final IDrawableStatic bg;
    private final JeiInform jeiInform;
    private int energy = 0;

    public GenStoneCategory(IGuiHelper guiHelper, JeiInform jeiInform) {
        super(((TileEntityNuclearWasteRecycler)BlockBaseMachine3.nuclear_waste_recycler.getDummyTe()).getGuiContainer((Player)Minecraft.m_91087_().f_91074_));
        this.jeiInform = jeiInform;
        this.f_96539_ = Component.m_237113_((String)this.getTitles());
        this.bg = guiHelper.createDrawable(new ResourceLocation("industrialupgrade", "textures/gui/GuiGenStone".toLowerCase() + ".png"), 3, 3, 140, 75);
    }

    public RecipeType<GenStoneHandler> getRecipeType() {
        return this.jeiInform.recipeType;
    }

    @Override
    @Nonnull
    public String getTitles() {
        return Localization.translate(ItemStackHelper.fromData(IUItem.machines, 1, 7).m_41778_());
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.bg;
    }

    public void draw(GenStoneHandler recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics stack, double mouseX, double mouseY) {
        ++this.energy;
        int energylevel = (int)Math.min(14.0f * (float)this.energy / 100.0f, 14.0f);
        GenStoneCategory.bindTexture(this.getTexture());
        this.drawTexturedModalRect(stack, 6, 47 - energylevel, 176, 14 - energylevel, 14, energylevel);
        new ItemStackImage(this, 61, 25, () -> new ItemStack((ItemLike)Blocks.f_50652_)).drawBackground(stack, 0, 0);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, GenStoneHandler recipes, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 35, 19).addItemStack(recipes.getInput());
        builder.addSlot(RecipeIngredientRole.INPUT, 35, 47).addItemStack(recipes.getInput1());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 87, 6).addItemStack(recipes.getOutput());
    }

    @Override
    protected ResourceLocation getTexture() {
        return new ResourceLocation("industrialupgrade", "textures/gui/GuiGenStone.png".toLowerCase());
    }
}

