/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.laser;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;

public class LaserHandler {
    private static final List<LaserHandler> recipes = new ArrayList<LaserHandler>();
    private final ItemStack input;
    private final ItemStack output;
    private final BaseMachineRecipe container;

    public LaserHandler(ItemStack input, ItemStack output, BaseMachineRecipe container) {
        this.input = input;
        this.output = output;
        this.container = container;
    }

    public BaseMachineRecipe getContainer() {
        return this.container;
    }

    public static List<LaserHandler> getRecipes() {
        if (recipes.isEmpty()) {
            LaserHandler.initRecipes();
        }
        return recipes;
    }

    public static LaserHandler addRecipe(ItemStack input, ItemStack output, BaseMachineRecipe container) {
        LaserHandler recipe = new LaserHandler(input, output, container);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static LaserHandler getRecipe(ItemStack is) {
        if (is == null || is.m_41619_()) {
            return null;
        }
        for (LaserHandler recipe : recipes) {
            if (!recipe.matchesInput(is)) continue;
            return recipe;
        }
        return null;
    }

    public static void initRecipes() {
        for (BaseMachineRecipe container : Recipes.recipes.getRecipeList("laser")) {
            LaserHandler.addRecipe(container.input.getInputs().get(0).getInputs().get(0), container.getOutput().items.get(0), container);
        }
    }

    public ItemStack getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output.m_41777_();
    }

    public boolean matchesInput(ItemStack is) {
        return true;
    }
}

