/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.upgradeblock;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.gui.GuiIU;
import com.denfop.integration.jei.IRecipeCategory;
import com.denfop.integration.jei.JeiInform;
import com.denfop.integration.jei.upgradeblock.UpgradeBlockHandler;
import com.denfop.recipes.ItemStackHelper;
import com.denfop.tiles.mechanism.TileTunerWireless;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class UpgradeBlockCategory
extends GuiIU
implements IRecipeCategory<UpgradeBlockHandler> {
    private final IDrawableStatic bg;
    private int progress = 0;
    private int energy = 0;
    JeiInform jeiInform;

    public UpgradeBlockCategory(IGuiHelper guiHelper, JeiInform jeiInform) {
        super(((TileTunerWireless)BlockBaseMachine3.tuner.getDummyTe()).getGuiContainer((Player)Minecraft.m_91087_().f_91074_));
        this.bg = guiHelper.createDrawable(new ResourceLocation("industrialupgrade", "textures/gui/GuiUpgradeBlock".toLowerCase() + ".png"), 3, 3, 148, 80);
        this.jeiInform = jeiInform;
        this.f_96539_ = Component.m_237113_((String)this.getTitles());
    }

    public RecipeType<UpgradeBlockHandler> getRecipeType() {
        return this.jeiInform.recipeType;
    }

    @Override
    @Nonnull
    public String getTitles() {
        return Localization.translate(ItemStackHelper.fromData(IUItem.upgradeblock).m_41778_());
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.bg;
    }

    public void draw(UpgradeBlockHandler recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics stack, double mouseX, double mouseY) {
        ++this.progress;
        int xScale = 27 * this.progress / 100;
        int xScale1 = 27 * this.progress / 100;
        if (xScale > 27) {
            this.progress = 0;
        }
        this.draw(stack, recipe.metadata.m_128461_("type").isEmpty() ? Localization.translate("upgradeblock_upgrade") : Localization.translate("upgradeblock_modification"), 64, 58, 0x404040);
        UpgradeBlockCategory.bindTexture(this.getTexture());
        this.drawTexturedModalRect(stack, 33, 35, 180, 7, xScale + 1, 16);
        this.drawTexturedModalRect(stack, 78, 35, 225, 7, xScale1 + 1, 16);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, UpgradeBlockHandler recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 16, 35).addItemStack(recipe.getInput());
        builder.addSlot(RecipeIngredientRole.INPUT, 61, 35).addItemStack(recipe.getInput1());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 110, 35).addItemStack(recipe.getOutput());
    }

    @Override
    protected ResourceLocation getTexture() {
        return new ResourceLocation("industrialupgrade", "textures/gui/GuiUpgradeBlock.png".toLowerCase());
    }
}

