/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.invslot;

import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.recipe.InvSlotOutput;
import com.denfop.invslot.InvSlot;
import com.denfop.utils.ModUtils;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.apache.commons.lang3.mutable.MutableObject;

public class InvSlotFluid
extends InvSlot {
    private TypeFluidSlot typeFluidSlot;

    public InvSlotFluid(IAdvInventory<?> base1, int count) {
        this(base1, InvSlot.TypeItemSlot.INPUT, count, TypeFluidSlot.INPUT);
    }

    public InvSlotFluid(IAdvInventory<?> base1, InvSlot.TypeItemSlot typeItemSlot1, int count, TypeFluidSlot typeFluidSlot1) {
        super(base1, typeItemSlot1, count);
        this.typeFluidSlot = typeFluidSlot1;
    }

    public void setTypeFluidSlot(TypeFluidSlot typeFluidSlot) {
        this.typeFluidSlot = typeFluidSlot;
    }

    @Override
    public boolean accepts(ItemStack stack, int index) {
        FluidStack containerFluid;
        ItemStack singleStack = ModUtils.setSize(stack, 1);
        IFluidHandlerItem handler = null;
        try {
            handler = (IFluidHandlerItem)singleStack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM, null).orElse((Object)((IFluidHandlerItem)singleStack.m_41720_().initCapabilities(singleStack, singleStack.m_41783_())));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ModUtils.isEmpty(singleStack)) {
            return false;
        }
        if (handler == null) {
            return false;
        }
        if ((this.typeFluidSlot == TypeFluidSlot.INPUT || this.typeFluidSlot == TypeFluidSlot.INPUT_OUTPUT) && !(containerFluid = handler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE)).isEmpty() && containerFluid.getAmount() > 0 && this.acceptsLiquid(containerFluid.getFluid())) {
            return true;
        }
        return (this.typeFluidSlot == TypeFluidSlot.OUTPUT || this.typeFluidSlot == TypeFluidSlot.INPUT_OUTPUT) && handler.getFluidInTank(0).isEmpty();
    }

    public FluidStack drain(Fluid fluid, int maxAmount, MutableObject<ItemStack> output, boolean simulate) {
        output.setValue(null);
        if (fluid != Fluids.f_76191_ && !this.acceptsLiquid(fluid)) {
            return null;
        }
        if (this.typeFluidSlot != TypeFluidSlot.INPUT && this.typeFluidSlot != TypeFluidSlot.INPUT_OUTPUT) {
            return null;
        }
        ItemStack stack = this.get(0).m_41777_();
        stack.m_41764_(1);
        if (ModUtils.isEmpty(stack)) {
            return null;
        }
        IFluidHandlerItem handler = (IFluidHandlerItem)stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM, null).orElse((Object)((IFluidHandlerItem)stack.m_41720_().initCapabilities(stack, stack.m_41783_())));
        FluidStack fs = fluid == Fluids.f_76191_ ? handler.drain(maxAmount, IFluidHandler.FluidAction.EXECUTE) : handler.drain(new FluidStack(fluid, Math.min(maxAmount, handler.getFluidInTank(0).getAmount())), IFluidHandler.FluidAction.EXECUTE);
        if (!fs.isEmpty() && fs.getAmount() > 0) {
            ItemStack inPlace = handler.getContainer();
            assert (fs.getAmount() > 0);
            if (!this.acceptsLiquid(fs.getFluid())) {
                return null;
            }
            output.setValue((Object)inPlace);
            if (!simulate) {
                this.get(0).m_41774_(1);
            }
            return fs;
        }
        return null;
    }

    public int fill(FluidStack fs, MutableObject<ItemStack> output, boolean simulate) {
        output.setValue(null);
        if (!fs.isEmpty() && fs.getAmount() > 0) {
            FluidStack fsChange;
            if (this.typeFluidSlot != TypeFluidSlot.OUTPUT && this.typeFluidSlot != TypeFluidSlot.INPUT_OUTPUT) {
                return 0;
            }
            ItemStack stack = this.get(0).m_41777_();
            stack.m_41764_(1);
            if (ModUtils.isEmpty(stack)) {
                return 0;
            }
            IFluidHandlerItem handler = (IFluidHandlerItem)stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM, null).orElse((Object)((IFluidHandlerItem)stack.m_41720_().initCapabilities(stack, stack.m_41783_())));
            int amount = handler.fill(fsChange = fs.copy(), IFluidHandler.FluidAction.EXECUTE);
            if (amount <= 0) {
                return 0;
            }
            fsChange.setAmount(amount);
            FluidStack fillTestFs = fs.copy();
            fillTestFs.setAmount(Integer.MAX_VALUE);
            handler.fill(fillTestFs, IFluidHandler.FluidAction.SIMULATE);
            ItemStack inPlace = stack = handler.getContainer();
            output.setValue((Object)inPlace);
            if (!simulate) {
                this.get(0).m_41774_(1);
            }
            return fsChange.getAmount();
        }
        return 0;
    }

    public boolean transferToTank(IFluidTank tank, MutableObject<ItemStack> output, boolean simulate) {
        FluidStack fluid;
        if (this.isEmpty()) {
            return false;
        }
        int space = tank.getCapacity();
        Fluid fluidRequired = Fluids.f_76191_;
        FluidStack tankFluid = tank.getFluid();
        if (!tankFluid.isEmpty()) {
            space -= tankFluid.getAmount();
            fluidRequired = tankFluid.getFluid();
        }
        if ((fluid = this.drain(fluidRequired, space, output, true)) == null) {
            return false;
        }
        int amount = tank.fill(fluid, simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE);
        if (amount <= 0) {
            return false;
        }
        if (!simulate) {
            this.drain(fluidRequired, amount, output, false);
        }
        return true;
    }

    public boolean transferFromTank(IFluidTank tank, MutableObject<ItemStack> output, boolean simulate) {
        if (this.isEmpty()) {
            return false;
        }
        FluidStack tankFluid = tank.drain(tank.getFluidAmount(), IFluidHandler.FluidAction.SIMULATE);
        if (!tankFluid.isEmpty() && tankFluid.getAmount() > 0) {
            int amount = this.fill(tankFluid, output, simulate);
            if (amount <= 0) {
                return false;
            }
            if (!simulate) {
                tank.drain(amount, IFluidHandler.FluidAction.EXECUTE);
            }
            return true;
        }
        return false;
    }

    public boolean processIntoTank(IFluidTank tank, InvSlotOutput outputSlot) {
        if (this.isEmpty()) {
            return false;
        }
        MutableObject output = new MutableObject();
        boolean wasChange = false;
        if (this.transferToTank(tank, (MutableObject<ItemStack>)output, true) && (ModUtils.isEmpty((ItemStack)output.getValue()) || outputSlot.canAdd((ItemStack)output.getValue()))) {
            wasChange = this.transferToTank(tank, (MutableObject<ItemStack>)output, false);
            if (!ModUtils.isEmpty((ItemStack)output.getValue())) {
                outputSlot.add((ItemStack)output.getValue());
            }
        }
        return wasChange;
    }

    public boolean processFromTank(IFluidTank tank, InvSlotOutput outputSlot) {
        if (!this.isEmpty() && tank.getFluidAmount() > 0) {
            MutableObject output = new MutableObject();
            boolean wasChange = false;
            if (this.transferFromTank(tank, (MutableObject<ItemStack>)output, true) && (ModUtils.isEmpty((ItemStack)output.getValue()) || outputSlot.canAdd((ItemStack)output.getValue()))) {
                wasChange = this.transferFromTank(tank, (MutableObject<ItemStack>)output, false);
                if (!ModUtils.isEmpty((ItemStack)output.getValue())) {
                    outputSlot.add((ItemStack)output.getValue());
                }
            }
            return wasChange;
        }
        return false;
    }

    protected boolean acceptsLiquid(Fluid fluid) {
        return true;
    }

    protected Iterable<Fluid> getPossibleFluids() {
        return null;
    }

    public static enum TypeFluidSlot {
        INPUT,
        OUTPUT,
        INPUT_OUTPUT;

    }
}

