/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.blocks.BlockApatite;
import com.denfop.blocks.BlockClassicOre;
import com.denfop.blocks.BlockHeavyOre;
import com.denfop.blocks.BlockMineral;
import com.denfop.blocks.BlockOre;
import com.denfop.blocks.BlockOres2;
import com.denfop.blocks.BlockOres3;
import com.denfop.blocks.BlockPreciousOre;
import com.denfop.blocks.BlocksRadiationOre;
import com.denfop.blocks.ISubEnum;
import com.denfop.items.DataOres;
import com.denfop.items.IItemStackInventory;
import com.denfop.items.IProperties;
import com.denfop.items.ItemMain;
import com.denfop.items.ItemStackVeinSensor;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.IUpdatableItemStackEvent;
import com.denfop.utils.ModUtils;
import com.denfop.utils.Vector2;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class ItemVeinSensor<T extends Enum<T>>
extends ItemMain<T>
implements IUpdatableItemStackEvent,
IItemStackInventory,
IProperties {
    public static final Map<String, Integer> ORE_INDEX_MAP = new HashMap<String, Integer>();

    public ItemVeinSensor(T element) {
        super(new Item.Properties().m_41487_(1), element);
        IUCore.proxy.addProperties(this);
    }

    @Override
    public CreativeModeTab getItemCategory() {
        return IUCore.EnergyTab;
    }

    public static Map<Vector2, DataOres> getDataChunk(ChunkAccess chunk) {
        HashMap<Vector2, DataOres> map = new HashMap<Vector2, DataOres>();
        for (int x = chunk.m_7697_().f_45578_ * 16; x < chunk.m_7697_().f_45578_ * 16 + 16; ++x) {
            for (int z = chunk.m_7697_().f_45579_ * 16; z < chunk.m_7697_().f_45579_ * 16 + 16; ++z) {
                for (int y = 0; y < chunk.m_5885_(Heightmap.Types.WORLD_SURFACE, x, z); ++y) {
                    BlockState blockState = chunk.m_8055_(new BlockPos(x, y, z));
                    int color = ItemVeinSensor.getOreColor(blockState);
                    Vector2 vector2 = new Vector2(x, z);
                    if (color == -1) continue;
                    if (!map.containsKey(vector2)) {
                        map.put(vector2, new DataOres(blockState, color));
                        continue;
                    }
                    map.replace(vector2, new DataOres(blockState, color));
                }
            }
        }
        return map;
    }

    public static int getOreColor(BlockState state) {
        Block block = state.m_60734_();
        if (block == Blocks.f_49996_) {
            return ModUtils.convertRGBcolorToInt(156, 156, 156);
        }
        if (block == Blocks.f_49995_) {
            return -10496;
        }
        if (block == Blocks.f_50089_) {
            return -16711681;
        }
        if (block == Blocks.f_50059_) {
            return ModUtils.convertRGBcolorToInt(30, 50, 173);
        }
        if (block == Blocks.f_50173_) {
            return ModUtils.convertRGBcolorToInt(173, 30, 30);
        }
        if (block == Blocks.f_49997_) {
            return ModUtils.convertRGBcolorToInt(4, 4, 4);
        }
        if (block == Blocks.f_50264_) {
            return ModUtils.convertRGBcolorToInt(0, 232, 0);
        }
        if (block == Blocks.f_50331_) {
            return ModUtils.convertRGBcolorToInt(223, 223, 223);
        }
        if (block == IUItem.toriyore.getBlock(0)) {
            return ModUtils.convertRGBcolorToInt(134, 134, 139);
        }
        if (block instanceof BlockClassicOre) {
            int meta = ((ISubEnum)((BlockClassicOre)block).getElement()).getId();
            switch (meta) {
                case 0: {
                    return ModUtils.convertRGBcolorToInt(255, 144, 0);
                }
                case 1: {
                    return ModUtils.convertRGBcolorToInt(223, 223, 223);
                }
                case 2: {
                    return ModUtils.convertRGBcolorToInt(168, 176, 150);
                }
                case 3: {
                    return ModUtils.convertRGBcolorToInt(89, 158, 73);
                }
            }
            return ModUtils.convertRGBcolorToInt(4, 4, 4);
        }
        if (block instanceof BlocksRadiationOre) {
            int meta = ((ISubEnum)((BlocksRadiationOre)block).getElement()).getId();
            switch (meta) {
                case 0: {
                    return ModUtils.convertRGBcolorToInt(120, 152, 183);
                }
                case 1: {
                    return ModUtils.convertRGBcolorToInt(97, 109, 88);
                }
                case 2: {
                    return ModUtils.convertRGBcolorToInt(150, 166, 148);
                }
            }
            return ModUtils.convertRGBcolorToInt(4, 4, 4);
        }
        if (block instanceof BlockPreciousOre) {
            int meta = ((ISubEnum)((BlockPreciousOre)block).getElement()).getId();
            switch (meta) {
                case 0: {
                    return ModUtils.convertRGBcolorToInt(251, 140, 119);
                }
                case 1: {
                    return ModUtils.convertRGBcolorToInt(38, 60, 143);
                }
                case 2: {
                    return ModUtils.convertRGBcolorToInt(204, 180, 47);
                }
                case 3: {
                    return ModUtils.convertRGBcolorToInt(200, 205, 207);
                }
            }
            return ModUtils.convertRGBcolorToInt(4, 4, 4);
        }
        if (block instanceof BlockOre) {
            int meta = ((ISubEnum)((BlockOre)block).getElement()).getId();
            switch (meta) {
                case 0: {
                    return ModUtils.convertRGBcolorToInt(119, 210, 202);
                }
                case 1: {
                    return ModUtils.convertRGBcolorToInt(108, 74, 108);
                }
                case 2: {
                    return ModUtils.convertRGBcolorToInt(142, 240, 216);
                }
                case 3: {
                    return ModUtils.convertRGBcolorToInt(199, 199, 199);
                }
                case 4: {
                    return ModUtils.convertRGBcolorToInt(0, 166, 226);
                }
                case 5: {
                    return ModUtils.convertRGBcolorToInt(170, 145, 160);
                }
                case 6: {
                    return ModUtils.convertRGBcolorToInt(145, 143, 88);
                }
                case 7: {
                    return ModUtils.convertRGBcolorToInt(104, 152, 237);
                }
                case 8: {
                    return ModUtils.convertRGBcolorToInt(71, 71, 71);
                }
                case 9: {
                    return ModUtils.convertRGBcolorToInt(83, 174, 85);
                }
                case 10: {
                    return ModUtils.convertRGBcolorToInt(184, 87, 145);
                }
                case 11: {
                    return ModUtils.convertRGBcolorToInt(211, 211, 211);
                }
                case 12: {
                    return ModUtils.convertRGBcolorToInt(186, 186, 186);
                }
                case 13: {
                    return ModUtils.convertRGBcolorToInt(235, 193, 207);
                }
                case 14: {
                    return ModUtils.convertRGBcolorToInt(234, 234, 234);
                }
                case 15: {
                    return ModUtils.convertRGBcolorToInt(138, 85, 34);
                }
            }
            return ModUtils.convertRGBcolorToInt(4, 4, 4);
        }
        if (block instanceof BlockApatite) {
            int meta = ((ISubEnum)((BlockApatite)block).getElement()).getId();
            switch (meta) {
                case 0: {
                    return ModUtils.convertRGBcolorToInt(48, 86, 16);
                }
                case 1: {
                    return ModUtils.convertRGBcolorToInt(134, 95, 11);
                }
                case 2: {
                    return ModUtils.convertRGBcolorToInt(202, 202, 202);
                }
                case 3: {
                    return ModUtils.convertRGBcolorToInt(202, 202, 202);
                }
                case 4: {
                    return ModUtils.convertRGBcolorToInt(202, 202, 202);
                }
            }
            return ModUtils.convertRGBcolorToInt(4, 4, 4);
        }
        if (block instanceof BlockHeavyOre) {
            int meta = ((ISubEnum)((BlockHeavyOre)block).getElement()).getId();
            switch (meta) {
                case 0: {
                    return ModUtils.convertRGBcolorToInt(137, 131, 149);
                }
                case 1: {
                    return ModUtils.convertRGBcolorToInt(249, 175, 44);
                }
                case 2: {
                    return ModUtils.convertRGBcolorToInt(150, 215, 206);
                }
                case 3: {
                    return ModUtils.convertRGBcolorToInt(211, 202, 110);
                }
                case 4: {
                    return ModUtils.convertRGBcolorToInt(212, 175, 55);
                }
                case 5: {
                    return ModUtils.convertRGBcolorToInt(250, 246, 241);
                }
                case 6: {
                    return ModUtils.convertRGBcolorToInt(70, 145, 15);
                }
                case 7: {
                    return ModUtils.convertRGBcolorToInt(230, 107, 0);
                }
                case 8: {
                    return ModUtils.convertRGBcolorToInt(139, 0, 0);
                }
                case 9: {
                    return ModUtils.convertRGBcolorToInt(55, 135, 135);
                }
                case 10: {
                    return ModUtils.convertRGBcolorToInt(170, 123, 44);
                }
                case 11: {
                    return ModUtils.convertRGBcolorToInt(109, 206, 167);
                }
                case 12: {
                    return ModUtils.convertRGBcolorToInt(110, 110, 110);
                }
                case 13: {
                    return ModUtils.convertRGBcolorToInt(198, 147, 64);
                }
                case 14: {
                    return ModUtils.convertRGBcolorToInt(100, 76, 136);
                }
                case 15: {
                    return ModUtils.convertRGBcolorToInt(135, 84, 64);
                }
            }
            return ModUtils.convertRGBcolorToInt(4, 4, 4);
        }
        if (block instanceof BlockMineral) {
            int meta = ((ISubEnum)((BlockMineral)block).getElement()).getId();
            switch (meta) {
                case 0: {
                    return ModUtils.convertRGBcolorToInt(12, 166, 166);
                }
                case 1: {
                    return ModUtils.convertRGBcolorToInt(55, 117, 104);
                }
                case 2: {
                    return ModUtils.convertRGBcolorToInt(113, 97, 81);
                }
                case 3: {
                    return ModUtils.convertRGBcolorToInt(99, 51, 4);
                }
                case 4: {
                    return ModUtils.convertRGBcolorToInt(117, 88, 86);
                }
                case 5: {
                    return ModUtils.convertRGBcolorToInt(118, 28, 17);
                }
                case 6: {
                    return ModUtils.convertRGBcolorToInt(123, 76, 10);
                }
                case 7: {
                    return ModUtils.convertRGBcolorToInt(126, 101, 36);
                }
                case 8: {
                    return ModUtils.convertRGBcolorToInt(30, 126, 56);
                }
                case 9: {
                    return ModUtils.convertRGBcolorToInt(112, 129, 30);
                }
                case 10: {
                    return ModUtils.convertRGBcolorToInt(43, 43, 43);
                }
                case 11: {
                    return ModUtils.convertRGBcolorToInt(39, 64, 63);
                }
                case 12: {
                    return ModUtils.convertRGBcolorToInt(110, 25, 24);
                }
            }
            return ModUtils.convertRGBcolorToInt(4, 4, 4);
        }
        if (block instanceof BlockOres3) {
            int meta = ((ISubEnum)((BlockOres3)block).getElement()).getId();
            switch (meta) {
                case 0: {
                    return ModUtils.convertRGBcolorToInt(191, 212, 65);
                }
                case 1: {
                    return ModUtils.convertRGBcolorToInt(253, 242, 80);
                }
                case 2: {
                    return ModUtils.convertRGBcolorToInt(37, 145, 133);
                }
                case 3: {
                    return ModUtils.convertRGBcolorToInt(255, 180, 0);
                }
                case 4: {
                    return ModUtils.convertRGBcolorToInt(252, 187, 89);
                }
                case 5: {
                    return ModUtils.convertRGBcolorToInt(212, 231, 255);
                }
                case 6: {
                    return ModUtils.convertRGBcolorToInt(222, 101, 98);
                }
                case 7: {
                    return ModUtils.convertRGBcolorToInt(118, 84, 192);
                }
                case 8: {
                    return ModUtils.convertRGBcolorToInt(125, 122, 160);
                }
                case 9: {
                    return ModUtils.convertRGBcolorToInt(61, 148, 224);
                }
                case 10: {
                    return ModUtils.convertRGBcolorToInt(230, 105, 17);
                }
                case 11: {
                    return ModUtils.convertRGBcolorToInt(84, 194, 246);
                }
                case 12: {
                    return ModUtils.convertRGBcolorToInt(168, 90, 41);
                }
                case 13: {
                    return ModUtils.convertRGBcolorToInt(121, 229, 71);
                }
                case 14: {
                    return ModUtils.convertRGBcolorToInt(255, 225, 136);
                }
                case 15: {
                    return ModUtils.convertRGBcolorToInt(217, 225, 94);
                }
            }
            return ModUtils.convertRGBcolorToInt(4, 4, 4);
        }
        if (block instanceof BlockOres2) {
            int meta = ((ISubEnum)((BlockOres2)block).getElement()).getId();
            switch (meta) {
                case 0: {
                    return ModUtils.convertRGBcolorToInt(190, 207, 214);
                }
                case 1: {
                    return ModUtils.convertRGBcolorToInt(194, 194, 194);
                }
                case 2: {
                    return ModUtils.convertRGBcolorToInt(62, 69, 71);
                }
                case 3: {
                    return ModUtils.convertRGBcolorToInt(165, 236, 244);
                }
                case 4: {
                    return ModUtils.convertRGBcolorToInt(141, 174, 83);
                }
                case 5: {
                    return ModUtils.convertRGBcolorToInt(177, 100, 197);
                }
                case 6: {
                    return ModUtils.convertRGBcolorToInt(43, 43, 43);
                }
                case 7: {
                    return ModUtils.convertRGBcolorToInt(212, 212, 212);
                }
            }
            return ModUtils.convertRGBcolorToInt(4, 4, 4);
        }
        return -1;
    }

    @Override
    public IAdvInventory getInventory(Player player, ItemStack stack) {
        HashMap<Integer, Map<Vector2, DataOres>> map = new HashMap<Integer, Map<Vector2, DataOres>>();
        ChunkPos pos = new ChunkPos(new BlockPos((int)player.m_20185_(), (int)player.m_20186_(), (int)player.m_20189_()));
        ChunkPos pos2 = new ChunkPos(pos.f_45578_ - 4, pos.f_45579_ - 4);
        int i = 0;
        for (int x = -4; x < 5; ++x) {
            for (int z = -4; z < 5; ++z) {
                ChunkPos chunkPos = new ChunkPos(pos.f_45578_ + x, pos.f_45579_ + z);
                LevelChunk chunk = player.m_9236_().m_6325_(chunkPos.f_45578_, chunkPos.f_45579_);
                Map<Vector2, DataOres> map1 = ItemVeinSensor.getDataChunk((ChunkAccess)chunk);
                map.put(i, map1);
                ++i;
            }
        }
        return new ItemStackVeinSensor(player, stack, map, new Vector2(pos2.f_45578_ * 16, pos2.f_45579_ * 16));
    }

    @Override
    public void updateField(String name, CustomPacketBuffer buffer, ItemStack stack) {
    }

    @Override
    public void updateEvent(int event, ItemStack stack) {
        CompoundTag nbt = ModUtils.nbt(stack);
        List list1 = Arrays.stream(nbt.m_128465_("list")).boxed().collect(Collectors.toList());
        if (list1.contains(event)) {
            list1.remove((Object)event);
        } else {
            list1.add(event);
        }
        nbt.m_128408_("list", list1);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        CompoundTag nbt = ModUtils.nbt(stack);
        tooltip.add((Component)Component.m_237115_((String)"iu.sensor.info"));
        if (!nbt.m_128461_("type").isEmpty()) {
            String s = nbt.m_128461_("type");
            if (!s.equals("oil") && !s.equals("gas")) {
                tooltip.add((Component)Component.m_237115_((String)"iu.vein_info").m_7220_((Component)Component.m_237115_((String)("iu." + s + ".name"))));
            } else if (!s.equals("gas")) {
                tooltip.add((Component)Component.m_237115_((String)"iu.vein_info").m_7220_((Component)Component.m_237115_((String)"iu.oil_vein")));
            } else {
                tooltip.add((Component)Component.m_237115_((String)"iu.vein_info").m_7220_((Component)Component.m_237115_((String)"iu.fluidgas")));
            }
            int x = nbt.m_128451_("x");
            int z = nbt.m_128451_("z");
            tooltip.add((Component)Component.m_237115_((String)"iu.modulewirelles1").m_130946_(" x: " + x + " z: " + z));
        }
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level world, @Nonnull Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = ModUtils.get(player, hand);
        if (!world.f_46443_) {
            CustomPacketBuffer growingBuffer = new CustomPacketBuffer();
            growingBuffer.writeByte(1);
            growingBuffer.flip();
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)this.getInventory(player, player.m_21120_(hand)), buf -> buf.writeBytes((ByteBuf)growingBuffer));
            return InteractionResultHolder.m_19090_((Object)player.m_21120_(hand));
        }
        return InteractionResultHolder.m_19098_((Object)player.m_21120_(hand));
    }

    @Override
    public String[] properties() {
        return new String[]{"type"};
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public float getItemProperty(ItemStack itemStack, ClientLevel level, LivingEntity entity, int p174679, String property) {
        CompoundTag nbt = ModUtils.nbt(itemStack);
        if (!nbt.m_128461_("type").equals("")) {
            String type = nbt.m_128461_("type");
            return ORE_INDEX_MAP.get(type).intValue();
        }
        return -1.0f;
    }

    static {
        ORE_INDEX_MAP.put("magnetite", 0);
        ORE_INDEX_MAP.put("calaverite", 1);
        ORE_INDEX_MAP.put("galena", 2);
        ORE_INDEX_MAP.put("nickelite", 3);
        ORE_INDEX_MAP.put("pyrite", 4);
        ORE_INDEX_MAP.put("quartzite", 5);
        ORE_INDEX_MAP.put("uranite", 6);
        ORE_INDEX_MAP.put("azurite", 7);
        ORE_INDEX_MAP.put("rhodonite", 8);
        ORE_INDEX_MAP.put("alfildit", 9);
        ORE_INDEX_MAP.put("euxenite", 10);
        ORE_INDEX_MAP.put("smithsonite", 11);
        ORE_INDEX_MAP.put("ilmenite", 12);
        ORE_INDEX_MAP.put("todorokite", 13);
        ORE_INDEX_MAP.put("ferroaugite", 14);
        ORE_INDEX_MAP.put("sheelite", 15);
        ORE_INDEX_MAP.put("oil", 16);
        ORE_INDEX_MAP.put("arsenopyrite", 17);
        ORE_INDEX_MAP.put("braggite", 18);
        ORE_INDEX_MAP.put("wolframite", 19);
        ORE_INDEX_MAP.put("germanite", 20);
        ORE_INDEX_MAP.put("coltan", 21);
        ORE_INDEX_MAP.put("crocoite", 22);
        ORE_INDEX_MAP.put("xenotime", 23);
        ORE_INDEX_MAP.put("iridosmine", 24);
        ORE_INDEX_MAP.put("theoprastite", 25);
        ORE_INDEX_MAP.put("tetrahedrite", 26);
        ORE_INDEX_MAP.put("fergusonite", 27);
        ORE_INDEX_MAP.put("celestine", 28);
        ORE_INDEX_MAP.put("zircon", 29);
        ORE_INDEX_MAP.put("crystal", 30);
        ORE_INDEX_MAP.put("gas", 31);
    }

    public static enum Types implements ISubEnum
    {
        sensor(0);

        private final String name = this.name().toLowerCase(Locale.US);
        private final int ID;

        private Types(int ID) {
            this.ID = ID;
        }

        public static Types getFromID(int ID) {
            return Types.values()[ID % Types.values().length];
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getMainPath() {
            return "sensor";
        }

        @Override
        public int getId() {
            return this.ID;
        }
    }
}

