/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.energy;

import com.denfop.IItemTab;
import com.denfop.IUCore;
import com.denfop.api.tile.IWrenchable;
import com.denfop.audio.EnumSound;
import com.denfop.utils.ModUtils;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeHooks;
import org.jetbrains.annotations.NotNull;

public class ItemToolWrench
extends Item
implements IItemTab {
    String nameItem;

    public ItemToolWrench() {
        super(new Item.Properties().m_41503_(120).m_41499_(0).setNoRepair());
    }

    public static WrenchResult wrenchBlock(Level level, BlockPos pos, Direction side, Player player, boolean remove) {
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        if (!block.m_49966_().m_60795_() && block instanceof IWrenchable) {
            Direction currentFacing;
            IWrenchable wrenchable = (IWrenchable)block;
            Direction newFacing = currentFacing = wrenchable.getFacing(level, pos);
            if (!IUCore.keyboard.isChangeKeyDown(player)) {
                newFacing = player.m_6144_() ? side.m_122424_() : side;
            } else {
                Direction.Axis axis = side.m_122434_();
                if (side.m_122421_() == Direction.AxisDirection.POSITIVE && !player.m_6144_() || side.m_122421_() == Direction.AxisDirection.NEGATIVE && player.m_6144_()) {
                    newFacing = currentFacing.m_175362_(axis);
                } else {
                    for (int i = 0; i < 3; ++i) {
                        newFacing = newFacing.m_175362_(axis);
                    }
                }
            }
            if (newFacing != currentFacing && wrenchable.setFacing(level, pos, newFacing, player)) {
                return WrenchResult.Rotated;
            }
            if (remove && wrenchable.wrenchCanRemove(level, pos, player)) {
                if (!level.f_46443_) {
                    int experience;
                    BlockEntity te = level.m_7702_(pos);
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        experience = ForgeHooks.onBlockBreakEvent((Level)level, (GameType)serverPlayer.f_8941_.m_9290_(), (ServerPlayer)serverPlayer, (BlockPos)pos);
                        if (experience < 0) {
                            return WrenchResult.Nothing;
                        }
                    } else {
                        experience = 0;
                    }
                    block.m_5707_(level, pos, state, player);
                    if (!block.onDestroyedByPlayer(state, level, pos, player, true, level.m_6425_(pos))) {
                        return WrenchResult.Nothing;
                    }
                    block.m_6786_((LevelAccessor)level, pos, state);
                    List<ItemStack> drops = wrenchable.getWrenchDrops(level, pos, state, te, player, RandomSource.m_216327_().m_188503_(100));
                    if (drops != null && !drops.isEmpty()) {
                        for (ItemStack drop : drops) {
                            ModUtils.dropAsEntity(level, pos, drop);
                        }
                    }
                    wrenchable.wrenchBreak(level, pos);
                    if (!player.m_7500_() && experience > 0) {
                        block.m_49805_((ServerLevel)level, pos, experience);
                    }
                }
                return WrenchResult.Removed;
            }
        }
        return WrenchResult.Nothing;
    }

    @NotNull
    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Player player = context.m_43723_();
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Direction side = context.m_43719_();
        InteractionHand hand = context.m_43724_();
        if (!this.canTakeDamage(stack, 1)) {
            return InteractionResult.FAIL;
        }
        WrenchResult result = ItemToolWrench.wrenchBlock(level, pos, side, player, this.canTakeDamage(stack, 10));
        if (result != WrenchResult.Nothing) {
            if (!level.f_46443_) {
                this.damage(stack, result == WrenchResult.Rotated ? 1 : 10, player);
            } else {
                player.m_5496_(EnumSound.wrench.getSoundEvent(), 1.0f, 1.0f);
            }
            return level.f_46443_ ? InteractionResult.PASS : InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Direction side = context.m_43719_();
        InteractionHand hand = context.m_43724_();
        ItemStack stack = ModUtils.get(player, hand);
        if (!this.canTakeDamage(stack, 1)) {
            return InteractionResult.FAIL;
        }
        WrenchResult result = ItemToolWrench.wrenchBlock(level, pos, side, player, this.canTakeDamage(stack, 10));
        if (result != WrenchResult.Nothing) {
            if (!level.f_46443_) {
                this.damage(stack, result == WrenchResult.Rotated ? 1 : 10, player);
            } else {
                player.m_5496_(EnumSound.wrench.getSoundEvent(), 1.0f, 1.0f);
            }
            return level.f_46443_ ? InteractionResult.PASS : InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public boolean canTakeDamage(ItemStack stack, int amount) {
        return true;
    }

    public void damage(ItemStack stack, int amount, Player player) {
        stack.m_41622_(amount, (LivingEntity)player, p -> p.m_21166_(EquipmentSlot.MAINHAND));
    }

    protected String m_41467_() {
        if (this.nameItem == null) {
            StringBuilder pathBuilder = new StringBuilder(Util.m_137492_((String)"iu", (ResourceLocation)BuiltInRegistries.f_257033_.m_7981_((Object)this)));
            String targetString = "industrialupgrade.";
            String replacement = "";
            if (replacement != null) {
                int index = pathBuilder.indexOf(targetString);
                while (index != -1) {
                    pathBuilder.replace(index, index + targetString.length(), replacement);
                    index = pathBuilder.indexOf(targetString, index + replacement.length());
                }
            }
            this.nameItem = pathBuilder.toString();
        }
        return this.nameItem;
    }

    @Override
    public CreativeModeTab getItemCategory() {
        return IUCore.EnergyTab;
    }

    private static enum WrenchResult {
        Rotated,
        Removed,
        Nothing;

    }
}

