/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.network;

import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileEntityBlock;
import com.denfop.world.IWorldTickCallback;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.loading.FMLEnvironment;

public class WorldData {
    public static Map<ResourceKey<Level>, WorldData> idxClient = FMLEnvironment.dist.isClient() ? new HashMap() : null;
    public static Map<ResourceKey<Level>, WorldData> idxServer = new HashMap<ResourceKey<Level>, WorldData>();
    public final Queue<IWorldTickCallback> singleUpdates = new LinkedList<IWorldTickCallback>();
    public final List<TileEntityBlock> listUpdateTile = new LinkedList<TileEntityBlock>();
    public final Map<TileEntityBlock, List<CustomPacketBuffer>> mapUpdateField = new HashMap<TileEntityBlock, List<CustomPacketBuffer>>();
    public final Map<TileEntityBlock, Map<Player, CustomPacketBuffer>> mapUpdateContainer = new HashMap<TileEntityBlock, Map<Player, CustomPacketBuffer>>();
    public final Map<BlockPos, TileEntityBlock> mapUpdateOvertimeField = new HashMap<BlockPos, TileEntityBlock>();
    private final Level world;

    public WorldData(Level world) {
        this.world = world;
    }

    public static WorldData get(Level world) {
        return WorldData.get(world, true);
    }

    public static WorldData get(Level world, boolean load) {
        if (world == null) {
            return null;
        }
        Map<ResourceKey<Level>, WorldData> index = WorldData.getIndex(!world.f_46443_);
        WorldData ret = index.get(world.m_46472_());
        if (ret == null && load) {
            ret = new WorldData(world);
            WorldData prev = index.putIfAbsent((ResourceKey<Level>)world.m_46472_(), ret);
            if (prev != null) {
                ret = prev;
            }
        }
        return ret;
    }

    public static void onWorldUnload(Level world) {
        WorldData.getIndex(!world.f_46443_).remove(world.m_46472_());
    }

    private static Map<ResourceKey<Level>, WorldData> getIndex(boolean simulating) {
        return simulating ? idxServer : idxClient;
    }

    public Level getWorld() {
        return this.world;
    }
}

