/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.recipe;

import com.denfop.DataBlock;
import com.denfop.DataBlockEntity;
import com.denfop.DataItem;
import com.denfop.DataSimpleBlock;
import com.denfop.DataSimpleItem;
import com.denfop.api.Recipes;
import com.denfop.api.crafting.BaseRecipe;
import com.denfop.api.crafting.BaseShapelessRecipe;
import com.denfop.api.crafting.PartRecipe;
import com.denfop.api.crafting.RecipeGrid;
import com.denfop.recipe.IInputItemStack;
import com.denfop.recipes.ItemStackHelper;
import com.denfop.utils.ModUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class CraftingManager {
    public BaseRecipe addRecipe(DataSimpleItem<?, ?> output, Object ... input) {
        return this.addRecipe(output.getItemStack(), input);
    }

    public BaseRecipe addRecipe(Item output, Object ... input) {
        return this.addRecipe(new ItemStack((ItemLike)output), input);
    }

    public BaseRecipe addRecipe(String output, Object ... input) {
        return this.addRecipe(Recipes.inputFactory.getInput(output).getInputs().get(0), input);
    }

    public BaseRecipe addRecipe(String output, int amount, Object ... input) {
        return this.addRecipe(ModUtils.setSize(Recipes.inputFactory.getInput(output).getInputs().get(0), amount), input);
    }

    public BaseRecipe addRecipe(ItemStack output, Object ... input) {
        int i;
        List<Object> objects = Arrays.asList(input);
        ArrayList<String> list = new ArrayList<String>();
        ArrayList<PartRecipe> objectMap = new ArrayList<PartRecipe>();
        for (i = 0; i < 3 && objects.get(i) instanceof String; ++i) {
            list.add((String)objects.get(i));
        }
        RecipeGrid grid = new RecipeGrid(list);
        while (i < objects.size()) {
            Character character = (Character)objects.get(i);
            if (grid.getCharactersList().contains(character)) {
                Object object = objects.get(i + 1);
                IInputItemStack recipeInput = this.getRecipeInput(object);
                objectMap.add(new PartRecipe(character.toString(), recipeInput));
            }
            i += 2;
        }
        return new BaseRecipe(output, grid, objectMap);
    }

    public BaseShapelessRecipe addShapelessRecipe(ItemStack output, Object ... input) {
        ArrayList<IInputItemStack> recipeInputList = new ArrayList<IInputItemStack>();
        for (Object object : input) {
            IInputItemStack recipeInput = this.getRecipeInput(object);
            recipeInputList.add(recipeInput);
        }
        return new BaseShapelessRecipe(output, recipeInputList);
    }

    public BaseRecipe addShapelessRecipe(String output, int amount, Object ... input) {
        return this.addRecipe(ModUtils.setSize(Recipes.inputFactory.getInput(output).getInputs().get(0), amount), input);
    }

    public BaseShapelessRecipe addShapelessRecipe(Item output, Object ... input) {
        return this.addShapelessRecipe(new ItemStack((ItemLike)output), input);
    }

    public BaseShapelessRecipe addShapelessRecipe(DataSimpleItem<?, ?> output, Object ... input) {
        return this.addShapelessRecipe(output.getItemStack(), input);
    }

    public BaseShapelessRecipe addShapelessRecipe(Block output, Object ... input) {
        return this.addShapelessRecipe(new ItemStack((ItemLike)output), input);
    }

    private IInputItemStack getRecipeInput(Object o) {
        if (o == null) {
            throw new NullPointerException("Null recipe input object.");
        }
        if (o instanceof IInputItemStack) {
            return (IInputItemStack)o;
        }
        if (o instanceof DataSimpleItem) {
            return Recipes.inputFactory.getInput(new ItemStack(((DataSimpleItem)o).getItem()));
        }
        if (o instanceof DataSimpleBlock) {
            return Recipes.inputFactory.getInput(new ItemStack(((DataSimpleBlock)o).getItem()));
        }
        if (o instanceof DataBlock) {
            return Recipes.inputFactory.getInput(new ItemStack(((DataBlock)o).getItem()));
        }
        if (o instanceof DataItem) {
            return Recipes.inputFactory.getInput(ItemStackHelper.fromData((DataItem)o));
        }
        if (o instanceof DataBlockEntity) {
            return Recipes.inputFactory.getInput(ItemStackHelper.fromData((DataBlockEntity)o));
        }
        if (o instanceof ItemStack) {
            return Recipes.inputFactory.getInput((ItemStack)o);
        }
        if (o instanceof Block) {
            return Recipes.inputFactory.getInput(new ItemStack((ItemLike)((Block)o)));
        }
        if (o instanceof Item) {
            return Recipes.inputFactory.getInput(new ItemStack((ItemLike)((Item)o)));
        }
        if (o instanceof String) {
            return Recipes.inputFactory.getInput((String)o);
        }
        if (o instanceof Fluid) {
            return Recipes.inputFactory.getInput((Fluid)o);
        }
        if (o instanceof FluidStack) {
            return Recipes.inputFactory.getInput(((FluidStack)o).getFluid(), ((FluidStack)o).getAmount());
        }
        throw new RuntimeException();
    }
}

