/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.recipes;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.blocks.BlockClassicOre;
import com.denfop.recipe.IInputItemStack;
import com.denfop.utils.ModUtils;
import com.denfop.world.WorldBaseGen;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public final class ScrapboxRecipeManager {
    public static ScrapboxRecipeManager instance;
    public final List<Drop> drops = new LinkedList<Drop>();

    public ScrapboxRecipeManager() {
        instance = this;
        this.addBuiltinDrops();
    }

    public boolean addRecipe(IInputItemStack input, Collection<ItemStack> output, CompoundTag metadata, boolean replace) {
        if (!input.matches(IUItem.scrapBox)) {
            throw new IllegalArgumentException("currently only scrap boxes are supported");
        }
        if (metadata != null && metadata.m_128441_("weight")) {
            if (output.size() != 1) {
                throw new IllegalArgumentException("currently only a single drop stack is supported");
            }
            float weight = metadata.m_128457_("weight");
            if (!(weight <= 0.0f || Float.isInfinite(weight) || Float.isNaN(weight))) {
                this.addDrop(output.iterator().next(), weight);
                return true;
            }
            throw new IllegalArgumentException("invalid weight");
        }
        throw new IllegalArgumentException("no weight metadata");
    }

    public boolean addRecipe(IInputItemStack input, CompoundTag metadata, boolean replace, ItemStack ... outputs) {
        return this.addRecipe(input, Arrays.asList(outputs), metadata, replace);
    }

    public ItemStack apply(ItemStack input) {
        if (!ModUtils.isEmpty(input) && input.m_150930_(IUItem.scrapBox.m_41720_())) {
            if (this.drops.isEmpty()) {
                return ItemStack.f_41583_;
            }
            float chance = IUCore.random.nextFloat() * Drop.topChance;
            int low = 0;
            int high = this.drops.size() - 1;
            while (low < high) {
                int mid = (high + low) / 2;
                if (chance < this.drops.get((int)mid).upperChanceBound) {
                    high = mid;
                    continue;
                }
                low = mid + 1;
            }
            return this.drops.get((int)low).item.m_41777_();
        }
        return ItemStack.f_41583_;
    }

    public ItemStack getRandomDrop() {
        if (this.drops.isEmpty()) {
            return ItemStack.f_41583_;
        }
        float chance = WorldBaseGen.random.nextFloat() * Drop.topChance;
        int low = 0;
        int high = this.drops.size() - 1;
        while (low < high) {
            int mid = (high + low) / 2;
            if (chance < this.drops.get((int)mid).upperChanceBound) {
                high = mid;
                continue;
            }
            low = mid + 1;
        }
        return this.drops.get((int)low).item;
    }

    public boolean isIterable() {
        return false;
    }

    public void addDrop(ItemStack drop, float rawChance) {
        this.drops.add(new Drop(drop, rawChance));
    }

    public ItemStack getDrop(ItemStack input) {
        return this.apply(input);
    }

    public Map<ItemStack, Float> getDrops() {
        HashMap<ItemStack, Float> ret = new HashMap<ItemStack, Float>(this.drops.size());
        for (Drop drop : this.drops) {
            ret.put(drop.item, Float.valueOf(drop.originalChance / Drop.topChance));
        }
        return ret;
    }

    private void addBuiltinDrops() {
        this.addDrop(Items.f_42424_, 5.01f);
        this.addDrop(Blocks.f_50493_, 5.0f);
        this.addDrop(Items.f_42398_, 4.0f);
        this.addDrop(Blocks.f_50034_, 3.0f);
        this.addDrop(Blocks.f_49994_, 3.0f);
        this.addDrop(Blocks.f_50134_, 2.0f);
        this.addDrop(Items.f_42583_, 2.0f);
        this.addDrop(Items.f_42410_, 1.5f);
        this.addDrop(Items.f_42406_, 1.5f);
        this.addDrop(Items.f_42420_, 1.0f);
        this.addDrop(Items.f_42421_, 1.0f);
        this.addDrop(Items.f_42422_, 1.0f);
        this.addDrop(Blocks.f_50135_, 1.0f);
        this.addDrop(Blocks.f_50095_, 1.0f);
        this.addDrop(Items.f_42454_, 1.0f);
        this.addDrop(Items.f_42402_, 1.0f);
        this.addDrop(Items.f_42500_, 1.0f);
        this.addDrop(Items.f_42486_, 0.9f);
        this.addDrop(Items.f_42580_, 0.9f);
        this.addDrop(Blocks.f_50133_, 0.9f);
        this.addDrop(Items.f_42582_, 0.9f);
        this.addDrop(Items.f_42449_, 0.01f);
        this.addDrop(Items.f_42451_, 0.9f);
        this.addDrop(IUItem.rubber, 0.8f);
        this.addDrop(Items.f_42525_, 0.8f);
        this.addDrop(IUItem.coalDust, 0.8f);
        this.addDrop(IUItem.copperDust, 0.8f);
        this.addDrop(IUItem.tinDust, 0.8f);
        this.addDrop(IUItem.ironDust, 0.7f);
        this.addDrop(IUItem.goldDust, 0.7f);
        this.addDrop(Items.f_42518_, 0.6f);
        this.addDrop(Blocks.f_49996_, 0.5f);
        this.addDrop(Items.f_42476_, 0.01f);
        this.addDrop(Blocks.f_49995_, 0.5f);
        this.addDrop(Items.f_42502_, 0.5f);
        this.addDrop(Items.f_42415_, 0.1f);
        this.addDrop(Items.f_42616_, 0.05f);
        this.addDrop(Items.f_42584_, 0.08f);
        this.addDrop(Items.f_42585_, 0.04f);
        this.addDrop(Items.f_42521_, 0.8f);
        this.addDrop(Blocks.f_152505_, 0.7f);
        this.addDrop(IUItem.classic_ore.getItemStack(BlockClassicOre.Type.tin), 0.7f);
    }

    private void addDrop(Block block, float rawChance) {
        this.addDrop(new ItemStack((ItemLike)block), rawChance);
    }

    private void addDrop(Item item, float rawChance) {
        this.addDrop(new ItemStack((ItemLike)item), rawChance);
    }

    private static class Drop {
        static float topChance;
        final ItemStack item;
        final float originalChance;
        final float upperChanceBound;

        Drop(ItemStack item, float chance) {
            this.item = item;
            this.originalChance = chance;
            this.upperChanceBound = topChance += chance;
        }
    }
}

