/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.render.streak;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.gui.GuiCore;
import com.denfop.render.streak.PlayerStreakInfo;
import com.denfop.render.streak.RGB;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import org.joml.Matrix4f;

public class EventSpectralSuitEffect {
    public static final ResourceLocation texture = new ResourceLocation("industrialupgrade:textures/item/effect.png");
    private static final Map<String, ArrayList<StreakLocation>> playerLoc = new HashMap<String, ArrayList<StreakLocation>>();
    public final int[] red = new int[]{255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 240, 222, 186, 150, 124, 96, 67, 40, 27, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 18, 34, 56, 78, 102, 121, 145, 176, 201, 218, 230, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255};
    public final int[] green = new int[]{0, 24, 36, 54, 72, 96, 120, 145, 172, 192, 216, 234, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 234, 214, 195, 176, 153, 137, 112, 94, 86, 55, 31, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public final int[] blue = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 18, 32, 45, 68, 78, 103, 118, 138, 151, 178, 205, 221, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 240, 228, 208, 186, 165, 149, 132, 115, 102, 97, 76, 53, 32, 15, 0};

    public static ArrayList<StreakLocation> getPlayerStreakLocationInfo(Player player) {
        ArrayList loc = playerLoc.computeIfAbsent(player.m_7755_().getString(), k -> new ArrayList());
        if (loc.size() < 20) {
            for (int i = 0; i < 20 - loc.size(); ++i) {
                loc.add(0, new StreakLocation(player));
            }
        } else if (loc.size() > 20) {
            loc.remove(0);
        }
        return loc;
    }

    public static float clamp(float num, float min, float max) {
        if (num < min) {
            return min;
        }
        return Math.min(num, max);
    }

    @SubscribeEvent
    public void onRenderPlayer(RenderPlayerEvent.Post event) {
        this.render(true, event.getPartialTick(), event.getPoseStack());
    }

    @SubscribeEvent
    public void onRenderWorldLast(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            this.render(false, event.getPartialTick(), event.getPoseStack());
        }
    }

    public void render(boolean ignore, float partialTicks, PoseStack poseStack) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        PlayerStreakInfo playerStreak1 = IUCore.mapStreakInfo.get(player.m_7755_().getString());
        boolean needRender = true;
        if (playerStreak1 != null) {
            needRender = this.isRenderStreak((Player)player);
        }
        if (needRender) {
            for (Player targetPlayer : mc.f_91073_.m_6907_()) {
                if ((!this.isRenderStreak(targetPlayer) || targetPlayer.m_7755_().getString().equals(player.m_7755_().getString())) && !ignore) continue;
                ArrayList<StreakLocation> loc = EventSpectralSuitEffect.getPlayerStreakLocationInfo(targetPlayer);
                poseStack.m_85836_();
                float startGrad = 5.0f - partialTicks;
                float endGrad = 20.0f - partialTicks;
                for (int i = loc.size() - 2; i >= 0; --i) {
                    double grad1;
                    float startAlpha;
                    int start = i;
                    StreakLocation infoStart = loc.get(i);
                    float f = (float)i < endGrad ? EventSpectralSuitEffect.clamp(0.8f * (float)i / endGrad, 0.0f, 0.8f) : (startAlpha = (float)i > (float)(loc.size() - 2) - startGrad ? EventSpectralSuitEffect.clamp(0.8f * (float)(loc.size() - 2 - i) / startGrad, 0.0f, 0.8f) : 0.8f);
                    if (mc.f_91073_.m_46467_() - infoStart.lastTick > 40L) break;
                    StreakLocation infoEnd = null;
                    double grad = 500.0;
                    --i;
                    while (i >= 0) {
                        StreakLocation infoPoint = loc.get(i);
                        if (infoStart.isSprinting && loc.size() - 2 - i < 6) {
                            infoEnd = infoPoint;
                            --start;
                            --i;
                            break;
                        }
                        if (infoPoint.hasSameCoords(infoStart)) {
                            --start;
                            --i;
                            continue;
                        }
                        grad1 = infoPoint.posZ - infoStart.posZ / (infoPoint.posX - infoStart.posX);
                        if (grad == grad1 && infoPoint.posY == infoStart.posY) {
                            infoEnd = infoPoint;
                            --start;
                            --i;
                            continue;
                        }
                        if (grad != 500.0) break;
                        grad = grad1;
                        infoEnd = infoPoint;
                        --i;
                    }
                    if (infoEnd == null) continue;
                    float endAlpha = (float)(i += 2) < endGrad ? EventSpectralSuitEffect.clamp(0.8f * (float)(i - 1) / endGrad, 0.0f, 0.8f) : ((float)i > (float)(loc.size() - 1) - startGrad ? EventSpectralSuitEffect.clamp(0.8f * (float)(loc.size() - 1 - i) / startGrad, 0.0f, 0.8f) : 0.8f);
                    grad1 = infoStart.posX - mc.f_91063_.m_109153_().m_90583_().f_82479_;
                    double posY = infoStart.posY - mc.f_91063_.m_109153_().m_90583_().f_82480_;
                    double posZ = infoStart.posZ - mc.f_91063_.m_109153_().m_90583_().f_82481_;
                    double nextPosX = infoEnd.posX - mc.f_91063_.m_109153_().m_90583_().f_82479_;
                    double nextPosY = infoEnd.posY - mc.f_91063_.m_109153_().m_90583_().f_82480_;
                    double nextPosZ = infoEnd.posZ - mc.f_91063_.m_109153_().m_90583_().f_82481_;
                    float deltaX = (float)(nextPosX - grad1);
                    float deltaZ = (float)(nextPosZ - posZ);
                    poseStack.m_85836_();
                    poseStack.m_85837_(grad1, posY, posZ);
                    RenderSystem.disableBlend();
                    RenderSystem.defaultBlendFunc();
                    RenderSystem.disableCull();
                    RenderSystem.enableDepthTest();
                    RenderSystem.setShader(GameRenderer::m_172820_);
                    PlayerStreakInfo playerStreak = IUCore.mapStreakInfo.get(targetPlayer.m_7755_().getString());
                    if (playerStreak == null) {
                        playerStreak = new PlayerStreakInfo(new RGB(0, 0, 0), false);
                        IUCore.mapStreakInfo.put(targetPlayer.m_7755_().getString(), playerStreak);
                    }
                    double red = (double)playerStreak.getRgb().getRed() / 255.0;
                    double green = (double)playerStreak.getRgb().getGreen() / 255.0;
                    double blue = (double)playerStreak.getRgb().getBlue() / 255.0;
                    boolean rgb = playerStreak.isRainbow();
                    if (rgb) {
                        long worldTime = mc.f_91073_.m_46467_();
                        red = (float)this.red[(int)(worldTime % (long)this.red.length)] / 255.0f;
                        green = (float)this.green[(int)(worldTime % (long)this.green.length)] / 255.0f;
                        blue = (float)this.blue[(int)(worldTime % (long)this.red.length)] / 255.0f;
                    }
                    Color color = new Color((float)red, (float)green, (float)blue, startAlpha);
                    GuiCore.bindTexture(texture);
                    BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
                    buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
                    Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
                    RenderSystem.setShaderColor((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)1.0f);
                    buffer.m_252986_(matrix4f, 0.0f, 0.0f, 0.0f).m_7421_((float)infoStart.startU, 1.0f).m_6122_(color.getRed(), color.getGreen(), color.getBlue(), 255).m_5752_();
                    buffer.m_252986_(matrix4f, 0.0f, 0.0f + infoStart.height, 0.0f).m_7421_((float)infoStart.startU, 0.0f).m_6122_(color.getRed(), color.getGreen(), color.getBlue(), 255).m_5752_();
                    double endTex = infoEnd.startU - (double)start + (double)i;
                    if (endTex > infoStart.startU) {
                        endTex -= 1.0;
                    }
                    double distX = infoStart.posX - infoEnd.posX;
                    double distZ = infoStart.posZ - infoEnd.posZ;
                    float correctedDeltaX = deltaX > 0.0f ? deltaX : 0.0f;
                    float correctedDeltaZ = deltaZ > 0.0f ? deltaZ : 0.0f;
                    for (double scales = Math.sqrt(distX * distX + distZ * distZ) / (double)infoStart.height; scales > 1.0; scales -= 1.0) {
                        endTex += 1.0;
                    }
                    buffer.m_252986_(matrix4f, (float)Math.abs(nextPosX - grad1), (float)(nextPosY - posY + (double)infoEnd.height), (float)Math.abs(nextPosZ - posZ)).m_7421_((float)endTex, 0.0f).m_6122_(color.getRed(), color.getGreen(), color.getBlue(), 255).m_5752_();
                    buffer.m_252986_(matrix4f, (float)Math.abs(nextPosX - grad1), (float)(nextPosY - posY), (float)Math.abs(nextPosZ - posZ)).m_7421_((float)endTex, 1.0f).m_6122_(color.getRed(), color.getGreen(), color.getBlue(), 255).m_5752_();
                    BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
                    RenderSystem.enableBlend();
                    RenderSystem.enableCull();
                    RenderSystem.disableDepthTest();
                    poseStack.m_85849_();
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
                poseStack.m_85849_();
            }
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player;
        if (event.side == LogicalSide.CLIENT && event.phase == TickEvent.Phase.END && this.isRenderStreak(player = event.player)) {
            ArrayList<StreakLocation> loc = EventSpectralSuitEffect.getPlayerStreakLocationInfo(player);
            StreakLocation oldest = loc.get(0);
            loc.remove(0);
            loc.add(oldest);
            oldest.update(player);
            StreakLocation newest = loc.get(loc.size() - 2);
            double distX = newest.posX - oldest.posX;
            double distZ = newest.posZ - oldest.posZ;
            newest.startU += Math.sqrt(distX * distX + distZ * distZ) / (double)newest.height;
            while (oldest.startU > 1.0) {
                oldest.startU -= 1.0;
            }
        }
    }

    private boolean isRenderStreak(Player player) {
        NonNullList armors = player.m_150109_().f_35975_;
        return Minecraft.m_91087_().f_91080_ == null && ((ItemStack)armors.get(2)).m_41720_() == IUItem.spectral_chestplate.getItem();
    }

    public static class StreakLocation {
        public double posX;
        public double posY;
        public double posZ;
        public float renderYawOffset;
        public float rotationYawHead;
        public float rotationPitch;
        public boolean isSprinting;
        public long lastTick;
        public float height;
        public double startU;

        public StreakLocation(Player player) {
            this.update(player);
        }

        public void update(Player player) {
            this.posX = player.m_20185_();
            this.posY = player.m_20191_().f_82289_;
            this.posZ = player.m_20189_();
            this.renderYawOffset = player.f_20883_;
            this.rotationYawHead = player.m_5675_(Minecraft.m_91087_().getPartialTick());
            this.rotationPitch = player.m_5686_(Minecraft.m_91087_().getPartialTick());
            this.isSprinting = player.m_20142_();
            this.lastTick = player.m_9236_().m_46467_();
            this.height = player.m_20206_() * 2.0f;
        }

        public boolean hasSameCoords(StreakLocation loc) {
            return loc.posX == this.posX && loc.posY == this.posY && loc.posZ == this.posZ && loc.height == this.height;
        }
    }
}

