/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseFluidMachineRecipe;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.FluidHandlerRecipe;
import com.denfop.api.recipe.IHasRecipe;
import com.denfop.api.recipe.IInputFluid;
import com.denfop.api.recipe.IUpdateTick;
import com.denfop.api.recipe.Input;
import com.denfop.api.recipe.InputFluid;
import com.denfop.api.recipe.InvSlotRecipes;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.mechanism.BlockPrimalFluidIntegrator;
import com.denfop.componets.Fluids;
import com.denfop.invslot.InvSlot;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.recipe.IInputHandler;
import com.denfop.recipe.IInputItemStack;
import com.denfop.tiles.base.TileElectricMachine;
import com.denfop.utils.FluidHandlerFix;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class TileEntityPrimalFluidIntegrator
extends TileElectricMachine
implements IUpgradableBlock,
IUpdateTick,
IUpdatableTileEvent,
IHasRecipe {
    public final InvSlotRecipes inputSlotA;
    public final Fluids.InternalFluidTank fluidTank1;
    public final Fluids.InternalFluidTank fluidTank2;
    public final FluidHandlerRecipe fluid_handler;
    public final int defaultOperationLength;
    private final Fluids fluids;
    public MachineRecipe output;
    public double energyConsume;
    public int operationLength;
    public int operationsPerTick;
    public double guiProgress;
    protected short progress;
    private int prevAmount;
    private int prevAmount1;

    public TileEntityPrimalFluidIntegrator(BlockPos pos, BlockState state) {
        super(0.0, 0, 1, BlockPrimalFluidIntegrator.primal_fluid_integrator, pos, state);
        Recipes.recipes.addInitRecipes(this);
        this.progress = 0;
        this.operationLength = 200;
        this.defaultOperationLength = 200;
        this.fluids = this.addComponent(new Fluids(this));
        this.fluidTank1 = this.fluids.addTankInsert("fluidTank1", 1000);
        this.fluidTank2 = this.fluids.addTank("fluidTank2", 1000, InvSlot.TypeItemSlot.OUTPUT);
        this.inputSlotA = new InvSlotRecipes(this, "primal_fluid_integrator", this, this.fluidTank1){

            @Override
            public boolean accepts(ItemStack itemStack, int index) {
                if (index == 4) {
                    return super.accepts(itemStack, 0);
                }
                return false;
            }
        };
        this.inputSlotA.setStackSizeLimit(1);
        this.fluid_handler = new FluidHandlerRecipe("primal_fluid_integrator", this.fluids);
        this.fluidTank1.setAcceptedFluids(Fluids.fluidPredicate(this.fluid_handler.getFluids(0)));
        this.fluidTank2.setAcceptedFluids(Fluids.fluidPredicate(this.fluid_handler.getOutputFluids(0)));
    }

    public static void addRecipe(IInputItemStack container, ItemStack output, FluidStack fluidStack, FluidStack outputfluidStack) {
        IInputHandler input = Recipes.inputFactory;
        Recipes.recipes.addRecipe("primal_fluid_integrator", new BaseMachineRecipe(new Input(fluidStack, input.getInput(container)), new RecipeOutput(null, output)));
        Recipes.recipes.getRecipeFluid().addRecipe("primal_fluid_integrator", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(container, fluidStack), Collections.singletonList(outputfluidStack)));
    }

    public static void addRecipe(ItemStack container, ItemStack output, FluidStack fluidStack, FluidStack outputfluidStack) {
        IInputHandler input = Recipes.inputFactory;
        Recipes.recipes.addRecipe("primal_fluid_integrator", new BaseMachineRecipe(new Input(fluidStack, input.getInput(container)), new RecipeOutput(null, output)));
        Recipes.recipes.getRecipeFluid().addRecipe("primal_fluid_integrator", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(container, fluidStack), Collections.singletonList(outputfluidStack)));
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        for (int i = 1; i < 6; ++i) {
            tooltip.add(Localization.translate("fluid_integrator.info" + i));
        }
    }

    @Override
    public List<AABB> getAabbs(boolean forCollision) {
        return Collections.singletonList(new AABB(-0.2, 0.0, -0.2, 1.2, 1.0, 1.2));
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            FluidTank fluidTank2;
            FluidTank fluidTank1 = (FluidTank)DecoderHandler.decode(customPacketBuffer);
            if (fluidTank1 != null) {
                this.fluidTank1.readFromNBT(fluidTank1.writeToNBT(new CompoundTag()));
            }
            if ((fluidTank2 = (FluidTank)DecoderHandler.decode(customPacketBuffer)) != null) {
                this.fluidTank2.readFromNBT(fluidTank2.writeToNBT(new CompoundTag()));
            }
            try {
                this.inputSlotA.readFromNbt(((InvSlot)DecoderHandler.decode(customPacketBuffer)).writeToNbt(new CompoundTag()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            try {
                this.outputSlot.readFromNbt(((InvSlot)DecoderHandler.decode(customPacketBuffer)).writeToNbt(new CompoundTag()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        super.updateField(name, is);
        if (name.equals("fluidtank")) {
            try {
                FluidTank fluidTank1 = (FluidTank)DecoderHandler.decode(is);
                if (fluidTank1 != null) {
                    this.fluidTank1.readFromNBT(fluidTank1.writeToNBT(new CompoundTag()));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("guiProgress")) {
            try {
                this.guiProgress = (Double)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("fluidtank1")) {
            try {
                FluidTank fluidTank2 = (FluidTank)DecoderHandler.decode(is);
                if (fluidTank2 != null) {
                    this.fluidTank2.readFromNBT(fluidTank2.writeToNBT(new CompoundTag()));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("fluidtank_empty")) {
            this.fluidTank1.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE);
        }
        if (name.equals("fluidtank1_empty")) {
            this.fluidTank2.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE);
        }
        if (name.equals("slot")) {
            try {
                this.inputSlotA.readFromNbt(((InvSlot)DecoderHandler.decode(is)).writeToNbt(new CompoundTag()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("slot1")) {
            try {
                this.outputSlot.readFromNbt(((InvSlot)DecoderHandler.decode(is)).writeToNbt(new CompoundTag()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("slot3")) {
            this.inputSlotA.set(0, ItemStack.f_41583_);
        }
        if (name.equals("slot2")) {
            this.outputSlot.set(0, ItemStack.f_41583_);
        }
    }

    @Override
    public boolean onActivated(Player player, InteractionHand hand, Direction side, Vec3 vec3) {
        if (!this.getWorld().f_46443_ && FluidHandlerFix.getFluidHandler(player.m_21120_(hand)) != null) {
            return ModUtils.interactWithFluidHandler(player, hand, (IFluidHandler)this.fluids.getCapability(ForgeCapabilities.FLUID_HANDLER, side));
        }
        ItemStack stack = player.m_21120_(hand);
        if (!stack.m_41619_()) {
            if (this.inputSlotA.get(0).m_41619_() && this.inputSlotA.accepts(stack, 4)) {
                ItemStack stack1 = stack.m_41777_();
                stack1.m_41764_(1);
                this.inputSlotA.set(0, stack1);
                stack.m_41774_(1);
                if (!this.f_58857_.f_46443_) {
                    new PacketUpdateFieldTile(this, "slot", this.inputSlotA);
                }
                return true;
            }
        } else {
            if (!this.outputSlot.isEmpty()) {
                if (!this.f_58857_.f_46443_) {
                    ModUtils.dropAsEntity(this.f_58857_, this.pos, this.outputSlot.get(0));
                }
                this.outputSlot.set(0, ItemStack.f_41583_);
                if (!this.f_58857_.f_46443_) {
                    new PacketUpdateFieldTile(this, "slot2", false);
                }
                return true;
            }
            if (!this.inputSlotA.isEmpty()) {
                if (!this.f_58857_.f_46443_) {
                    ModUtils.dropAsEntity(this.f_58857_, this.pos, this.inputSlotA.get(0));
                }
                this.inputSlotA.set(0, ItemStack.f_41583_);
                this.output = null;
                if (!this.f_58857_.f_46443_) {
                    new PacketUpdateFieldTile(this, "slot3", false);
                }
                return true;
            }
        }
        return super.onActivated(player, hand, side, vec3);
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer customPacketBuffer = super.writePacket();
        try {
            EncoderHandler.encode(customPacketBuffer, (Object)this.fluidTank1);
            EncoderHandler.encode(customPacketBuffer, (Object)this.fluidTank2);
            EncoderHandler.encode(customPacketBuffer, this.inputSlotA);
            EncoderHandler.encode(customPacketBuffer, this.outputSlot);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return customPacketBuffer;
    }

    @Override
    public void init() {
        TileEntityPrimalFluidIntegrator.addRecipe(new ItemStack((ItemLike)IUItem.iuingot.getStack(15), 1), new ItemStack((ItemLike)IUItem.iudust.getStack(42), 1), new FluidStack((Fluid)FluidName.fluiddibromopropane.getInstance().get(), 200), new FluidStack((Fluid)FluidName.fluidpropylene.getInstance().get(), 200));
        TileEntityPrimalFluidIntegrator.addRecipe(new ItemStack((ItemLike)IUItem.crafting_elements.getStack(482), 1), new ItemStack((ItemLike)IUItem.iudust.getStack(43), 1), new FluidStack((Fluid)net.minecraft.world.level.material.Fluids.f_76193_, 200), new FluidStack((Fluid)FluidName.fluidacetylene.getInstance().get(), 200));
        TileEntityPrimalFluidIntegrator.addRecipe(new ItemStack((ItemLike)Items.f_151052_, 1), new ItemStack((ItemLike)IUItem.smalldust.getStack(20), 3), new FluidStack((Fluid)FluidName.fluidsulfuricacid.getInstance().get(), 200), new FluidStack((Fluid)FluidName.fluidcoppersulfate.getInstance().get(), 200));
        TileEntityPrimalFluidIntegrator.addRecipe(new ItemStack((ItemLike)IUItem.crafting_elements.getStack(489), 1), new ItemStack((ItemLike)IUItem.crafting_elements.getStack(487), 1), new FluidStack((Fluid)FluidName.fluidcoppersulfate.getInstance().get(), 500), new FluidStack((Fluid)FluidName.fluidwastesulfuricacid.getInstance().get(), 500));
        TileEntityPrimalFluidIntegrator.addRecipe(new ItemStack((ItemLike)IUItem.heavyore.getItemStack(4), 1), new ItemStack((ItemLike)IUItem.smalldust.getStack(22), 1), new FluidStack((Fluid)net.minecraft.world.level.material.Fluids.f_76193_, 1000), new FluidStack((Fluid)FluidName.fluidsulfuroxide.getInstance().get(), 200));
        TileEntityPrimalFluidIntegrator.addRecipe(new ItemStack((ItemLike)IUItem.crafting_elements.getStack(492), 1), new ItemStack((ItemLike)IUItem.crafting_elements.getStack(493), 1), new FluidStack((Fluid)net.minecraft.world.level.material.Fluids.f_76193_, 500), new FluidStack((Fluid)FluidName.fluidhyd.getInstance().get(), 50));
        TileEntityPrimalFluidIntegrator.addRecipe(Recipes.inputFactory.getInput("forge:dusts/coal"), new ItemStack((ItemLike)IUItem.crafting_elements.getStack(498), 1), new FluidStack((Fluid)FluidName.fluidhyd.getInstance().get(), 200), new FluidStack((Fluid)net.minecraft.world.level.material.Fluids.f_76193_, 100));
        TileEntityPrimalFluidIntegrator.addRecipe(new ItemStack((ItemLike)Blocks.f_50493_), new ItemStack((ItemLike)Blocks.f_50195_), new FluidStack((Fluid)FluidName.fluidhoney.getInstance().get(), 1000), new FluidStack((Fluid)FluidName.fluidoxy.getInstance().get(), 75));
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.fluidIntegrator.getBlock();
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockPrimalFluidIntegrator.primal_fluid_integrator;
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.m_58904_().f_46443_) {
            this.inputSlotA.load();
            this.fluid_handler.load(this.inputSlotA.get(0));
            this.getOutput();
            new PacketUpdateFieldTile(this, "slot", this.inputSlotA);
            new PacketUpdateFieldTile(this, "slot1", this.outputSlot);
        }
    }

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.progress = nbttagcompound.m_128448_("progress");
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.m_128376_("progress", this.progress);
        return nbttagcompound;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.guiProgress = (Double)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.guiProgress);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public MachineRecipe getRecipeOutput() {
        return this.output;
    }

    @Override
    public void setRecipeOutput(MachineRecipe output) {
        this.output = output;
        this.fluid_handler.setOutput(null);
    }

    public MachineRecipe getOutput() {
        this.output = this.inputSlotA.process();
        this.fluid_handler.setOutput(null);
        return this.output;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.fluid_handler.output() == null && this.output != null && this.fluidTank1.getFluidAmount() > 0) {
            this.fluid_handler.getOutput(this.inputSlotA.get(0));
        } else if (this.fluid_handler.output() != null && this.output == null) {
            this.fluid_handler.setOutput(null);
        }
        if (this.prevAmount != this.fluidTank1.getFluidAmount()) {
            this.prevAmount = this.fluidTank1.getFluidAmount();
            if (this.prevAmount != 0) {
                new PacketUpdateFieldTile(this, "fluidtank", (Object)this.fluidTank1);
            } else {
                new PacketUpdateFieldTile(this, "fluidtank_empty", true);
            }
        }
        if (this.prevAmount1 != this.fluidTank2.getFluidAmount()) {
            this.prevAmount1 = this.fluidTank2.getFluidAmount();
            if (this.prevAmount1 != 0) {
                new PacketUpdateFieldTile(this, "fluidtank1", (Object)this.fluidTank2);
            } else {
                new PacketUpdateFieldTile(this, "fluidtank1_empty", true);
            }
        }
        if (this.output != null && !this.inputSlotA.isEmpty() && this.outputSlot.isEmpty() && this.outputSlot.canAdd(this.output.getRecipe().getOutput().items) && this.inputSlotA.continue_process(this.output) && this.fluid_handler.output() != null && this.fluid_handler.canOperate() && this.fluid_handler.canFillFluid()) {
            if (!this.getActive()) {
                this.setActive(true);
            }
            if (this.progress == 0) {
                this.initiate(0);
            }
            this.progress = (short)(this.progress + 1);
            double k = this.progress;
            this.guiProgress = k / (double)this.operationLength;
            if (this.progress >= this.operationLength) {
                this.guiProgress = 0.0;
                this.operate();
                this.progress = 0;
                this.initiate(2);
                new PacketUpdateFieldTile(this, "guiProgress", this.guiProgress);
            }
            if (this.f_58857_.m_46467_() % 20L == 0L) {
                new PacketUpdateFieldTile(this, "guiProgress", this.guiProgress);
            }
        } else {
            if (this.progress != 0 && this.getActive()) {
                this.initiate(0);
            }
            if (this.output == null) {
                this.progress = 0;
                this.guiProgress = 0.0;
            }
            if (this.getActive()) {
                this.setActive(false);
            }
        }
    }

    public void operate() {
        for (int i = 0; i < 1; ++i) {
            this.operateOnce();
            this.getOutput();
            if (this.output == null) break;
        }
    }

    public void operateOnce() {
        this.inputSlotA.consume();
        this.outputSlot.add(this.output.getRecipe().getOutput().items);
        this.fluid_handler.fillFluid();
        new PacketUpdateFieldTile(this, "slot3", false);
        new PacketUpdateFieldTile(this, "slot1", this.outputSlot);
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Processing, UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage, UpgradableProperty.ItemInput, UpgradableProperty.FluidExtract);
    }

    public double getProgress() {
        return this.guiProgress;
    }
}

