/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.quarry_earth;

import com.denfop.IUItem;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockEarthQuarry;
import com.denfop.componets.Energy;
import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerEarthController;
import com.denfop.gui.GuiCore;
import com.denfop.gui.GuiEarthController;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.register.InitMultiBlockSystem;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.tiles.mechanism.multiblocks.base.TileMultiBlockBase;
import com.denfop.tiles.quarry_earth.DataPos;
import com.denfop.tiles.quarry_earth.IAnalyzer;
import com.denfop.tiles.quarry_earth.IEarthChest;
import com.denfop.tiles.quarry_earth.IEarthQuarry;
import com.denfop.tiles.quarry_earth.IRigDrill;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TileEntityEarthQuarryController
extends TileMultiBlockBase
implements IEarthQuarry,
IUpdatableTileEvent {
    public static List<ChunkPos> chunkPos = new LinkedList<ChunkPos>();
    public static Random random = new Random();
    public final Energy energy;
    public List<IEarthChest> earthChestList = new ArrayList<IEarthChest>();
    public IAnalyzer analyzer;
    public boolean work;
    public int indexChunk = 0;
    public Map<ChunkPos, List<DataPos>> map = new HashMap<ChunkPos, List<DataPos>>();
    public List<ChunkPos> chunkPosList = new LinkedList<ChunkPos>();
    private List<DataPos> dataPos = new LinkedList<DataPos>();
    public int max = 0;
    public int block_Col;
    private IRigDrill quarry;
    List<DataPos> notAddedPos = new ArrayList<DataPos>();

    public TileEntityEarthQuarryController(BlockPos pos, BlockState state) {
        super(InitMultiBlockSystem.EarthQuarryMultiBlock, BlockEarthQuarry.earth_controller, pos, state);
        this.energy = this.addComponent(Energy.asBasicSink((TileEntityInventory)this, 100000.0, 14));
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
    }

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.work = nbttagcompound.m_128471_("work");
        this.indexChunk = nbttagcompound.m_128451_("indexChunk");
        this.max = nbttagcompound.m_128451_("max");
        this.block_Col = nbttagcompound.m_128451_("block_Col");
        this.dataPos = new LinkedList<DataPos>();
        ListTag dataPosList = nbttagcompound.m_128437_("DataPosList", 10);
        for (Object t : dataPosList) {
            CompoundTag dpTag = (CompoundTag)t;
            this.dataPos.add(DataPos.load(dpTag));
        }
        ListTag nodAddedDataPosList = nbttagcompound.m_128437_("nodAddedDataPosList", 10);
        for (Object t : nodAddedDataPosList) {
            CompoundTag dpTag = (CompoundTag)t;
            this.notAddedPos.add(DataPos.load(dpTag));
        }
        this.chunkPosList = new ArrayList<ChunkPos>();
        ListTag chunkList = nbttagcompound.m_128437_("ChunkPosList", 10);
        for (Tag t : chunkList) {
            CompoundTag cpTag = (CompoundTag)t;
            int x = cpTag.m_128451_("x");
            int z = cpTag.m_128451_("z");
            this.chunkPosList.add(new ChunkPos(x, z));
        }
        this.map = new HashMap<ChunkPos, List<DataPos>>();
        ListTag mapList = nbttagcompound.m_128437_("ChunkDataMap", 10);
        for (Tag t : mapList) {
            CompoundTag entryTag = (CompoundTag)t;
            int x = entryTag.m_128451_("x");
            int z = entryTag.m_128451_("z");
            ChunkPos chunkPos = new ChunkPos(x, z);
            ListTag dpList = entryTag.m_128437_("data", 10);
            ArrayList<DataPos> list = new ArrayList<DataPos>();
            for (Tag dpTag : dpList) {
                list.add(DataPos.load((CompoundTag)dpTag));
            }
            this.map.put(chunkPos, list);
        }
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbttagcompound) {
        nbttagcompound.m_128379_("work", this.work);
        nbttagcompound.m_128405_("indexChunk", this.indexChunk);
        nbttagcompound.m_128405_("max", this.max);
        nbttagcompound.m_128405_("block_Col", this.block_Col);
        ListTag dataPosList = new ListTag();
        for (DataPos dataPos : this.dataPos) {
            dataPosList.add((Object)dataPos.save());
        }
        nbttagcompound.m_128365_("DataPosList", (Tag)dataPosList);
        ListTag nodAddedDataPosList = new ListTag();
        for (DataPos dataPos : this.notAddedPos) {
            nodAddedDataPosList.add((Object)dataPos.save());
        }
        nbttagcompound.m_128365_("nodAddedDataPosList", (Tag)nodAddedDataPosList);
        ListTag listTag = new ListTag();
        for (ChunkPos cp : this.chunkPosList) {
            CompoundTag cpTag = new CompoundTag();
            cpTag.m_128405_("x", cp.f_45578_);
            cpTag.m_128405_("z", cp.f_45579_);
            listTag.add((Object)cpTag);
        }
        nbttagcompound.m_128365_("ChunkPosList", (Tag)listTag);
        ListTag listTag2 = new ListTag();
        for (Map.Entry<ChunkPos, List<DataPos>> entry : this.map.entrySet()) {
            CompoundTag entryTag = new CompoundTag();
            entryTag.m_128405_("x", entry.getKey().f_45578_);
            entryTag.m_128405_("z", entry.getKey().f_45579_);
            ListTag dpList = new ListTag();
            for (DataPos dp : entry.getValue()) {
                dpList.add((Object)dp.save());
            }
            entryTag.m_128365_("data", (Tag)dpList);
            listTag2.add((Object)entryTag);
        }
        nbttagcompound.m_128365_("ChunkDataMap", (Tag)listTag2);
        return super.writeToNBT(nbttagcompound);
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.earthQuarry.getBlock(this.getTeBlock());
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockEarthQuarry.earth_controller;
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer customPacketBuffer = super.writeContainerPacket();
        customPacketBuffer.writeBoolean(this.work);
        customPacketBuffer.writeInt(this.max);
        customPacketBuffer.writeInt(this.indexChunk);
        customPacketBuffer.writeInt(this.block_Col);
        return customPacketBuffer;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        this.work = customPacketBuffer.readBoolean();
        this.max = customPacketBuffer.readInt();
        this.indexChunk = customPacketBuffer.readInt();
        this.block_Col = customPacketBuffer.readInt();
    }

    @Override
    public void updateTileServer(Player var1, double var2) {
        if (var2 == 0.0 && !this.analyzer.getChunkPoses().isEmpty()) {
            this.work = !this.work;
            this.indexChunk = 0;
        }
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.work && this.full && this.getWorld().m_46467_() % 10L == 0L) {
            if (this.analyzer.fullAnalyzed() && !this.chunkPosList.isEmpty()) {
                List dataPos = this.map.getOrDefault(this.chunkPosList.get(this.indexChunk), Collections.emptyList());
                this.max = this.chunkPosList.size();
                for (DataPos dataPos1 : dataPos) {
                    if (this.energy.getEnergy() < 50.0) {
                        this.notAddedPos.add(dataPos1);
                        continue;
                    }
                    this.energy.useEnergy(50.0);
                    if (dataPos1.state.m_60734_() == Blocks.f_50493_) {
                        if (random.nextInt(100) < 90) continue;
                        this.f_58857_.m_7731_(dataPos1.getPos(), IUItem.ore2.getStateFromMeta(1), 3);
                        this.dataPos.add(dataPos1);
                        continue;
                    }
                    if (dataPos1.state.m_60734_() == Blocks.f_49994_) {
                        if (random.nextInt(100) < 94) continue;
                        this.f_58857_.m_7731_(dataPos1.getPos(), IUItem.ore2.getStateFromMeta(2), 3);
                        this.dataPos.add(dataPos1);
                        continue;
                    }
                    if (dataPos1.state.m_60734_() != Blocks.f_49992_ || random.nextInt(100) < 80) continue;
                    this.f_58857_.m_7731_(dataPos1.getPos(), IUItem.ore2.getStateFromMeta(0), 3);
                    this.dataPos.add(dataPos1);
                }
                this.block_Col = this.dataPos.size();
                chunkPos.add(this.chunkPosList.get(this.indexChunk));
                ++this.indexChunk;
                if (this.indexChunk == this.chunkPosList.size()) {
                    this.quarry.startOperation(this.dataPos);
                    this.chunkPosList.clear();
                    this.work = false;
                }
            } else if (!this.notAddedPos.isEmpty()) {
                Iterator<DataPos> iter = this.notAddedPos.iterator();
                while (iter.hasNext()) {
                    DataPos dataPos1 = iter.next();
                    if (this.energy.getEnergy() < 50.0) continue;
                    this.energy.useEnergy(50.0);
                    if (dataPos1.state.m_60734_() == Blocks.f_50493_) {
                        if (random.nextInt(100) >= 90) {
                            this.f_58857_.m_7731_(dataPos1.getPos(), IUItem.ore2.getStateFromMeta(1), 3);
                            this.dataPos.add(dataPos1);
                        }
                    } else if (dataPos1.state.m_60734_() == Blocks.f_49994_) {
                        if (random.nextInt(100) >= 94) {
                            this.f_58857_.m_7731_(dataPos1.getPos(), IUItem.ore2.getStateFromMeta(2), 3);
                            this.dataPos.add(dataPos1);
                        }
                    } else if (dataPos1.state.m_60734_() == Blocks.f_49992_ && random.nextInt(100) >= 80) {
                        this.f_58857_.m_7731_(dataPos1.getPos(), IUItem.ore2.getStateFromMeta(0), 3);
                        this.dataPos.add(dataPos1);
                    }
                    iter.remove();
                }
                this.block_Col = this.dataPos.size();
                this.work = false;
                this.indexChunk = this.max;
            } else {
                this.work = false;
                this.indexChunk = this.max;
            }
        }
    }

    public ContainerEarthController getGuiContainer(Player entityPlayer) {
        return new ContainerEarthController(this, entityPlayer);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player var1, ContainerBase<? extends IAdvInventory> menu) {
        return new GuiEarthController((ContainerEarthController)menu);
    }

    @Override
    public void setFull(boolean full) {
        super.setFull(full);
        if (!full) {
            this.earthChestList.clear();
        }
    }

    @Override
    public void updateAfterAssembly() {
        List<BlockPos> pos1 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.m_58899_(), IAnalyzer.class);
        this.analyzer = (IAnalyzer)this.getWorld().m_7702_(pos1.get(0));
        List<BlockPos> pos2 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.m_58899_(), IEarthChest.class);
        for (BlockPos pos3 : pos2) {
            this.earthChestList.add((IEarthChest)this.getWorld().m_7702_(pos3));
        }
        this.map = this.analyzer.getChunkPoses();
        this.chunkPosList = new ArrayList<ChunkPos>(this.map.keySet());
        List<BlockPos> pos3 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.m_58899_(), IRigDrill.class);
        this.quarry = (IRigDrill)this.getWorld().m_7702_(pos3.get(0));
    }

    @Override
    public void usingBeforeGUI() {
    }

    public Energy getEnergy() {
        return this.energy;
    }
}

