/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.smeltery;

import com.denfop.IUItem;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.mechanism.BlockSmeltery;
import com.denfop.componets.Fluids;
import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerSmelteryFuelTank;
import com.denfop.gui.GuiCore;
import com.denfop.gui.GuiSmelteryFuelTank;
import com.denfop.tiles.mechanism.multiblocks.base.TileEntityMultiBlockElement;
import com.denfop.tiles.smeltery.IFuelTank;
import com.denfop.utils.FluidHandlerFix;
import com.denfop.utils.ModUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class TileEntitySmelteryFuelTank
extends TileEntityMultiBlockElement
implements IFuelTank {
    private final Fluids fluids = this.addComponent(new Fluids(this));
    private final Fluids.InternalFluidTank fluidTank = this.fluids.addTank("fluids", 10000);
    private double speed;

    public TileEntitySmelteryFuelTank(BlockPos pos, BlockState state) {
        super(BlockSmeltery.smeltery_fuel_tank, pos, state);
        this.fluidTank.setAcceptedFluids(Fluids.fluidPredicate(new Fluid[]{net.minecraft.world.level.material.Fluids.f_76195_, (Fluid)FluidName.fluidpahoehoe_lava.getInstance().get()}));
    }

    @Override
    public boolean onActivated(Player player, InteractionHand hand, Direction side, Vec3 vec3) {
        if (!this.getWorld().f_46443_ && FluidHandlerFix.getFluidHandler(player.m_21120_(hand)) != null) {
            return ModUtils.interactWithFluidHandler(player, hand, (IFluidHandler)this.fluids.getCapability(ForgeCapabilities.FLUID_HANDLER, side));
        }
        return super.onActivated(player, hand, side, vec3);
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        this.speed = !this.fluidTank.getFluid().isEmpty() && this.fluidTank.getFluid().getFluid().equals(FluidName.fluidpahoehoe_lava.getInstance().get()) ? 2.0 : 1.0;
    }

    @Override
    public boolean hasOwnInventory() {
        return true;
    }

    public ContainerSmelteryFuelTank getGuiContainer(Player var1) {
        return new ContainerSmelteryFuelTank(this, var1);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player var1, ContainerBase<? extends IAdvInventory> menu) {
        return new GuiSmelteryFuelTank((ContainerSmelteryFuelTank)menu);
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockSmeltery.smeltery_fuel_tank;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.smeltery.getBlock(this.getTeBlock());
    }

    @Override
    public FluidTank getFuelTank() {
        return this.fluidTank;
    }

    @Override
    public double getSpeed() {
        return this.speed;
    }
}

