/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.utils;

import com.denfop.api.item.IEnergyItem;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.world.item.ItemStack;

public class MatterRecipe {
    private final ItemStack stack;
    int COMPARE_DAMAGE = 1;
    int COMPARE_NBT = 2;
    int COMPARE_QUANTITY = 4;
    private boolean can;
    private double aer;
    private double aqua;
    private double earth;
    private double night;
    private double sun;
    private double end;
    private double nether;
    private double matter;

    public MatterRecipe(ItemStack stack) {
        this.stack = stack.m_41777_();
        this.stack.m_41764_(1);
        this.aer = 0.0;
        this.aqua = 0.0;
        this.earth = 0.0;
        this.night = 0.0;
        this.sun = 0.0;
        this.end = 0.0;
        this.nether = 0.0;
        this.matter = 0.0;
        this.can = false;
    }

    public static boolean areItemStackTagsEqual(ItemStack stackA, ItemStack stackB) {
        if (stackA.m_41619_() && stackB.m_41619_()) {
            return true;
        }
        if (!stackA.m_41619_() && !stackB.m_41619_()) {
            if (stackA.m_41783_() == null && stackB.m_41783_() != null) {
                return false;
            }
            return stackA.m_41783_() == null || stackA.m_41783_().equals((Object)stackB.m_41783_());
        }
        return false;
    }

    public boolean isEqualNbt(@Nullable ItemStack left, @Nullable ItemStack right) {
        if (!MatterRecipe.areItemStackTagsEqual(left, right)) {
            if (left.m_41782_() && !right.m_41782_() && left.m_41783_().m_128456_()) {
                return true;
            }
            if (!left.m_41782_() && right.m_41782_() && right.m_41783_().m_128456_()) {
                return true;
            }
            return !left.m_41782_() && !right.m_41782_();
        }
        return true;
    }

    public boolean isEqual(@Nullable ItemStack left, @Nullable ItemStack right, int flags) {
        if (left.m_41720_() != right.m_41720_()) {
            return false;
        }
        if (left.m_41720_() instanceof IEnergyItem && right.m_41720_() instanceof IEnergyItem) {
            return true;
        }
        if ((flags & this.COMPARE_NBT) == this.COMPARE_NBT && !this.isEqualNbt(left, right)) {
            return false;
        }
        if ((flags & this.COMPARE_QUANTITY) == this.COMPARE_QUANTITY) {
            return left.m_41613_() == right.m_41613_();
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MatterRecipe that = (MatterRecipe)o;
        return this.isEqual(that.stack, this.stack, 3);
    }

    public int hashCode() {
        return Objects.hash(this.stack, this.aer, this.aqua, this.earth, this.night, this.sun, this.end, this.nether, this.matter);
    }

    public void setCan(boolean can) {
        this.can = can;
    }

    public double getAer() {
        return this.aer;
    }

    public double getAqua() {
        return this.aqua;
    }

    public double getEarth() {
        return this.earth;
    }

    public double getEnd() {
        return this.end;
    }

    public double getMatter() {
        return this.matter;
    }

    public double getNether() {
        return this.nether;
    }

    public double getNight() {
        return this.night;
    }

    public double getSun() {
        return this.sun;
    }

    public boolean can() {
        return this.can && (this.aer != 0.0 || this.aqua != 0.0 || this.earth != 0.0 || this.nether != 0.0 || this.sun != 0.0 || this.night != 0.0 || this.matter != 0.0 || this.end != 0.0);
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public void addAer(double aer) {
        this.aer += aer;
    }

    public void addNether(double nether) {
        this.nether += nether;
    }

    public void addAqua(double aqua) {
        this.aqua += aqua;
    }

    public void addSun(double sun) {
        this.sun += sun;
    }

    public void addMatter(double matter) {
        this.matter += matter;
    }

    public void addEnd(double end) {
        this.end += end;
    }

    public void addEarth(double earth) {
        this.earth += earth;
    }

    public void addNight(double night) {
        this.night += night;
    }
}

