/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.componets;

import com.denfop.api.sytem.EnergyType;
import com.denfop.blocks.FluidName;
import com.denfop.componets.ComponentBaseEnergy;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.ModUtils;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.core.Direction;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class ComponentBioFuelEnergy
extends ComponentBaseEnergy {
    FluidTank fluidTank;

    public ComponentBioFuelEnergy(EnergyType type, TileEntityInventory parent, double capacity) {
        this(type, parent, capacity, Collections.emptySet(), Collections.emptySet(), 1);
    }

    public ComponentBioFuelEnergy(EnergyType type, TileEntityInventory parent, double capacity, Set<Direction> sinkDirections, Set<Direction> sourceDirections, int tier) {
        this(type, parent, capacity, sinkDirections, sourceDirections, tier, tier, false);
    }

    public ComponentBioFuelEnergy(EnergyType type, TileEntityInventory parent, double capacity, Set<Direction> sinkDirections, Set<Direction> sourceDirections, int sinkTier, int sourceTier, boolean fullEnergy) {
        super(type, parent, capacity, sinkDirections, sourceDirections, sinkTier, sourceTier, fullEnergy);
    }

    public ComponentBioFuelEnergy(EnergyType type, TileEntityInventory parent, double capacity, List<Direction> sinkDirections, List<Direction> sourceDirections, int sinkTier, int sourceTier, boolean fullEnergy) {
        super(type, parent, capacity, sinkDirections, sourceDirections, sinkTier, sourceTier, fullEnergy);
    }

    public static ComponentBioFuelEnergy asBasicSink(TileEntityInventory parent, double capacity) {
        return ComponentBioFuelEnergy.asBasicSink(parent, capacity, 1);
    }

    public static ComponentBioFuelEnergy asBasicSink(TileEntityInventory parent, double capacity, int tier) {
        return new ComponentBioFuelEnergy(EnergyType.BIOFUEL, parent, capacity, ModUtils.allFacings, Collections.emptySet(), tier);
    }

    public static ComponentBioFuelEnergy asBasicSource(TileEntityInventory parent, double capacity) {
        return ComponentBioFuelEnergy.asBasicSource(parent, capacity, 1);
    }

    public static ComponentBioFuelEnergy asBasicSource(TileEntityInventory parent, double capacity, int tier) {
        return new ComponentBioFuelEnergy(EnergyType.BIOFUEL, parent, capacity, Collections.emptySet(), ModUtils.allFacings, tier);
    }

    public void setFluidTank(FluidTank fluidTank) {
        this.fluidTank = fluidTank;
    }

    @Override
    public double addEnergy(double amount) {
        super.addEnergy(amount);
        if (this.fluidTank.getFluid().isEmpty() && amount >= 1.0) {
            this.fluidTank.fill(new FluidStack((Fluid)FluidName.fluidbiomass.getInstance().get(), (int)this.storage), IFluidHandler.FluidAction.EXECUTE);
        } else if (!this.fluidTank.getFluid().isEmpty()) {
            this.fluidTank.getFluid().setAmount((int)this.storage);
        }
        return amount;
    }

    @Override
    public boolean isClient() {
        return true;
    }

    @Override
    public boolean useEnergy(double amount) {
        super.useEnergy(amount);
        if (!this.fluidTank.getFluid().isEmpty()) {
            this.fluidTank.getFluid().setAmount((int)this.storage);
            if (this.fluidTank.getFluid().getAmount() == 0) {
                this.fluidTank.setFluid(FluidStack.EMPTY);
            }
        }
        return true;
    }

    public FluidTank getFluidTank() {
        return this.fluidTank;
    }
}

