/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.container;

import com.denfop.IUCore;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.componets.AbstractComponent;
import com.denfop.container.SlotInvSlot;
import com.denfop.container.SlotVirtual;
import com.denfop.invslot.InvSlot;
import com.denfop.mixin.access.AbstractContainerMenuAccessor;
import com.denfop.network.packet.PacketUpdateFieldContainerTile;
import com.denfop.tiles.base.TileEntityBlock;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.ModUtils;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ContainerBase<T extends IAdvInventory>
extends AbstractContainerMenu {
    public final T base;
    public Player player;
    Inventory inventory;

    public ContainerBase(T t, Player player) {
        super(t.getMenuType(), t.getContainerId());
        this.base = t;
        if (player != null) {
            this.player = player;
            this.inventory = player.m_150109_();
        }
    }

    protected static final boolean isValidTargetSlot(Slot slot, ItemStack stack, boolean allowEmpty, boolean requireInputOnly) {
        if (!slot.m_5857_(stack)) {
            return false;
        }
        if (!allowEmpty && !slot.m_6657_()) {
            return false;
        }
        if (!requireInputOnly) {
            return true;
        }
        return slot instanceof SlotInvSlot && ((SlotInvSlot)slot).invSlot.canInput();
    }

    public Player getPlayer() {
        return this.player;
    }

    protected Slot addSlotToContainer(Slot p_38898_) {
        return this.m_38897_(p_38898_);
    }

    protected void addPlayerInventorySlots(Inventory inventory, int height) {
        this.addPlayerInventorySlots(inventory, 178, height);
        this.inventory = inventory;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    @Nullable
    public Slot getSlotFromInventory(Container inv, int slotIn) {
        for (Slot slot : this.f_38839_) {
            if (slot.f_40218_ != inv || slot.f_40219_ != slotIn) continue;
            return slot;
        }
        return (Slot)this.f_38839_.get(slotIn % this.f_38839_.size());
    }

    protected void addPlayerInventorySlots(Inventory inventory, int width, int height) {
        int n3;
        int n4 = (width - 162) / 2;
        for (n3 = 0; n3 < 3; ++n3) {
            for (int i = 0; i < 9; ++i) {
                this.m_38897_(new Slot((Container)inventory, i + n3 * 9 + 9, n4 + i * 18, height + -82 + n3 * 18));
            }
        }
        for (n3 = 0; n3 < 9; ++n3) {
            this.m_38897_(new Slot((Container)inventory, n3, n4 + n3 * 18, height + -24));
        }
    }

    protected Slot m_38897_(Slot p_38898_) {
        return super.m_38897_(p_38898_);
    }

    public void m_150399_(int slotId, int dragType, ClickType clickType, Player player) {
        if (IUCore.network.getClient() != null && player.m_9236_().f_46443_ && this.checkClick()) {
            return;
        }
        if (slotId < 0) {
            super.m_150399_(slotId, dragType, clickType, player);
            return;
        }
        Slot slot = (Slot)this.f_38839_.get(slotId);
        if (!(slot instanceof SlotVirtual)) {
            if (slot instanceof SlotInvSlot) {
                SlotInvSlot slot1 = (SlotInvSlot)slot;
                if (!slot1.invSlot.canShift() && clickType == ClickType.QUICK_MOVE) {
                    return;
                }
                ((SlotInvSlot)slot).setDragType(dragType);
            }
            super.m_150399_(slotId, dragType, clickType, player);
            this.base.m_6596_();
        } else {
            ((SlotVirtual)slot).slotClick(slotId, dragType, clickType, player);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private boolean checkClick() {
        return Minecraft.m_91087_().m_91092_() != null;
    }

    public final ItemStack m_7648_(Player player, int sourceSlotIndex) {
        Slot sourceSlot = (Slot)this.f_38839_.get(sourceSlotIndex);
        if (sourceSlot != null && sourceSlot.m_6657_()) {
            ItemStack sourceItemStack = sourceSlot.m_7993_();
            int oldSourceItemStackSize = ModUtils.getSize(sourceItemStack);
            ItemStack resultStack = sourceSlot.f_40218_ == player.m_150109_() ? this.handlePlayerSlotShiftClick(player, sourceItemStack) : this.handleGUISlotShiftClick(player, sourceItemStack);
            if (ModUtils.isEmpty(resultStack) || ModUtils.getSize(resultStack) != oldSourceItemStackSize) {
                sourceSlot.m_5852_(resultStack);
                sourceSlot.m_142406_(player, sourceItemStack);
                if (!player.m_9236_().f_46443_) {
                    this.m_38946_();
                }
            }
        }
        return ModUtils.emptyStack;
    }

    protected boolean m_38903_(ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        return this.moveItemStackTo(stack, (List<Slot>)this.f_38839_, startIndex, endIndex, reverseDirection);
    }

    protected boolean moveItemStackTo(ItemStack stack, List<Slot> slots, int startIndex, int endIndex, boolean reverseDirection) {
        ItemStack itemstack;
        Slot slot;
        int i;
        boolean flag = false;
        int n = i = reverseDirection ? endIndex - 1 : startIndex;
        if (stack.m_41753_()) {
            while (!stack.m_41619_() && !(!reverseDirection ? i >= endIndex : i < startIndex)) {
                slot = slots.get(i);
                itemstack = slot.m_7993_();
                if (!itemstack.m_41619_() && slot.m_5857_(stack) && ItemStack.m_150942_((ItemStack)stack, (ItemStack)itemstack)) {
                    int maxSize;
                    int j = itemstack.m_41613_() + stack.m_41613_();
                    if (j <= (maxSize = Math.min(slot.m_5866_(itemstack), stack.m_41741_()))) {
                        stack.m_41764_(0);
                        itemstack.m_41764_(j);
                        slot.m_5852_(itemstack);
                        slot.m_6654_();
                        flag = true;
                    } else if (itemstack.m_41613_() < maxSize) {
                        stack.m_41774_(maxSize - itemstack.m_41613_());
                        itemstack.m_41764_(maxSize);
                        slot.m_5852_(itemstack);
                        slot.m_6654_();
                        flag = true;
                    }
                }
                i += reverseDirection ? -1 : 1;
            }
        }
        if (!stack.m_41619_()) {
            int n2 = i = reverseDirection ? endIndex - 1 : startIndex;
            while (!(!reverseDirection ? i >= endIndex : i < startIndex)) {
                slot = slots.get(i);
                itemstack = slot.m_7993_();
                if (itemstack.m_41619_() && slot.m_5857_(stack)) {
                    slot.m_5852_(stack.m_41620_(Math.min(stack.m_41613_(), slot.m_5866_(stack))));
                    slot.m_6654_();
                    flag = true;
                    break;
                }
                i += reverseDirection ? -1 : 1;
            }
        }
        return flag;
    }

    protected ItemStack handlePlayerSlotShiftClick(Player player, ItemStack sourceItemStack) {
        for (int run = 0; run < 4 && !ModUtils.isEmpty(sourceItemStack); ++run) {
            Slot targetSlot;
            Iterator iterator = this.f_38839_.iterator();
            while (iterator.hasNext() && ((targetSlot = (Slot)iterator.next()) instanceof SlotVirtual || targetSlot.f_40218_ == player.m_150109_() || !ContainerBase.isValidTargetSlot(targetSlot, sourceItemStack, run % 2 == 1, run < 2) || !ModUtils.isEmpty(sourceItemStack = this.transfer(sourceItemStack, targetSlot)))) {
            }
        }
        return sourceItemStack;
    }

    protected ItemStack handleGUISlotShiftClick(Player player, ItemStack sourceItemStack) {
        for (int run = 0; run < 2 && !sourceItemStack.m_41619_(); ++run) {
            Slot targetSlot;
            ListIterator it = this.f_38839_.listIterator(this.f_38839_.size());
            while (it.hasPrevious() && ((targetSlot = (Slot)it.previous()) instanceof SlotVirtual || targetSlot.f_40218_ != player.m_150109_() || !ContainerBase.isValidTargetSlot(targetSlot, sourceItemStack, run == 1, false) || !(sourceItemStack = this.transfer(sourceItemStack, targetSlot)).m_41619_())) {
            }
        }
        return sourceItemStack;
    }

    public boolean m_6875_(Player player) {
        return this.base.m_6542_(player);
    }

    public void m_38946_() {
        for (int i = 0; i < this.f_38839_.size(); ++i) {
            if (((Slot)this.f_38839_.get((int)i)).f_40218_ != this.player.m_150109_() && this.f_38839_.get(i) instanceof SlotInvSlot) continue;
            ItemStack itemstack = ((Slot)this.f_38839_.get(i)).m_7993_();
            Supplier supplier = Suppliers.memoize(() -> ((ItemStack)itemstack).m_41777_());
            ((AbstractContainerMenuAccessor)((Object)this)).invokeTriggerSlotListeners(i, itemstack, (java.util.function.Supplier<ItemStack>)supplier);
            ((AbstractContainerMenuAccessor)((Object)this)).invokeSynchronizeSlotToRemote(i, itemstack, (java.util.function.Supplier<ItemStack>)supplier);
        }
        ((AbstractContainerMenuAccessor)((Object)this)).invokeSynchronizeCarriedToRemote();
        if (this.base instanceof BlockEntity) {
            if (this.player instanceof ServerPlayer) {
                new PacketUpdateFieldContainerTile((TileEntityBlock)((Object)this.base), (ServerPlayer)this.player);
            }
            if (this.base instanceof TileEntityInventory && this.player instanceof ServerPlayer) {
                for (AbstractComponent component : ((TileEntityInventory)this.base).getComponentList()) {
                    component.onContainerUpdate((ServerPlayer)this.player);
                }
            }
        }
    }

    protected final ItemStack transfer(ItemStack stack, Slot dst) {
        int amount = this.getTransferAmount(stack, dst);
        if (amount > 0) {
            ItemStack dstStack = dst.m_7993_();
            if (ModUtils.isEmpty(dstStack)) {
                dst.m_5852_(ModUtils.setSize(stack, amount));
            } else {
                dst.m_5852_(ModUtils.incSize(dstStack, amount));
            }
            stack = ModUtils.decSize(stack, amount);
        }
        return stack;
    }

    private int getTransferAmount(ItemStack stack, Slot dst) {
        int amount = Math.min(dst.f_40218_.m_6893_(), dst.m_6641_());
        amount = Math.min(amount, stack.m_41753_() ? stack.m_41741_() : 1);
        ItemStack dstStack = dst.m_7993_();
        if (!ModUtils.isEmpty(dstStack)) {
            if (!ModUtils.checkItemEqualityStrict(stack, dstStack)) {
                return 0;
            }
            amount -= ModUtils.getSize(dstStack);
        }
        amount = Math.min(amount, ModUtils.getSize(stack));
        return amount;
    }

    public SlotInvSlot findClassSlot(Class<? extends InvSlot> invSlotClass) {
        for (Slot slot : this.f_38839_) {
            if (!(slot instanceof SlotInvSlot) || !((SlotInvSlot)slot).invSlot.getClass().equals(invSlotClass)) continue;
            return (SlotInvSlot)slot;
        }
        return null;
    }

    public List<SlotInvSlot> findClassSlots(Class<? extends InvSlot> invSlotClass) {
        ArrayList<SlotInvSlot> list = new ArrayList<SlotInvSlot>();
        for (Slot slot : this.f_38839_) {
            if (!(slot instanceof SlotInvSlot) || !((SlotInvSlot)slot).invSlot.getClass().equals(invSlotClass)) continue;
            list.add((SlotInvSlot)slot);
        }
        return list;
    }

    public List<SlotInvSlot> getSlots() {
        ArrayList<SlotInvSlot> list = new ArrayList<SlotInvSlot>();
        for (Slot slot : this.f_38839_) {
            if (!(slot instanceof SlotInvSlot)) continue;
            list.add((SlotInvSlot)slot);
        }
        return list;
    }
}

