/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.container;

import com.denfop.api.inv.VirtualSlot;
import com.denfop.invslot.InvSlot;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.FluidHandlerFix;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class SlotInfo
extends InvSlot
implements VirtualSlot {
    List<FluidStack> fluidStackList;
    private List<ItemStack> listBlack;
    private List<ItemStack> listWhite;
    private boolean fluid;

    public SlotInfo(TileEntityInventory multiCable, int size, boolean fluid) {
        super(multiCable, null, size);
        this.fluid = fluid;
        this.fluidStackList = new ArrayList<FluidStack>(Collections.nCopies(this.size(), FluidStack.EMPTY));
        this.listBlack = new ArrayList<ItemStack>();
        this.listWhite = new ArrayList<ItemStack>();
    }

    public List<ItemStack> getListBlack() {
        return this.listBlack;
    }

    public List<ItemStack> getListWhite() {
        return this.listWhite;
    }

    @Override
    public void readFromNbt(CompoundTag nbt) {
        super.readFromNbt(nbt);
        this.fluid = nbt.m_128471_("fluid");
        if (this.fluid) {
            this.fluidStackList = new ArrayList<FluidStack>(Collections.nCopies(this.size(), FluidStack.EMPTY));
            for (int i = 0; i < this.size(); ++i) {
                if (this.get(i).m_41619_() || !FluidHandlerFix.hasFluidHandler(this.get(i))) continue;
                this.fluidStackList.set(i, new FluidStack(FluidHandlerFix.getFluidHandler(this.get(i)).drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE), 1));
            }
        }
    }

    @Override
    public CompoundTag writeToNbt(CompoundTag nbt) {
        nbt = super.writeToNbt(nbt);
        nbt.m_128379_("fluid", this.isFluid());
        return nbt;
    }

    @Override
    public List<FluidStack> getFluidStackList() {
        return this.fluidStackList;
    }

    @Override
    public void setFluidList(List<FluidStack> fluidStackList) {
        this.fluidStackList = fluidStackList;
    }

    @Override
    public boolean isFluid() {
        return this.fluid;
    }

    public void setFluid(boolean fluid) {
        this.fluid = fluid;
    }

    @Override
    public boolean accepts(ItemStack stack, int index) {
        return true;
    }

    @Override
    public ItemStack set(int index, ItemStack stack) {
        if (!stack.m_41619_()) {
            stack = stack.m_41777_();
            stack.m_41764_(1);
        }
        this.contents.set(index, (Object)stack);
        this.listBlack.clear();
        this.listWhite.clear();
        this.listBlack = new LinkedList<ItemStack>();
        this.listWhite = new LinkedList<ItemStack>();
        for (int i = 0; i < this.size(); ++i) {
            ItemStack itemStack = (ItemStack)this.contents.get(i);
            if (itemStack.m_41619_()) continue;
            if (i < 9) {
                this.listBlack.add(itemStack);
                continue;
            }
            this.listWhite.add(itemStack);
        }
        this.listBlack = new ArrayList<ItemStack>(this.listBlack);
        this.listWhite = new ArrayList<ItemStack>(this.listWhite);
        this.onChanged();
        return stack;
    }

    @Override
    public void onChanged() {
        this.listBlack.clear();
        this.listWhite.clear();
        for (int i = 0; i < this.size(); ++i) {
            ItemStack itemStack = (ItemStack)this.contents.get(i);
            if (itemStack.m_41619_()) continue;
            if (i < 9) {
                this.listBlack.add(itemStack);
                continue;
            }
            this.listWhite.add(itemStack);
        }
    }

    @Override
    public ItemStack get(int index) {
        return (ItemStack)this.contents.get(index);
    }

    public ItemStack get() {
        return this.get(0);
    }
}

