/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.gui;

import com.denfop.api.gui.FluidItem;
import com.denfop.api.gui.GuiElement;
import com.denfop.container.ContainerGeothermalExchanger;
import com.denfop.gui.GuiIU;
import com.denfop.tiles.geothermalpump.TileEntityGeothermalExchanger;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;

public class GuiGeothermalExchanger<T extends ContainerGeothermalExchanger>
extends GuiIU<ContainerGeothermalExchanger> {
    public GuiGeothermalExchanger(final ContainerGeothermalExchanger guiContainer) {
        super(guiContainer);
        this.componentList.clear();
        this.addElement(new FluidItem(this, this.f_97726_ / 2 - 10, 20, ((TileEntityGeothermalExchanger)guiContainer.base).getFluidTank().getFluid()){

            @Override
            public void drawBackground(PoseStack poseStack, int mouseX, int mouseY) {
                1.bindCommonTexture();
                FluidStack fs = ((TileEntityGeothermalExchanger)guiContainer.base).getFluidTank().getFluid();
                if (!fs.isEmpty() && fs.getAmount() > 0) {
                    int fluidX = this.x + 1;
                    int fluidY = this.y + 1;
                    int fluidWidth = 10;
                    int fluidHeight = 45;
                    Fluid fluid = fs.getFluid();
                    IClientFluidTypeExtensions extensions = IClientFluidTypeExtensions.of((Fluid)fluid);
                    TextureAtlasSprite sprite = 1.getBlockTextureMap().m_118316_(extensions.getStillTexture(fs));
                    int color = extensions.getTintColor();
                    1.bindBlockTexture();
                    this.gui.drawSprite(poseStack, mouseX + fluidX, (double)(mouseY + fluidY) + (45.0 - (double)fluidHeight * ((double)fs.getAmount() / 10000.0)), fluidWidth, (double)fluidHeight * ((double)fs.getAmount() / 10000.0), sprite, color, 1.0, false, false);
                }
                1.bindTexture(commonTexture1);
            }

            @Override
            public void drawForeground(PoseStack poseStack, int mouseX, int mouseY) {
                if (mouseX >= this.x - 4 && mouseX <= this.x + 15 && mouseY >= this.y - 4 && mouseY <= this.y + 51) {
                    String tooltip;
                    List<String> lines = this.getToolTip();
                    if (this.getTooltipProvider() != null && (tooltip = (String)this.getTooltipProvider().get()) != null && !tooltip.isEmpty()) {
                        1.addLines(lines, tooltip);
                    }
                    if (!lines.isEmpty()) {
                        this.gui.drawTooltip(mouseX, mouseY, lines);
                    }
                }
            }
        });
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        super.drawGuiContainerBackgroundLayer(poseStack, partialTicks, mouseX, mouseY);
        this.bindTexture();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawTexturedModalRect(poseStack, this.guiLeft + this.f_97726_ / 2 - 10 - 4, this.guiTop + 20 - 4, 235, 98, 20, 55);
        for (GuiElement element : this.elements) {
            element.drawBackground(poseStack, this.guiLeft, this.guiTop);
        }
    }

    @Override
    protected ResourceLocation getTexture() {
        return new ResourceLocation("industrialupgrade", "textures/gui/guigeothermalpump.png");
    }
}

