/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.worldcollector.end;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.gui.GuiIU;
import com.denfop.integration.jei.IRecipeCategory;
import com.denfop.integration.jei.JeiInform;
import com.denfop.integration.jei.worldcollector.end.EndHandler;
import com.denfop.recipes.ItemStackHelper;
import com.denfop.tiles.mechanism.TileEntityEnchanterBooks;
import com.denfop.utils.ModUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class EndCategory
extends GuiIU
implements IRecipeCategory<EndHandler> {
    private final IDrawableStatic bg;
    private int progress = 0;
    private int energy = 0;
    JeiInform jeiInform;

    public EndCategory(IGuiHelper guiHelper, JeiInform jeiInform) {
        super(((TileEntityEnchanterBooks)BlockBaseMachine3.enchanter_books.getDummyTe()).getGuiContainer((Player)Minecraft.m_91087_().f_91074_));
        this.jeiInform = jeiInform;
        this.f_96539_ = Component.m_237113_((String)this.getTitles());
        this.bg = guiHelper.createDrawable(new ResourceLocation("industrialupgrade", "textures/gui/guiendassembler.png"), 5, 5, 140, 75);
    }

    public RecipeType<EndHandler> getRecipeType() {
        return this.jeiInform.recipeType;
    }

    @Override
    @Nonnull
    public String getTitles() {
        return Localization.translate(ItemStackHelper.fromData(IUItem.basemachine2, 1, 23).m_41778_());
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.bg;
    }

    public void draw(EndHandler recipe, IRecipeSlotsView recipeSlotsView, PoseStack stack, double mouseX, double mouseY) {
        ++this.progress;
        ++this.energy;
        int energylevel = (int)Math.min(51.0f * (float)this.energy / 100.0f, 51.0f);
        int xScale = 34 * this.progress / 100;
        if (xScale > 34) {
            this.progress = 0;
        }
        EndCategory.bindTexture(this.getTexture());
        this.drawTexturedModalRect(stack, 26, 63 - energylevel, 179, 53 - energylevel, 5, energylevel);
        this.drawTexturedModalRect(stack, 61, 29, 177, 60, xScale, 18);
        this.drawSplitString(stack, Localization.translate("iu.need_info") + recipe.getNeed() + Localization.translate("iu.need_info_matter"), 79, 54, 81, ModUtils.convertRGBcolorToInt(0, 0, 0));
    }

    public void setRecipe(IRecipeLayoutBuilder builder, EndHandler recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 39, 19).addItemStack(recipe.getInput());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 105, 30).addItemStack(recipe.getOutput());
    }

    @Override
    protected ResourceLocation getTexture() {
        return new ResourceLocation("industrialupgrade", "textures/gui/guiendassembler.png");
    }
}

