/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.bags;

import com.denfop.ElectricItem;
import com.denfop.IUCore;
import com.denfop.Localization;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.item.IEnergyItem;
import com.denfop.api.upgrade.EnumUpgrades;
import com.denfop.api.upgrade.IUpgradeItem;
import com.denfop.api.upgrade.UpgradeSystem;
import com.denfop.api.upgrade.event.EventItemLoad;
import com.denfop.container.ContainerBags;
import com.denfop.items.EnumInfoUpgradeModules;
import com.denfop.items.IItemStackInventory;
import com.denfop.items.IProperties;
import com.denfop.items.bags.BagsDescription;
import com.denfop.items.bags.ItemStackBags;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.IUpdatableItemStackEvent;
import com.denfop.utils.ElectricItemManager;
import com.denfop.utils.ModUtils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkHooks;

public class ItemEnergyBags
extends Item
implements IItemStackInventory,
IProperties,
IUpdatableItemStackEvent,
IUpgradeItem,
IEnergyItem {
    private final int slots;
    private final int maxStorage;
    private final int getTransferLimit;
    private String nameItem;

    public ItemEnergyBags(int slots, int maxStorage, int getTransferLimit) {
        super(new Item.Properties().m_41491_(IUCore.EnergyTab).m_41487_(1));
        this.slots = slots;
        this.getTransferLimit = getTransferLimit;
        this.maxStorage = maxStorage;
        IUCore.runnableListAfterRegisterItem.add(() -> UpgradeSystem.system.addRecipe(this, EnumUpgrades.BAGS.list));
        IUCore.proxy.addProperties(this);
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237113_((String)Localization.translate("iu.bags.info")));
        if (!Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237115_((String)"press.lshift"));
        } else {
            CompoundTag nbt = stack.m_41783_();
            if (nbt == null || !nbt.m_128441_("bag")) {
                return;
            }
            ArrayList<BagsDescription> list = new ArrayList<BagsDescription>();
            CompoundTag nbt1 = nbt.m_128469_("bag");
            int size = nbt1.m_128451_("size");
            for (int i = 0; i < size; ++i) {
                list.add(new BagsDescription(nbt1.m_128469_(String.valueOf(i))));
            }
            for (BagsDescription description : list) {
                tooltip.add((Component)Component.m_237113_((String)(description.getCount() + "x ")).m_7220_(description.getStack().m_41786_()).m_130940_(ChatFormatting.GREEN));
            }
        }
    }

    @Override
    public List<EnumInfoUpgradeModules> getUpgradeModules() {
        return EnumUpgrades.BAGS.list;
    }

    protected String m_41467_() {
        if (this.nameItem == null) {
            StringBuilder pathBuilder = new StringBuilder(Util.m_137492_((String)"iu", (ResourceLocation)Registry.f_122827_.m_7981_((Object)this)));
            String targetString = "industrialupgrade.";
            String replacement = "";
            if (replacement != null) {
                int index = pathBuilder.indexOf(targetString);
                while (index != -1) {
                    pathBuilder.replace(index, index + targetString.length(), replacement);
                    index = pathBuilder.indexOf(targetString, index + replacement.length());
                }
            }
            this.nameItem = "item." + pathBuilder.toString().split("\\.")[2];
        }
        return this.nameItem;
    }

    public boolean m_142522_(ItemStack stack) {
        return true;
    }

    public int m_142159_(ItemStack stack) {
        return ModUtils.convertRGBcolorToInt(33, 91, 199);
    }

    public int m_142158_(ItemStack stack) {
        return 13 - (int)(13.0 * Math.min(Math.max(1.0 - ElectricItem.manager.getCharge(stack) / ElectricItem.manager.getMaxCharge(stack), 0.0), 1.0));
    }

    @Override
    public boolean canProvideEnergy(ItemStack stack) {
        return false;
    }

    @Override
    public double getMaxEnergy(ItemStack stack) {
        return this.maxStorage;
    }

    @Override
    public short getTierItem(ItemStack stack) {
        return 2;
    }

    @Override
    public double getTransferEnergy(ItemStack stack) {
        return this.getTransferLimit;
    }

    @Override
    public IAdvInventory getInventory(Player player, ItemStack stack) {
        return new ItemStackBags(player, stack, this.slots);
    }

    public void m_6787_(CreativeModeTab p_41391_, NonNullList<ItemStack> p_41392_) {
        if (this.m_220152_(p_41391_)) {
            ElectricItemManager.addChargeVariants(this, p_41392_);
        }
    }

    public boolean m_8120_(ItemStack p_41456_) {
        return false;
    }

    public int m_6473_() {
        return 0;
    }

    public void save(ItemStack stack, Player player) {
        CompoundTag nbt = ModUtils.nbt(stack);
        nbt.m_128379_("open", true);
        nbt.m_128405_("slot_inventory", player.m_150109_().f_35977_);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void updateField(String name, CustomPacketBuffer buffer, ItemStack stack) {
    }

    @Override
    public void updateEvent(int event, ItemStack stack) {
        CompoundTag nbt;
        nbt.m_128379_("white", !(nbt = ModUtils.nbt(stack)).m_128471_("white"));
    }

    public boolean canInsert(Player player, ItemStack stack, ItemStack stack1) {
        ItemStackBags box = (ItemStackBags)this.getInventory(player, stack);
        return box.canAdd(stack1);
    }

    public void insert(Player player, ItemStack stack, ItemStack stack1) {
        ItemStackBags box = (ItemStackBags)this.getInventory(player, stack);
        box.add(stack1);
        box.m_6596_();
    }

    public void insertWithoutSave(Player player, ItemStack stack, ItemStack stack1) {
        ItemStackBags box = (ItemStackBags)this.getInventory(player, stack);
        box.addWithoutSave(stack1);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        super.m_6883_(stack, world, entity, itemSlot, isSelected);
        if (!(entity instanceof Player)) {
            return;
        }
        CompoundTag nbt = ModUtils.nbt(stack);
        if (!UpgradeSystem.system.hasInMap(stack)) {
            nbt.m_128379_("hasID", false);
            MinecraftForge.EVENT_BUS.post((Event)new EventItemLoad(world, this, stack));
        }
        Player player = (Player)entity;
        if (nbt.m_128471_("open")) {
            int slotId = nbt.m_128451_("slot_inventory");
            if (slotId != itemSlot && !world.f_46443_ && !stack.m_41619_() && player.f_36096_ instanceof ContainerBags) {
                ItemStackBags toolbox = (ItemStackBags)((ContainerBags)player.f_36096_).base;
                if (toolbox.isThisContainer(stack)) {
                    toolbox.saveAsThrown(stack);
                    player.m_6915_();
                    nbt.m_128379_("open", false);
                }
            } else if (!(player.f_36096_ instanceof ContainerBags)) {
                nbt.m_128379_("open", false);
            }
        }
    }

    public boolean onDroppedByPlayer(@Nonnull ItemStack stack, @Nonnull Player player) {
        ItemStackBags toolbox;
        if (!player.f_19853_.f_46443_ && !stack.m_41619_() && player.f_36096_ instanceof ContainerBags && (toolbox = (ItemStackBags)((ContainerBags)player.f_36096_).base).isThisContainer(stack)) {
            toolbox.saveAndThrow(stack);
            player.m_6915_();
        }
        return true;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level world, @Nonnull Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = ModUtils.get(player, hand);
        double coef = 1.0 - (UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.ENERGY, player.m_21120_(hand)) ? (double)UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.ENERGY, (ItemStack)player.m_21120_((InteractionHand)hand)).number * 0.25 : 0.0);
        if (ElectricItem.manager.canUse(player.m_21120_(hand), 350.0 * coef)) {
            ElectricItem.manager.use(player.m_21120_(hand), 350.0 * coef, (LivingEntity)player);
            if (!world.f_46443_ && !player.m_6144_()) {
                this.save(stack, player);
                CustomPacketBuffer growingBuffer = new CustomPacketBuffer();
                growingBuffer.writeByte(1);
                growingBuffer.flip();
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)this.getInventory(player, player.m_21120_(hand)), buf -> buf.writeBytes((ByteBuf)growingBuffer));
                return InteractionResultHolder.m_19090_((Object)player.m_21120_(hand));
            }
        }
        return InteractionResultHolder.m_19098_((Object)player.m_21120_(hand));
    }

    @Override
    public String[] properties() {
        return new String[]{"open"};
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public float getItemProperty(ItemStack itemStack, ClientLevel level, LivingEntity entity, int p174679, String property) {
        return ModUtils.nbt(itemStack).m_128471_("open") ? 1.0f : 0.0f;
    }
}

