/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.bags;

import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerLeadBox;
import com.denfop.gui.GuiCore;
import com.denfop.gui.GuiLeadBox;
import com.denfop.invslot.InvSlot;
import com.denfop.items.ItemStackInventory;
import com.denfop.utils.ModUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemStackLeadBox
extends ItemStackInventory {
    public final int inventorySize;
    public final ItemStack itemStack1;

    public ItemStackLeadBox(Player player, ItemStack stack, int inventorySize) {
        super(player, stack, inventorySize);
        this.inventorySize = inventorySize;
        this.itemStack1 = stack;
    }

    @Override
    public void save() {
        super.save();
    }

    public void saveAndThrow(ItemStack stack) {
        ListTag contentList = new ListTag();
        for (int i = 0; i < this.inventory.length; ++i) {
            if (ModUtils.isEmpty(this.inventory[i])) continue;
            CompoundTag nbt = new CompoundTag();
            nbt.m_128344_("Slot", (byte)i);
            this.inventory[i].m_41739_(nbt);
            contentList.add((Object)nbt);
        }
        ModUtils.nbt(stack).m_128365_("Items", (Tag)contentList);
        this.clear();
    }

    @Override
    public ItemStackInventory getParent() {
        return this;
    }

    @Override
    public void addInventorySlot(InvSlot var1) {
    }

    @Override
    public int getBaseIndex(InvSlot var1) {
        return 0;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<?>> getGui(Player var1, ContainerBase<?> menu) {
        ContainerLeadBox containerLeadBox = (ContainerLeadBox)menu;
        return new GuiLeadBox(containerLeadBox, this.itemStack1);
    }

    public ContainerLeadBox getGuiContainer(Player player) {
        return new ContainerLeadBox(player, this);
    }

    public ItemStack get(int index) {
        return this.inventory[index];
    }

    protected void restore(ItemStack[] backup) {
        if (backup.length != this.inventory.length) {
            throw new IllegalArgumentException("invalid array size");
        }
        System.arraycopy(backup, 0, this.inventory, 0, this.inventory.length);
    }

    @Override
    @Nonnull
    public String getName() {
        return "toolbox";
    }

    public boolean hasCustomName() {
        return false;
    }

    public int add(Collection<ItemStack> stacks) {
        return this.add(stacks, false);
    }

    public boolean add(ItemStack stack) {
        if (stack == null) {
            throw new NullPointerException("null ItemStack");
        }
        return this.add(Collections.singletonList(stack), false);
    }

    public boolean canAdd(Collection<ItemStack> stacks) {
        return this.add(stacks, true) == 0;
    }

    public boolean canAdd(ItemStack stack) {
        if (stack == null) {
            throw new NullPointerException("null ItemStack");
        }
        return this.add(Collections.singletonList(stack), true);
    }

    protected ItemStack[] backup() {
        ItemStack[] ret = new ItemStack[this.inventory.length];
        for (int i = 0; i < this.inventory.length; ++i) {
            ItemStack content = this.inventory[i];
            ret[i] = ModUtils.isEmpty(content) ? ModUtils.emptyStack : content.m_41777_();
        }
        return ret;
    }

    public void put(ItemStack content) {
        this.put(0, content);
    }

    public void put(int index, ItemStack content) {
        if (ModUtils.isEmpty(content)) {
            content = ModUtils.emptyStack;
        }
        this.inventory[index] = content;
        this.save();
    }

    public int getStackSizeLimit() {
        return 64;
    }

    private boolean add(List<ItemStack> stacks, boolean simulate) {
        if (stacks != null && !stacks.isEmpty()) {
            for (ItemStack stack : stacks) {
                for (int i = 0; i < this.inventory.length; ++i) {
                    if (this.get(i) == null || this.get(i).m_41619_()) {
                        if (!simulate) {
                            this.put(i, stack.m_41777_());
                        }
                        return true;
                    }
                    if (!this.get(i).m_150930_(stack.m_41720_()) || this.get(i).m_41613_() + stack.m_41613_() > stack.m_41741_()) continue;
                    if (stack.m_41783_() == null && this.get(i).m_41783_() == null) {
                        if (!simulate) {
                            this.get(i).m_41769_(stack.m_41613_());
                        }
                        return true;
                    }
                    if (stack.m_41783_() == null || !stack.m_41783_().equals((Object)this.get(i).m_41783_())) continue;
                    if (!simulate) {
                        this.get(i).m_41769_(stack.m_41613_());
                    }
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    private int add(Collection<ItemStack> stacks, boolean simulate) {
        if (stacks != null && !stacks.isEmpty()) {
            ItemStack[] backup = simulate ? this.backup() : null;
            int totalAmount = 0;
            Iterator<ItemStack> var5 = stacks.iterator();
            while (true) {
                if (!var5.hasNext()) {
                    if (simulate) {
                        this.restore(backup);
                    }
                    return totalAmount;
                }
                ItemStack stack = var5.next();
                int amount = ModUtils.getSize(stack);
                if (amount <= 0) continue;
                block1: for (int pass = 0; pass < 2; ++pass) {
                    for (int i = 0; i < this.inventorySize; ++i) {
                        ItemStack existingStack = this.get(i);
                        int space = this.getStackSizeLimit();
                        if (!ModUtils.isEmpty(existingStack)) {
                            space = Math.min(space, existingStack.m_41741_()) - ModUtils.getSize(existingStack);
                        }
                        if (space <= 0) continue;
                        if (pass == 0 && !ModUtils.isEmpty(existingStack) && ModUtils.checkItemEqualityStrict(stack, existingStack)) {
                            if (space >= amount) {
                                existingStack.m_41769_(amount);
                                this.put(i, existingStack);
                                amount = 0;
                                break block1;
                            }
                            existingStack.m_41769_(space);
                            this.put(i, existingStack);
                            amount -= space;
                            continue;
                        }
                        if (pass != 1 || !ModUtils.isEmpty(existingStack)) continue;
                        if (space >= amount) {
                            this.put(i, ModUtils.setSize(stack, amount));
                            amount = 0;
                            break block1;
                        }
                        this.put(i, ModUtils.setSize(stack, space));
                        amount -= space;
                    }
                }
                totalAmount += amount;
            }
        }
        return 0;
    }
}

