/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.recipe.universalrecipe;

import com.denfop.api.space.EnumLevels;
import com.denfop.api.space.EnumType;
import com.denfop.api.space.IStar;
import com.denfop.api.space.ISystem;
import com.denfop.api.space.Planet;
import com.denfop.api.space.SpaceInit;
import com.denfop.api.space.SpaceNet;
import com.denfop.recipe.universalrecipe.PlanetRecipe;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class PlanetSerializer
implements RecipeSerializer<PlanetRecipe> {
    public static final PlanetSerializer INSTANCE = new PlanetSerializer();

    public PlanetRecipe fromJson(ResourceLocation id, JsonObject json) {
        String name = json.get("name").getAsString();
        ISystem system = SpaceNet.instance.getSystem().stream().filter(systems -> systems.getName().equals(json.get("system").getAsString().toLowerCase())).toList().get(0);
        ResourceLocation texture = new ResourceLocation(json.get("texture").getAsString() + ".png");
        EnumLevels level = EnumLevels.valueOf(json.get("level").getAsString().toUpperCase());
        IStar star = (IStar)SpaceNet.instance.getBodyFromName(json.get("star").getAsString());
        int temperature = json.get("temperature").getAsInt();
        boolean pressure = json.get("pressure").getAsBoolean();
        double distance = json.get("distance").getAsDouble();
        EnumType type = EnumType.valueOf(json.get("type").getAsString().toUpperCase());
        boolean oxygen = json.get("oxygen").getAsBoolean();
        boolean colonies = json.get("colonies").getAsBoolean();
        int angle = json.get("angle").getAsInt();
        double time = json.get("time").getAsDouble();
        double size = json.get("size").getAsDouble();
        double rotation = json.get("rotation").getAsDouble();
        SpaceInit.regPlanet.add(() -> new Planet(name, system, texture, level, star, temperature, pressure, distance, type, oxygen, colonies, angle, time, size, rotation));
        return new PlanetRecipe(id, "", Collections.emptyList(), "");
    }

    public PlanetRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
        return new PlanetRecipe(id, "", new ArrayList<ItemStack>(), "");
    }

    public void toNetwork(FriendlyByteBuf buf, PlanetRecipe recipe) {
    }
}

