/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.render.base;

import com.denfop.api.bee.IBee;
import com.denfop.entity.SmallBee;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.BeeModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;

public class SmallBeeRenderer
extends MobRenderer<SmallBee, BeeModel<SmallBee>> {
    private static final ResourceLocation ANGRY_BEE_TEXTURE = new ResourceLocation("textures/entity/bee/bee_angry.png");
    private static final ResourceLocation ANGRY_NECTAR_BEE_TEXTURE = new ResourceLocation("textures/entity/bee/bee_angry_nectar.png");
    private static final ResourceLocation BEE_TEXTURE = new ResourceLocation("textures/entity/bee/bee.png");
    private static final ResourceLocation NECTAR_BEE_TEXTURE = new ResourceLocation("textures/entity/bee/bee_nectar.png");
    private static final ResourceLocation[] BEE_TEXTURES = new ResourceLocation[5];
    private static final ResourceLocation[] NECTAR_BEE_TEXTURES = new ResourceLocation[5];
    private static final ResourceLocation[] ANGRY_BEE_TEXTURES = new ResourceLocation[5];
    private static final ResourceLocation[] ANGRY_NECTAR_BEE_TEXTURES = new ResourceLocation[5];

    public SmallBeeRenderer(EntityRendererProvider.Context p_173931_) {
        super(p_173931_, (EntityModel)new BeeModel(p_173931_.m_174023_(ModelLayers.f_171268_)), 0.4f);
    }

    public void render(SmallBee pEntity, float pEntityYaw, float pPartialTicks, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight) {
        pPoseStack.m_85836_();
        pPoseStack.m_85841_(0.5f, 0.5f, 0.5f);
        super.m_7392_((Mob)pEntity, pEntityYaw, pPartialTicks, pPoseStack, pBuffer, pPackedLight);
        pPoseStack.m_85849_();
    }

    public ResourceLocation getTextureLocation(SmallBee pEntity) {
        IBee bee = pEntity.bee;
        if (bee != null) {
            String name = bee.getName();
            int id = bee.getId();
            ResourceLocation texture = BEE_TEXTURES[id];
            ResourceLocation texture_nectar = NECTAR_BEE_TEXTURES[id];
            ResourceLocation angry_texture = ANGRY_BEE_TEXTURES[id];
            ResourceLocation angry_texture_nectar = ANGRY_NECTAR_BEE_TEXTURES[id];
            if (pEntity.m_21660_()) {
                if (pEntity.m_27856_()) {
                    if (angry_texture_nectar == null) {
                        SmallBeeRenderer.ANGRY_NECTAR_BEE_TEXTURES[id] = angry_texture_nectar = new ResourceLocation("industrialupgrade", "textures/entity/bee/" + name + "_angry_nectar_bee.png");
                    }
                    return angry_texture_nectar;
                }
                if (angry_texture == null) {
                    SmallBeeRenderer.ANGRY_BEE_TEXTURES[id] = angry_texture = new ResourceLocation("industrialupgrade", "textures/entity/bee/" + name + "_angry_bee.png");
                }
                return angry_texture;
            }
            if (pEntity.m_27856_()) {
                if (texture_nectar == null) {
                    SmallBeeRenderer.NECTAR_BEE_TEXTURES[id] = texture_nectar = new ResourceLocation("industrialupgrade", "textures/entity/bee/" + name + "_nectar_bee.png");
                }
                return texture_nectar;
            }
            if (texture == null) {
                texture = new ResourceLocation("industrialupgrade", "textures/entity/bee/" + name + "_bee.png");
                SmallBeeRenderer.BEE_TEXTURES[id] = angry_texture;
            }
            return texture;
        }
        if (pEntity.m_21660_()) {
            return pEntity.m_27856_() ? ANGRY_NECTAR_BEE_TEXTURE : ANGRY_BEE_TEXTURE;
        }
        return pEntity.m_27856_() ? NECTAR_BEE_TEXTURE : BEE_TEXTURE;
    }
}

