/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import com.denfop.IUItem;
import com.denfop.api.audio.EnumTypeAudio;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.radiationsystem.Radiation;
import com.denfop.api.radiationsystem.RadiationSystem;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.audio.EnumSound;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerRadiationPurifier;
import com.denfop.gui.GuiCore;
import com.denfop.gui.GuiRadiationPurifier;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileElectricMachine;
import com.denfop.tiles.mechanism.TileEntitySoilAnalyzer;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TileRadiationPurifier
extends TileElectricMachine {
    public EnumTypeAudio typeAudio = EnumTypeAudio.OFF;
    public EnumTypeAudio[] valuesAudio = EnumTypeAudio.values();
    public Radiation radiation;
    public Map<BlockPos, TileEntitySoilAnalyzer> booleanMap = new HashMap<BlockPos, TileEntitySoilAnalyzer>();
    private ItemStack stack;

    public TileRadiationPurifier(BlockPos pos, BlockState state) {
        super(50000.0, 14, 1, BlockBaseMachine3.radiation_purifier, pos, state);
        this.pollutionSoil = this.addComponent(new SoilPollutionComponent(this, 0.15));
        this.pollutionAir = this.addComponent(new AirPollutionComponent(this, 0.15));
    }

    @Override
    public void onNeighborChange(BlockState neighbor, BlockPos neighborPos) {
        super.onNeighborChange(neighbor, neighborPos);
        if (this.getWorld().f_46443_) {
            return;
        }
        BlockEntity tile = this.getWorld().m_7702_(neighborPos);
        boolean can = tile instanceof TileEntitySoilAnalyzer;
        if (!this.booleanMap.containsKey(neighborPos) && can) {
            this.booleanMap.put(neighborPos, (TileEntitySoilAnalyzer)tile);
        } else if (!can) {
            this.booleanMap.remove(neighborPos);
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.getWorld().f_46443_) {
            for (Direction facing1 : Direction.values()) {
                BlockPos pos1 = this.pos.m_121955_(facing1.m_122436_());
                BlockEntity tile = this.getWorld().m_7702_(pos1);
                boolean can = tile instanceof TileEntitySoilAnalyzer;
                if (!this.booleanMap.containsKey(pos1) && can) {
                    this.booleanMap.put(pos1, (TileEntitySoilAnalyzer)tile);
                    continue;
                }
                if (can) continue;
                this.booleanMap.remove(pos1);
            }
        }
    }

    @Override
    public void loadBeforeFirstUpdate() {
        super.loadBeforeFirstUpdate();
        this.radiation = RadiationSystem.rad_system.getMap().get(this.getWorld().m_46745_(this.pos).m_7697_());
        this.stack = new ItemStack((ItemLike)IUItem.crafting_elements.getStack(443), 1);
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.radiation_purifier;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.getWorld().m_46467_() % 20L == 0L) {
            if (this.radiation != null && this.energy.canUseEnergy(100.0) && !this.booleanMap.isEmpty()) {
                boolean canWork = false;
                for (Map.Entry<BlockPos, TileEntitySoilAnalyzer> entry : this.booleanMap.entrySet()) {
                    canWork = entry.getValue().analyzed;
                    if (!canWork) continue;
                    break;
                }
                if (canWork && this.outputSlot.canAdd(this.stack)) {
                    if (this.radiation.removeRadiationWithType(1000.0)) {
                        this.energy.useEnergy(100.0);
                        this.outputSlot.add(this.stack);
                        this.setActive(true);
                    } else {
                        this.setActive(false);
                    }
                }
            } else {
                this.setActive(false);
            }
        }
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        boolean can = customPacketBuffer.readBoolean();
        if (can) {
            try {
                this.radiation = (Radiation)DecoderHandler.decode(customPacketBuffer);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer customPacketBuffer = super.writeContainerPacket();
        customPacketBuffer.writeBoolean(this.radiation != null);
        if (this.radiation != null) {
            try {
                EncoderHandler.encode(customPacketBuffer, this.radiation);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return customPacketBuffer;
    }

    public ContainerRadiationPurifier getGuiContainer(Player entityPlayer) {
        return new ContainerRadiationPurifier(this, entityPlayer);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player var1, ContainerBase<? extends IAdvInventory> menu) {
        return new GuiRadiationPurifier((ContainerRadiationPurifier)menu);
    }

    @Override
    public SoundEvent getSound() {
        return EnumSound.radiation.getSoundEvent();
    }
}

