/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockRubWood;
import com.denfop.blocks.BlockSwampRubWood;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.BlockTropicalRubWood;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.componets.Fluids;
import com.denfop.network.DecoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.tiles.base.TileEntityBlock;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.FluidHandlerFix;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileEntityAutoLatexCollector
extends TileEntityInventory {
    private final Fluids fluids = this.addComponent(new Fluids(this));
    public final Fluids.InternalFluidTank tank = this.fluids.addTankExtract("tank", 6400);
    boolean work = true;
    BlockState state;

    public TileEntityAutoLatexCollector(BlockPos pos, BlockState state) {
        super(BlockBaseMachine3.auto_latex_collector, pos, state);
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        super.addInformation(stack, tooltip);
        tooltip.add(Localization.translate("auto_latex_collector.info"));
    }

    @Override
    public boolean canPlace(TileEntityBlock te, BlockPos pos, Level world, Direction direction, LivingEntity entity) {
        BlockState state = world.m_8055_(pos.m_121955_(direction.m_122424_().m_122436_()));
        if (state.m_60734_() == IUItem.swampRubWood.getBlock().get()) {
            BlockSwampRubWood.RubberWoodState rwState = (BlockSwampRubWood.RubberWoodState)((Object)state.m_61143_(BlockSwampRubWood.stateProperty));
            return !rwState.isPlain() && rwState.facing == direction;
        }
        if (state.m_60734_() == IUItem.tropicalRubWood.getBlock().get()) {
            BlockTropicalRubWood.RubberWoodState rwState = (BlockTropicalRubWood.RubberWoodState)((Object)state.m_61143_(BlockTropicalRubWood.stateProperty));
            return !rwState.isPlain() && rwState.facing == direction;
        }
        if (state.m_60734_() == IUItem.rubWood.getBlock().get()) {
            BlockRubWood.RubberWoodState rwState = (BlockRubWood.RubberWoodState)((Object)state.m_61143_(BlockRubWood.stateProperty));
            return !rwState.isPlain() && rwState.facing == direction;
        }
        return false;
    }

    @Override
    public void onNeighborChange(BlockState neighbor, BlockPos neighborPos) {
        super.onNeighborChange(neighbor, neighborPos);
        if (neighborPos.equals((Object)this.pos.m_121955_(this.getFacing().m_122424_().m_122436_()))) {
            BlockState state = neighbor;
            this.work = state.m_60734_() == IUItem.swampRubWood.getBlock().get() || state.m_60734_() == IUItem.tropicalRubWood.getBlock().get() || state.m_60734_() == IUItem.rubWood.getBlock().get();
        }
    }

    @Override
    public boolean onActivated(Player player, InteractionHand hand, Direction side, Vec3 vec3) {
        if (!this.getWorld().f_46443_ && FluidHandlerFix.hasFluidHandler(player.m_21120_(hand))) {
            return ModUtils.interactWithFluidHandler(player, hand, (IFluidHandler)this.fluids.getCapability(ForgeCapabilities.FLUID_HANDLER, side));
        }
        return super.onActivated(player, hand, side, vec3);
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        super.updateField(name, is);
        if (name.equals("tank")) {
            try {
                this.tank.setFluid((FluidStack)DecoderHandler.decode(is));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        BlockState state = this.f_58857_.m_8055_(this.pos.m_121955_(this.getFacing().m_122424_().m_122436_()));
        boolean bl = this.work = state.m_60734_() == IUItem.swampRubWood.getBlock().get() || state.m_60734_() == IUItem.tropicalRubWood.getBlock().get() || state.m_60734_() == IUItem.rubWood.getBlock().get();
        if (!this.f_58857_.f_46443_) {
            new PacketUpdateFieldTile(this, "tank", this.tank.getFluid());
        }
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.getWorld().m_46467_() % 20L == 0L && this.work) {
            Enum rwState;
            BlockState state = this.f_58857_.m_8055_(this.pos.m_121955_(this.getFacing().m_122424_().m_122436_()));
            BlockPos pos1 = this.pos.m_121955_(this.getFacing().m_122424_().m_122436_());
            if (state.m_60734_() == IUItem.swampRubWood.getBlock().get()) {
                rwState = (BlockSwampRubWood.RubberWoodState)((Object)state.m_61143_(BlockSwampRubWood.stateProperty));
                if (((BlockSwampRubWood.RubberWoodState)rwState).wet) {
                    this.f_58857_.m_7731_(pos1, (BlockState)state.m_61124_(BlockSwampRubWood.stateProperty, (Comparable)((Object)((BlockSwampRubWood.RubberWoodState)rwState).getDry())), 3);
                    this.tank.fill(new FluidStack((Fluid)FluidName.fluidrawlatex.getInstance().get(), 100 * (this.f_58857_.f_46441_.m_188503_(3) + 1)), IFluidHandler.FluidAction.EXECUTE);
                }
            }
            if (state.m_60734_() == IUItem.tropicalRubWood.getBlock().get()) {
                rwState = (BlockTropicalRubWood.RubberWoodState)((Object)state.m_61143_(BlockTropicalRubWood.stateProperty));
                if (((BlockTropicalRubWood.RubberWoodState)rwState).wet) {
                    this.f_58857_.m_7731_(pos1, (BlockState)state.m_61124_(BlockTropicalRubWood.stateProperty, (Comparable)((Object)((BlockTropicalRubWood.RubberWoodState)rwState).getDry())), 3);
                    this.tank.fill(new FluidStack((Fluid)FluidName.fluidrawlatex.getInstance().get(), 100 * (this.f_58857_.f_46441_.m_188503_(3) + 1)), IFluidHandler.FluidAction.EXECUTE);
                }
            }
            if (state.m_60734_() == IUItem.rubWood.getBlock().get()) {
                rwState = (BlockRubWood.RubberWoodState)((Object)state.m_61143_(BlockRubWood.stateProperty));
                if (((BlockRubWood.RubberWoodState)rwState).wet) {
                    this.f_58857_.m_7731_(pos1, (BlockState)state.m_61124_(BlockRubWood.stateProperty, (Comparable)((Object)((BlockRubWood.RubberWoodState)rwState).getDry())), 3);
                    this.tank.fill(new FluidStack((Fluid)FluidName.fluidrawlatex.getInstance().get(), 100 * (this.f_58857_.f_46441_.m_188503_(3) + 1)), IFluidHandler.FluidAction.EXECUTE);
                }
            }
            new PacketUpdateFieldTile(this, "tank", this.tank.getFluid());
        }
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.auto_latex_collector;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }
}

