/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.audio.EnumTypeAudio;
import com.denfop.api.audio.IAudioFixer;
import com.denfop.api.primitive.EnumPrimitive;
import com.denfop.api.primitive.PrimitiveHandler;
import com.denfop.api.recipe.IUpdateTick;
import com.denfop.api.recipe.InvSlotOutput;
import com.denfop.api.recipe.InvSlotRecipes;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.audio.EnumSound;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockCompressor;
import com.denfop.invslot.InvSlot;
import com.denfop.items.ItemCraftingElements;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityCompressor
extends TileEntityInventory
implements IUpdateTick,
IAudioFixer {
    private static final List<AABB> aabbs = Collections.singletonList(new AABB(0.0, 0.0, 0.0, 1.0, 1.25, 1.0));
    public final InvSlotRecipes inputSlotA = new InvSlotRecipes(this, "compressor", this){

        @Override
        public boolean accepts(ItemStack itemStack, int index) {
            if (index == 4) {
                return super.accepts(itemStack, 0);
            }
            return false;
        }

        @Override
        public int getStackSizeLimit() {
            if (TileEntityCompressor.this.output == null) {
                return 1;
            }
            return TileEntityCompressor.this.output.getRecipe().input.getInputs().get(0).getAmount();
        }
    };
    public final InvSlotOutput outputSlot = new InvSlotOutput(this, 1);
    public int progress = 0;
    public MachineRecipe output;
    public int durability = 96;
    public Map<UUID, Double> data;

    public TileEntityCompressor(BlockPos pos, BlockState state) {
        super(BlockCompressor.compressor, pos, state);
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction facing) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return LazyOptional.empty();
        }
        return super.getCapability(cap, facing);
    }

    @Override
    public List<ItemStack> getSelfDrops(int fortune, boolean wrench) {
        List<ItemStack> drop = super.getSelfDrops(fortune, wrench);
        ItemStack stack = drop.get(0);
        CompoundTag nbt = ModUtils.nbt(stack);
        nbt.m_128405_("durability", this.durability);
        return drop;
    }

    @Override
    public void onPlaced(ItemStack stack, LivingEntity placer, Direction facing) {
        super.onPlaced(stack, placer, facing);
        CompoundTag nbt = ModUtils.nbt(stack);
        if (nbt.m_128441_("durability")) {
            this.durability = nbt.m_128451_("durability");
        }
    }

    @Override
    public List<AABB> getAabbs(boolean forCollision) {
        return aabbs;
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        tooltip.add(Localization.translate("iu.primal_repair2"));
        tooltip.add(Localization.translate("iu.primal_repair.info"));
    }

    @Override
    public EnumTypeAudio getTypeAudio() {
        return EnumTypeAudio.ON;
    }

    @Override
    public void setType(EnumTypeAudio type) {
    }

    @Override
    public SoundEvent getSound() {
        return EnumSound.primal_compressor.getSoundEvent();
    }

    @Override
    public void initiate(int soundEvent) {
        if (soundEvent == 0) {
            this.getWorld().m_5594_(null, this.pos, this.getSound(), SoundSource.BLOCKS, 0.2f, 1.0f);
        }
    }

    @Override
    public boolean getEnable() {
        return true;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.blockCompressor.getBlock();
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockCompressor.compressor;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.getWorld().f_46443_) {
            new PacketUpdateFieldTile(this, "slot", this.inputSlotA);
            new PacketUpdateFieldTile(this, "slot1", this.outputSlot);
        }
        this.data = PrimitiveHandler.getPlayersData(EnumPrimitive.COMPRESSOR);
        this.output = this.inputSlotA.process();
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        super.updateField(name, is);
        if (name.equals("slot")) {
            try {
                this.inputSlotA.readFromNbt(((InvSlot)DecoderHandler.decode(is)).writeToNbt(new CompoundTag()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("slot1")) {
            try {
                this.outputSlot.readFromNbt(((InvSlot)DecoderHandler.decode(is)).writeToNbt(new CompoundTag()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("slot3")) {
            this.inputSlotA.set(0, ItemStack.f_41583_);
        }
        if (name.equals("slot2")) {
            this.outputSlot.set(0, ItemStack.f_41583_);
        }
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            this.inputSlotA.readFromNbt(((InvSlot)DecoderHandler.decode(customPacketBuffer)).writeToNbt(new CompoundTag()));
            this.outputSlot.readFromNbt(((InvSlot)DecoderHandler.decode(customPacketBuffer)).writeToNbt(new CompoundTag()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer customPacketBuffer = super.writePacket();
        try {
            EncoderHandler.encode(customPacketBuffer, this.inputSlotA);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            EncoderHandler.encode(customPacketBuffer, this.outputSlot);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return customPacketBuffer;
    }

    @Override
    public boolean onSneakingActivated(Player player, InteractionHand hand, Direction side, Vec3 hitX) {
        ItemStack stack = player.m_21120_(hand);
        if (this.durability >= 0 && this.durability < 96 && stack.m_41720_() instanceof ItemCraftingElements && IUItem.crafting_elements.getMeta((ItemCraftingElements)stack.m_41720_()) == 76) {
            this.durability = 96;
            stack.m_41774_(1);
            new PacketUpdateFieldTile(this, "durability", this.durability);
        }
        return super.onSneakingActivated(player, hand, side, hitX);
    }

    @Override
    public boolean onActivated(Player player, InteractionHand hand, Direction side, Vec3 hitX) {
        ItemStack stack = player.m_21120_(hand);
        if (!this.getWorld().f_46443_) {
            if (stack.m_41619_() && this.output != null && this.outputSlot.isEmpty() && this.inputSlotA.continue_process(this.output) && this.durability > 0) {
                this.progress += (int)(15.0 + this.data.getOrDefault(player.m_20148_(), 0.0) / 10.0);
                this.getCooldownTracker().setTick(15);
                this.setActive(String.valueOf((int)((double)this.progress * 9.0 / 100.0)));
                if (!this.getWorld().f_46443_) {
                    this.initiate(0);
                }
                if (this.progress >= 100) {
                    this.progress = 0;
                    if (!this.getWorld().f_46443_) {
                        PrimitiveHandler.addExperience(EnumPrimitive.COMPRESSOR, 0.75, player.m_20148_());
                    }
                    this.setActive(false);
                    --this.durability;
                    this.outputSlot.add(this.output.getRecipe().output.items.get(0));
                    this.inputSlotA.consume(0, this.output.getRecipe().input.getInputs().get(0).getAmount());
                    this.output = null;
                    if (!this.f_58857_.f_46443_) {
                        new PacketUpdateFieldTile(this, "slot3", this.inputSlotA);
                        new PacketUpdateFieldTile(this, "slot1", this.outputSlot);
                    }
                }
                return this.getWorld().f_46443_;
            }
            if (!stack.m_41619_()) {
                if (this.inputSlotA.get(0).m_41619_() && this.inputSlotA.accepts(stack, 4)) {
                    ItemStack stack1 = stack.m_41777_();
                    stack1.m_41764_(1);
                    this.inputSlotA.set(0, stack1);
                    stack.m_41774_(1);
                    if (!this.f_58857_.f_46443_) {
                        new PacketUpdateFieldTile(this, "slot", this.inputSlotA);
                    }
                    return true;
                }
                if (!this.inputSlotA.get(0).m_41619_() && this.inputSlotA.get(0).m_150930_(stack.m_41720_())) {
                    int minCount = this.inputSlotA.getStackSizeLimit() - this.inputSlotA.get(0).m_41613_();
                    minCount = Math.min(stack.m_41613_(), minCount);
                    this.inputSlotA.get(0).m_41769_(minCount);
                    stack.m_41769_(-minCount);
                    if (!this.f_58857_.f_46443_) {
                        new PacketUpdateFieldTile(this, "slot", this.inputSlotA);
                    }
                    return true;
                }
            } else {
                if (!this.outputSlot.isEmpty()) {
                    if (!this.f_58857_.f_46443_) {
                        ModUtils.dropAsEntity(this.f_58857_, this.pos, this.outputSlot.get(0));
                    }
                    this.outputSlot.set(0, ItemStack.f_41583_);
                    if (!this.f_58857_.f_46443_) {
                        new PacketUpdateFieldTile(this, "slot2", false);
                    }
                    return true;
                }
                if (!this.inputSlotA.isEmpty()) {
                    if (!this.f_58857_.f_46443_) {
                        ModUtils.dropAsEntity(this.f_58857_, this.pos, this.inputSlotA.get(0));
                    }
                    this.inputSlotA.set(0, ItemStack.f_41583_);
                    this.output = null;
                    if (!this.f_58857_.f_46443_) {
                        new PacketUpdateFieldTile(this, "slot3", false);
                    }
                    return true;
                }
            }
        }
        return this.getWorld().f_46443_;
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.durability = nbttagcompound.m_128451_("durability");
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.m_128405_("durability", this.durability);
        return nbttagcompound;
    }

    @Override
    public MachineRecipe getRecipeOutput() {
        return this.output;
    }

    @Override
    public void setRecipeOutput(MachineRecipe output) {
        this.output = output;
    }
}

