/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.agriculture.CropNetwork;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.ComponentUpgradeSlots;
import com.denfop.componets.Energy;
import com.denfop.componets.Fluids;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.componets.client.ComponentVisibleArea;
import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerFieldCleaner;
import com.denfop.gui.GuiCore;
import com.denfop.gui.GuiFieldCleaner;
import com.denfop.invslot.InvSlotUpgrade;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.tiles.crop.TileEntityCrop;
import com.denfop.utils.FluidHandlerFix;
import com.denfop.utils.ModUtils;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileEntityFieldCleaner
extends TileEntityInventory
implements IUpgradableBlock {
    private static final int RADIUS = 8;
    public final Energy energy;
    public final Fluids.InternalFluidTank tank;
    public final InvSlotUpgrade upgradeSlot;
    private final Fluids fluids;
    private final ComponentUpgradeSlots componentUpgrade;
    AABB searchArea;
    List<List<TileEntityCrop>> list;
    List<ChunkPos> chunks;
    private ComponentVisibleArea visible;

    public TileEntityFieldCleaner(BlockPos pos, BlockState state) {
        super(BlockBaseMachine3.field_cleaner, pos, state);
        this.searchArea = new AABB(this.pos.m_7918_(-8, -8, -8), this.pos.m_7918_(9, 9, 9));
        this.list = new ArrayList<List<TileEntityCrop>>();
        this.fluids = this.addComponent(new Fluids(this));
        this.tank = this.fluids.addTankInsert("tank", 10000, Fluids.fluidPredicate((Fluid)FluidName.fluidweed_ex.getInstance().get()));
        this.energy = this.addComponent(Energy.asBasicSink((TileEntityInventory)this, 1024.0, 4));
        this.upgradeSlot = new InvSlotUpgrade(this, 4);
        this.componentUpgrade = this.addComponent(new ComponentUpgradeSlots(this, this.upgradeSlot));
        this.pollutionSoil = this.addComponent(new SoilPollutionComponent(this, 0.1));
        this.pollutionAir = this.addComponent(new AirPollutionComponent(this, 0.1));
        this.visible = this.addComponent(new ComponentVisibleArea(this));
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage, UpgradableProperty.FluidInput);
    }

    @Override
    public boolean onActivated(Player player, InteractionHand hand, Direction side, Vec3 vec3) {
        if (!this.getWorld().f_46443_ && FluidHandlerFix.hasFluidHandler(player.m_21120_(hand))) {
            return ModUtils.interactWithFluidHandler(player, hand, (IFluidHandler)this.fluids.getCapability(ForgeCapabilities.FLUID_HANDLER, side));
        }
        return super.onActivated(player, hand, side, vec3);
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.field_cleaner;
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        super.addInformation(stack, tooltip);
        tooltip.add(Localization.translate("iu.field_cleaner.info"));
        if (this.getComp(Energy.class) != null) {
            Energy energy = this.getComp(Energy.class);
            if (!energy.getSourceDirs().isEmpty()) {
                tooltip.add(Localization.translate("iu.item.tooltip.PowerTier", energy.getSourceTier()));
            } else if (!energy.getSinkDirs().isEmpty()) {
                tooltip.add(Localization.translate("iu.item.tooltip.PowerTier", energy.getSinkTier()));
            }
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.visible.aabb = this.searchArea;
        if (!this.getWorld().f_46443_) {
            AABB aabb = this.searchArea;
            int j2 = Mth.m_14107_((double)((aabb.f_82288_ - 2.0) / 16.0));
            int k2 = Mth.m_14165_((double)((aabb.f_82291_ + 2.0) / 16.0));
            int l2 = Mth.m_14107_((double)((aabb.f_82290_ - 2.0) / 16.0));
            int i3 = Mth.m_14165_((double)((aabb.f_82293_ + 2.0) / 16.0));
            this.chunks = new ArrayList<ChunkPos>();
            for (int j3 = j2; j3 < k2; ++j3) {
                for (int k3 = l2; k3 < i3; ++k3) {
                    LevelChunk chunk = this.f_58857_.m_6325_(j3, k3);
                    if (this.chunks.contains(chunk.m_7697_())) continue;
                    this.chunks.add(chunk.m_7697_());
                }
            }
            for (ChunkPos chunk : this.chunks) {
                this.list.add(CropNetwork.instance.getCropsFromChunk(this.f_58857_, chunk));
            }
        }
    }

    public ContainerFieldCleaner getGuiContainer(Player var1) {
        return new ContainerFieldCleaner(this, var1);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player var1, ContainerBase<? extends IAdvInventory> menu) {
        return new GuiFieldCleaner((ContainerFieldCleaner)menu);
    }

    public boolean contains(BlockPos vec) {
        if ((double)vec.m_123341_() > this.searchArea.f_82288_ && (double)vec.m_123341_() < this.searchArea.f_82291_) {
            if ((double)vec.m_123342_() > this.searchArea.f_82289_ && (double)vec.m_123342_() < this.searchArea.f_82292_) {
                return (double)vec.m_123343_() > this.searchArea.f_82290_ && (double)vec.m_123343_() < this.searchArea.f_82293_;
            }
            return false;
        }
        return false;
    }

    private void updateCrop() {
        this.list.clear();
        for (ChunkPos chunk : this.chunks) {
            this.list.add(CropNetwork.instance.getCropsFromChunk(this.f_58857_, chunk));
        }
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.getWorld().m_46467_() % 100L == 0L) {
            this.updateCrop();
        }
        if (this.getWorld().m_46467_() % 20L == 0L && this.energy.canUseEnergy(10.0)) {
            block0: for (List<TileEntityCrop> crops : this.list) {
                for (TileEntityCrop crop : crops) {
                    if (!(this.energy.getEnergy() > 10.0) || this.tank.getFluidAmount() <= 1) break block0;
                    if (crop.getCrop() == null || crop.getTickPest() != 0 || !this.contains(crop.getPos()) || crop.getCrop().getId() == 3) continue;
                    this.tank.drain(1, IFluidHandler.FluidAction.EXECUTE);
                    crop.setTickPest();
                    this.energy.useEnergy(10.0);
                }
            }
        }
    }
}

