/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.ComponentUpgradeSlots;
import com.denfop.componets.Energy;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.componets.client.ComponentVisibleArea;
import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerSaplingGardener;
import com.denfop.gui.GuiCore;
import com.denfop.gui.GuiSaplingGardener;
import com.denfop.invslot.InvSlot;
import com.denfop.invslot.InvSlotUpgrade;
import com.denfop.tiles.base.TileEntityInventory;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;

public class TileEntitySaplingGardener
extends TileEntityInventory
implements IUpgradableBlock {
    private static final int RADIUS = 4;
    public final InvSlot slot;
    public final Energy energy;
    public final InvSlotUpgrade upgradeSlot;
    private final SoilPollutionComponent pollutionSoil;
    private final AirPollutionComponent pollutionAir;
    private final ComponentUpgradeSlots componentUpgrade;
    AABB searchArea;
    private ComponentVisibleArea visible;

    public TileEntitySaplingGardener(BlockPos pos, BlockState state) {
        super(BlockBaseMachine3.sapling_gardener, pos, state);
        this.searchArea = new AABB(this.pos.m_7918_(-4, -4, -4), this.pos.m_7918_(5, 5, 5));
        this.slot = new InvSlot(this, InvSlot.TypeItemSlot.INPUT, 1){

            @Override
            public boolean accepts(ItemStack stack, int index) {
                return stack.m_41720_() instanceof BlockItem && ((BlockItem)stack.m_41720_()).m_40614_() instanceof IPlantable && ((IPlantable)((BlockItem)stack.m_41720_()).m_40614_()).getPlantType((BlockGetter)TileEntitySaplingGardener.this.f_58857_, TileEntitySaplingGardener.this.m_58899_()) == PlantType.PLAINS;
            }
        };
        this.energy = this.addComponent(Energy.asBasicSink((TileEntityInventory)this, 1024.0, 4));
        this.upgradeSlot = new InvSlotUpgrade(this, 4);
        this.componentUpgrade = this.addComponent(new ComponentUpgradeSlots(this, this.upgradeSlot));
        this.pollutionSoil = this.addComponent(new SoilPollutionComponent(this, 0.1));
        this.pollutionAir = this.addComponent(new AirPollutionComponent(this, 0.1));
        this.visible = this.addComponent(new ComponentVisibleArea(this));
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage, UpgradableProperty.ItemInput);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.visible.aabb = this.searchArea;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.sapling_gardener;
    }

    public ContainerSaplingGardener getGuiContainer(Player var1) {
        return new ContainerSaplingGardener(this, var1);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player var1, ContainerBase<? extends IAdvInventory> menu) {
        return new GuiSaplingGardener((ContainerSaplingGardener)menu);
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.getWorld().m_46467_() % 40L == 0L) {
            this.plantSaplingsInRadius();
        }
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        super.addInformation(stack, tooltip);
        tooltip.add(Localization.translate("iu.sapling_gardener.info"));
        if (this.getComp(Energy.class) != null) {
            Energy energy = this.getComp(Energy.class);
            if (!energy.getSourceDirs().isEmpty()) {
                tooltip.add(Localization.translate("iu.item.tooltip.PowerTier", energy.getSourceTier()));
            } else if (!energy.getSinkDirs().isEmpty()) {
                tooltip.add(Localization.translate("iu.item.tooltip.PowerTier", energy.getSinkTier()));
            }
        }
    }

    private void plantSaplingsInRadius() {
        for (int x = -4; x <= 4; x += 2) {
            for (int z = -4; z <= 4; z += 2) {
                ItemStack saplingStack;
                BlockPos targetPos = this.pos.m_7918_(x, 0, z);
                if (!this.canPlantSaplingAt(targetPos) || !this.energy.canUseEnergy(25.0) || (saplingStack = this.slot.get(0)).m_41619_()) continue;
                this.energy.useEnergy(25.0);
                this.plantSapling(targetPos, saplingStack);
                if (!(this.energy.getEnergy() < 25.0)) continue;
                return;
            }
        }
    }

    private boolean canPlantSaplingAt(BlockPos pos) {
        BlockState stateAt = this.f_58857_.m_8055_(pos);
        if (!stateAt.m_60795_()) {
            return false;
        }
        BlockState below = this.f_58857_.m_8055_(pos.m_7495_());
        Block blockBelow = below.m_60734_();
        return blockBelow == Blocks.f_50493_ || blockBelow == Blocks.f_50440_;
    }

    private void plantSapling(BlockPos targetPos, ItemStack saplingStack) {
        BlockItem blockItem;
        Block block;
        Item item = saplingStack.m_41720_();
        if (item instanceof BlockItem && (block = (blockItem = (BlockItem)item).m_40614_()) instanceof SaplingBlock) {
            BlockState stateToPlace = block.m_49966_();
            this.f_58857_.m_7731_(targetPos, stateToPlace, 3);
            saplingStack.m_41774_(1);
        }
    }
}

