/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism.steamturbine.coolant;

import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.FluidName;
import com.denfop.componets.Fluids;
import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerSteamTurbineCoolant;
import com.denfop.gui.GuiCore;
import com.denfop.gui.GuiSteamTurbineCoolant;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.mechanism.multiblocks.base.TileEntityMultiBlockElement;
import com.denfop.tiles.mechanism.steamturbine.ICoolant;
import com.denfop.utils.FluidHandlerFix;
import com.denfop.utils.ModUtils;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class TileEntityBaseSteamTurbineCoolant
extends TileEntityMultiBlockElement
implements ICoolant,
IUpdatableTileEvent {
    private final Fluids fluids;
    private final int blockLevel;
    private final Fluids.InternalFluidTank tank;
    double power = 0.0;
    Fluid currentStack = null;
    private int x = 1;

    public TileEntityBaseSteamTurbineCoolant(int blockLevel, IMultiTileBlock block, BlockPos pos, BlockState state) {
        super(block, pos, state);
        this.blockLevel = blockLevel;
        this.fluids = this.addComponent(new Fluids(this));
        this.tank = this.fluids.addTankInsert("tank", 10000);
        this.getFluidsFromLevel();
    }

    private void getFluidsFromLevel() {
        ArrayList<Fluid> fluidList = new ArrayList<Fluid>();
        switch (this.blockLevel) {
            default: {
                fluidList.add((Fluid)FluidName.fluidhyd.getInstance().get());
                break;
            }
            case 1: {
                fluidList.add((Fluid)FluidName.fluidhyd.getInstance().get());
                fluidList.add((Fluid)FluidName.fluidazot.getInstance().get());
                fluidList.add((Fluid)FluidName.fluidcoolant.getInstance().get());
                break;
            }
            case 2: {
                fluidList.add((Fluid)FluidName.fluidhyd.getInstance().get());
                fluidList.add((Fluid)FluidName.fluidazot.getInstance().get());
                fluidList.add((Fluid)FluidName.fluidcoolant.getInstance().get());
                fluidList.add((Fluid)FluidName.fluidHelium.getInstance().get());
                break;
            }
            case 3: {
                fluidList.add((Fluid)FluidName.fluidhyd.getInstance().get());
                fluidList.add((Fluid)FluidName.fluidazot.getInstance().get());
                fluidList.add((Fluid)FluidName.fluidcoolant.getInstance().get());
                fluidList.add((Fluid)FluidName.fluidHelium.getInstance().get());
                fluidList.add((Fluid)FluidName.fluidcryogen.getInstance().get());
            }
        }
        this.tank.setAcceptedFluids(Fluids.fluidPredicate(fluidList));
    }

    @Override
    public boolean onActivated(Player player, InteractionHand hand, Direction side, Vec3 vec3) {
        if (!this.getWorld().f_46443_ && FluidHandlerFix.getFluidHandler(player.m_21120_(hand)) != null && this.getMain() != null) {
            return ModUtils.interactWithFluidHandler(player, hand, (IFluidHandler)this.fluids.getCapability(ForgeCapabilities.FLUID_HANDLER, side));
        }
        return super.onActivated(player, hand, side, vec3);
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer customPacketBuffer = super.writeContainerPacket();
        customPacketBuffer.writeInt(this.x);
        customPacketBuffer.writeDouble(this.power);
        return customPacketBuffer;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        this.x = customPacketBuffer.readInt();
        this.power = customPacketBuffer.readDouble();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player var1, ContainerBase<? extends IAdvInventory> menu) {
        return new GuiSteamTurbineCoolant((ContainerSteamTurbineCoolant)menu);
    }

    public ContainerSteamTurbineCoolant getGuiContainer(Player var1) {
        return new ContainerSteamTurbineCoolant(this, var1);
    }

    @Override
    public boolean hasOwnInventory() {
        return this.getMain() != null;
    }

    @Override
    public void readFromNBT(CompoundTag nbtTagCompound) {
        super.readFromNBT(nbtTagCompound);
        this.x = nbtTagCompound.m_128451_("coolant_x");
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbt) {
        CompoundTag nbtTagCompound = super.writeToNBT(nbt);
        nbtTagCompound.m_128405_("coolant_x", this.x);
        return nbtTagCompound;
    }

    @Override
    public void updateTileServer(Player var1, double var2) {
        if (this.getMain() == null) {
            return;
        }
        this.x = var2 == 0.0 ? Math.min(this.x + 1, this.blockLevel + 2) : Math.max(0, this.x - 1);
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.tank.getFluid() != null) {
            this.currentStack = this.tank.getFluid().getFluid();
            this.power = this.getPowerFromFluid();
        } else {
            this.currentStack = null;
            this.power = 0.0;
        }
    }

    private double getPowerFromFluid() {
        Fluid hyd = (Fluid)FluidName.fluidhyd.getInstance().get();
        Fluid hel = (Fluid)FluidName.fluidHelium.getInstance().get();
        Fluid coolant = (Fluid)FluidName.fluidcoolant.getInstance().get();
        Fluid nitrogen = (Fluid)FluidName.fluidazot.getInstance().get();
        Fluid cryogen = (Fluid)FluidName.fluidcryogen.getInstance().get();
        if (this.currentStack == hyd) {
            this.power = 1.0;
        } else if (this.currentStack == nitrogen) {
            this.power = 1.25;
        } else if (this.currentStack == coolant) {
            this.power = 1.75;
        } else if (this.currentStack == hel) {
            this.power = 2.25;
        } else if (this.currentStack == cryogen) {
            this.power = 3.0;
        }
        return this.power;
    }

    @Override
    public FluidTank getCoolant() {
        return this.tank;
    }

    @Override
    public double getPower() {
        return this.power * (double)this.x * 0.8;
    }

    @Override
    public int getPressure() {
        return this.x;
    }

    @Override
    public int getBlockLevel() {
        return -1;
    }
}

