/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism.vending;

import com.denfop.api.gui.IType;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.recipe.InvSlotOutput;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.componets.EnumTypeStyle;
import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerVending;
import com.denfop.gui.GuiCore;
import com.denfop.gui.GuiVending;
import com.denfop.invslot.InvSlot;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TileEntityBaseVending
extends TileEntityInventory
implements IType {
    public final EnumTypeStyle style;
    public final InvSlot invSlotInventoryInput;
    public final InvSlotOutput output;
    public InvSlot invSlotBuy;
    public InvSlot invSlotSell;
    public InvSlot invSlotBuyPrivate;
    public InvSlot invSlotSellPrivate;
    public boolean update;
    public int timer = 0;
    Map<Item, Integer> mapValues = new HashMap<Item, Integer>();

    public TileEntityBaseVending(EnumTypeStyle style, IMultiTileBlock block, BlockPos pos, BlockState state) {
        super(block, pos, state);
        this.style = style;
        this.invSlotBuyPrivate = new InvSlot(this, InvSlot.TypeItemSlot.INPUT, style.ordinal() + 1);
        this.invSlotSellPrivate = new InvSlot(this, InvSlot.TypeItemSlot.INPUT, style.ordinal() + 1);
        this.invSlotBuy = new InvSlot(this, InvSlot.TypeItemSlot.INPUT, style.ordinal() + 1){

            @Override
            public boolean accepts(ItemStack stack, int index) {
                return !TileEntityBaseVending.this.invSlotBuyPrivate.get(index).m_41619_() && TileEntityBaseVending.this.invSlotBuyPrivate.get(index).m_150930_(stack.m_41720_());
            }
        };
        this.invSlotSell = new InvSlot(this, InvSlot.TypeItemSlot.OUTPUT, style.ordinal() + 1){

            @Override
            public boolean accepts(ItemStack stack, int index) {
                return false;
            }
        };
        this.invSlotInventoryInput = new InvSlot(this, InvSlot.TypeItemSlot.INPUT, 18){

            @Override
            public void onChanged() {
                super.onChanged();
                TileEntityBaseVending.this.update = true;
            }
        };
        this.output = new InvSlotOutput(this, 18);
    }

    @Override
    public boolean onActivated(Player player, InteractionHand hand, Direction side, Vec3 vec3) {
        this.timer += 5;
        return super.onActivated(player, hand, side, vec3);
    }

    public void updateItems() {
        this.mapValues.clear();
        for (ItemStack stack : this.invSlotInventoryInput) {
            if (stack.m_41619_()) continue;
            Integer map = this.mapValues.computeIfAbsent(stack.m_41720_(), k -> 0);
            int value = map + stack.m_41613_();
            this.mapValues.replace(stack.m_41720_(), value);
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.getWorld().f_46443_) {
            this.updateItems();
        }
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            InvSlot slot = (InvSlot)DecoderHandler.decode(customPacketBuffer);
            InvSlot slot1 = (InvSlot)DecoderHandler.decode(customPacketBuffer);
            for (int i = 0; i < slot.size(); ++i) {
                this.invSlotBuyPrivate.set(i, slot.get(i));
                this.invSlotSellPrivate.set(i, slot1.get(i));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer customPacketBuffer = super.writeContainerPacket();
        try {
            EncoderHandler.encode(customPacketBuffer, this.invSlotBuyPrivate);
            EncoderHandler.encode(customPacketBuffer, this.invSlotSellPrivate);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return customPacketBuffer;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player var1, ContainerBase<? extends IAdvInventory> menu) {
        return new GuiVending((ContainerVending)menu, this.getComponentPrivate().getPlayers().contains(var1.m_7755_().getString()));
    }

    public ContainerVending getGuiContainer(Player var1) {
        return new ContainerVending(this, var1, this.getComponentPrivate().getPlayers().contains(var1.m_7755_().getString()));
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.update) {
            this.update = false;
            this.updateItems();
        }
        if (this.timer > 0) {
            --this.timer;
        }
        for (int i = 0; i < this.invSlotBuy.size(); ++i) {
            int value;
            ItemStack privateStack;
            ItemStack stack = this.invSlotBuy.get(i);
            if (stack.m_41619_() || (privateStack = this.invSlotBuyPrivate.get(i)).m_41619_()) continue;
            if (!stack.m_150930_(privateStack.m_41720_())) {
                return;
            }
            ItemStack privateSell = this.invSlotSellPrivate.get(i);
            if (privateSell.m_41619_()) continue;
            ItemStack output = this.invSlotSell.get(i);
            Integer map = this.mapValues.computeIfAbsent(privateSell.m_41720_(), k -> 0);
            if (map == 0 || (value = map.intValue()) <= 0) continue;
            int countCan = output.m_41619_() ? privateSell.m_41741_() / privateSell.m_41613_() : (privateSell.m_41741_() - output.m_41613_()) / privateSell.m_41613_();
            countCan = Math.min(value / privateSell.m_41613_(), countCan);
            if ((countCan = Math.min(countCan, stack.m_41613_() / privateStack.m_41613_())) == 0) continue;
            int totalFreeSpace = 0;
            for (ItemStack outStack : this.output) {
                if (outStack.m_41619_()) {
                    totalFreeSpace += privateStack.m_41741_();
                    continue;
                }
                if (!outStack.m_150930_(privateStack.m_41720_())) continue;
                totalFreeSpace += privateStack.m_41741_() - outStack.m_41613_();
            }
            int maxByOutput = totalFreeSpace / privateStack.m_41613_();
            int countCan1 = Math.min(maxByOutput, countCan);
            if (countCan1 == 0) continue;
            for (ItemStack stack1 : this.invSlotInventoryInput) {
                if (countCan == 0) break;
                if (!stack1.m_150930_(privateSell.m_41720_())) continue;
                int shrink = Math.min(countCan, stack1.m_41613_() / privateSell.m_41613_());
                stack1.m_41774_(shrink * privateSell.m_41613_());
                countCan -= shrink;
            }
            stack.m_41774_(countCan1 * privateStack.m_41613_());
            this.output.add(ModUtils.setSize(privateStack, countCan1 * privateStack.m_41613_()));
            this.invSlotSell.add(ModUtils.setSize(privateSell, countCan1 * privateSell.m_41613_()));
            this.updateItems();
        }
    }

    @Override
    public EnumTypeStyle getStyle() {
        return this.style;
    }
}

