/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.transport.tiles;

import com.denfop.api.sytem.EnergyEvent;
import com.denfop.api.sytem.EnergyType;
import com.denfop.api.sytem.EnumTypeEvent;
import com.denfop.api.sytem.IAcceptor;
import com.denfop.api.sytem.IConductor;
import com.denfop.api.sytem.IEmitter;
import com.denfop.api.sytem.ITile;
import com.denfop.api.sytem.InfoCable;
import com.denfop.api.sytem.InfoTile;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.transport.tiles.TileEntityMultiCable;
import com.denfop.tiles.transport.types.ICableItem;
import com.denfop.tiles.transport.types.SEType;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class TileEntitySCable
extends TileEntityMultiCable
implements IConductor {
    public boolean addedToEnergyNet;
    protected SEType cableType;
    Map<Direction, ITile> energyConductorMap = new HashMap<Direction, ITile>();
    List<InfoTile<ITile>> validReceivers = new LinkedList<InfoTile<ITile>>();
    int hashCodeSource;
    boolean updateConnect = false;
    private boolean needUpdate;
    private long id;
    private InfoCable cable;

    public TileEntitySCable(SEType cableType, IMultiTileBlock block, BlockPos pos, BlockState state) {
        super(cableType, block, pos, state);
        this.cableType = cableType;
    }

    @Override
    public ICableItem getCableItem() {
        return this.cableType;
    }

    @Override
    public long getIdNetwork() {
        return this.id;
    }

    @Override
    public int getHashCodeSource() {
        return this.hashCodeSource;
    }

    @Override
    public void setHashCodeSource(int hashCode) {
        this.hashCodeSource = hashCode;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public List<InfoTile<ITile>> getValidReceivers(EnergyType type) {
        return this.validReceivers;
    }

    @Override
    public Map<Direction, ITile> getTiles(EnergyType type) {
        return this.energyConductorMap;
    }

    public BlockPos m_58899_() {
        return this.pos;
    }

    @Override
    public void readFromNBT(CompoundTag nbt) {
        super.readFromNBT(nbt);
        this.cableType = SEType.values[nbt.m_128445_("cableType") & 0xFF];
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbt) {
        super.writeToNBT(nbt);
        nbt.m_128344_("cableType", (byte)this.cableType.ordinal());
        return nbt;
    }

    @Override
    public void updateTileServer(Player var1, double var2) {
        super.updateTileServer(var1, var2);
        MinecraftForge.EVENT_BUS.post((Event)new EnergyEvent(this.getWorld(), EnumTypeEvent.UNLOAD, EnergyType.SOLARIUM, this));
        this.needUpdate = true;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.needUpdate) {
            this.energyConductorMap.clear();
            this.validReceivers.clear();
            MinecraftForge.EVENT_BUS.post((Event)new EnergyEvent(this.getWorld(), EnumTypeEvent.LOAD, EnergyType.SOLARIUM, this));
            this.needUpdate = false;
            this.updateConnectivity();
        }
        if (this.updateConnect) {
            this.updateConnect = false;
            this.updateConnectivity();
        }
    }

    @Override
    public void RemoveTile(EnergyType type, ITile tile, Direction facing1) {
        if (!this.getWorld().f_46443_) {
            this.energyConductorMap.remove(facing1);
            Iterator<InfoTile<ITile>> iter = this.validReceivers.iterator();
            while (iter.hasNext()) {
                InfoTile<ITile> tileInfoTile = iter.next();
                if (tileInfoTile.tileEntity != tile) continue;
                iter.remove();
                break;
            }
            this.updateConnect = true;
        }
    }

    @Override
    public void AddTile(EnergyType type, ITile tile, Direction facing1) {
        if (!this.getWorld().f_46443_) {
            if (!this.energyConductorMap.containsKey(facing1)) {
                this.energyConductorMap.put(facing1, tile);
                this.validReceivers.add(new InfoTile<ITile>(tile, facing1.m_122424_()));
            }
            this.updateConnect = true;
        }
    }

    @Override
    public InfoCable getCable(EnergyType type) {
        return this.cable;
    }

    @Override
    public void setCable(EnergyType type, InfoCable cable) {
        this.cable = cable;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.getWorld().f_46443_ && !this.addedToEnergyNet) {
            this.energyConductorMap.clear();
            this.validReceivers.clear();
            MinecraftForge.EVENT_BUS.post((Event)new EnergyEvent(this.getWorld(), EnumTypeEvent.LOAD, EnergyType.SOLARIUM, this));
            this.addedToEnergyNet = true;
            this.updateConnectivity();
        }
    }

    @Override
    public void onUnloaded() {
        if (!this.getWorld().f_46443_ && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyEvent(this.getWorld(), EnumTypeEvent.UNLOAD, EnergyType.SOLARIUM, this));
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    @Override
    public void onNeighborChange(BlockState neighbor, BlockPos neighborPos) {
        super.onNeighborChange(neighbor, neighborPos);
        if (!this.getWorld().f_46443_) {
            this.updateConnectivity();
        }
    }

    @Override
    public void updateConnectivity() {
        byte newConnectivity = 0;
        Direction[] var4 = Direction.values();
        Map<Direction, ITile> map = this.energyConductorMap;
        for (Direction dir : var4) {
            newConnectivity = (byte)(newConnectivity << 1);
            ITile tile = map.get(dir);
            if (dir == null || this.getBlackList().contains(dir) || (!(tile instanceof IAcceptor) || !((IAcceptor)tile).acceptsFrom(this, dir.m_122424_())) && (!(tile instanceof IEmitter) || !((IEmitter)tile).emitsTo(this, dir.m_122424_()))) continue;
            newConnectivity = (byte)(newConnectivity + 1);
        }
        this.setConnectivity(newConnectivity);
        this.cableItem = this.cableType;
    }

    @Override
    public boolean wrenchCanRemove(Player player) {
        return false;
    }

    @Override
    public boolean acceptsFrom(IEmitter emitter, Direction direction) {
        return !this.getBlackList().contains(direction);
    }

    @Override
    public boolean emitsTo(IAcceptor receiver, Direction direction) {
        return !this.getBlackList().contains(direction);
    }

    public boolean canInteractWith() {
        return true;
    }

    @Override
    public double getConductorBreakdownEnergy(EnergyType type) {
        return this.cableType.capacity + 1.0;
    }

    @Override
    public EnergyType getEnergyType() {
        return EnergyType.SOLARIUM;
    }

    @Override
    public boolean hasEnergies() {
        return false;
    }

    @Override
    public List<EnergyType> getEnergies() {
        return null;
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer packet = super.writePacket();
        try {
            EncoderHandler.encode(packet, this.cableType);
            EncoderHandler.encode(packet, this.connectivity);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            this.cableType = SEType.values[(Integer)DecoderHandler.decode(customPacketBuffer)];
            this.connectivity = (Byte)DecoderHandler.decode(customPacketBuffer);
            this.rerender();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public BlockEntity getTile() {
        return this;
    }
}

