/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.bee;

import com.denfop.api.bee.Bee;
import com.denfop.api.bee.BeeNetwork;
import com.denfop.api.bee.Product;
import com.denfop.api.crop.Crop;
import com.denfop.network.packet.CustomPacketBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.AABB;

public class BeeBase
implements Bee {
    private final int weatherResistance;
    private final int maxSwarm;
    private final Crop cropFlower;
    private final int id;
    private final List<ResourceKey<Biome>> biomes = new ArrayList<ResourceKey<Biome>>();
    private final int offspring;
    private final AABB sizeTerritory;
    private final int tickLifecycles;
    private final double maxMortalityRate;
    private final int tickBirthRate;
    private final List<Product> products = new ArrayList<Product>();
    private final String name;
    private List<Bee> unCompatibleBees;
    private boolean sun;
    private boolean night;
    private int chance;

    public BeeBase(String name, int id, int maxSwarm, int tickBirthRate, int tickLifecycles, AABB sizeTerritory, int offspring, int chance, boolean sun, boolean night, Crop cropFlower, List<Bee> unCompatibleBees, int defaultWeatherResistance, double maxMortalityRate) {
        this.name = name;
        this.maxSwarm = maxSwarm;
        this.chance = chance;
        this.id = id;
        this.maxMortalityRate = maxMortalityRate;
        this.weatherResistance = defaultWeatherResistance;
        this.tickBirthRate = tickBirthRate;
        this.tickLifecycles = tickLifecycles;
        this.sizeTerritory = sizeTerritory;
        this.sun = sun;
        this.night = night;
        this.unCompatibleBees = unCompatibleBees;
        this.cropFlower = cropFlower;
        this.offspring = offspring;
        BeeNetwork.instance.addBee(this);
    }

    @Override
    public int getMaxSwarm() {
        return this.maxSwarm;
    }

    @Override
    public BeeBase copy() {
        BeeBase bee = new BeeBase(this.name, this.id, this.maxSwarm, this.tickBirthRate, this.tickLifecycles, this.sizeTerritory, this.offspring, this.chance, this.sun, this.night, this.cropFlower, new ArrayList<Bee>(this.unCompatibleBees), this.weatherResistance, this.maxMortalityRate);
        for (ResourceKey<Biome> biome : this.biomes) {
            bee.addBiome(biome);
        }
        return bee;
    }

    @Override
    public Crop getCropFlower() {
        return this.cropFlower;
    }

    @Override
    public List<Bee> getUnCompatibleBees() {
        return this.unCompatibleBees;
    }

    @Override
    public void setUnCompatibleBees(List<Bee> bees) {
        this.unCompatibleBees = bees;
    }

    @Override
    public boolean isSun() {
        return this.sun;
    }

    @Override
    public boolean isNight() {
        return this.night;
    }

    @Override
    public int getWeatherResistance() {
        return this.weatherResistance;
    }

    @Override
    public int getChance() {
        return this.chance;
    }

    @Override
    public void setChance(int chance) {
        this.chance = chance;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public List<ResourceKey<Biome>> getBiomes() {
        return this.biomes;
    }

    @Override
    public boolean canWorkInBiome(ResourceKey<Biome> biomeName) {
        return this.biomes.contains(biomeName);
    }

    @Override
    public boolean canWorkInBiome(Biome biomeName, Level level) {
        ResourceKey biomeKey = (ResourceKey)level.m_5962_().m_175515_(Registry.f_122885_).m_7854_((Object)biomeName).get();
        return this.biomes.contains(biomeKey);
    }

    @Override
    public void addBiome(ResourceKey<Biome> biomeName) {
        this.biomes.add(biomeName);
    }

    @Override
    public int getOffspring() {
        return this.offspring;
    }

    @Override
    public AABB getSizeTerritory() {
        return this.sizeTerritory;
    }

    @Override
    public int getTickLifecycles() {
        return this.tickLifecycles;
    }

    @Override
    public double getMaxMortalityRate() {
        return this.maxMortalityRate;
    }

    @Override
    public int getTickBirthRate() {
        return this.tickBirthRate;
    }

    @Override
    public List<Product> getProduct() {
        return this.products;
    }

    @Override
    public void addPercentProduct(Crop crop, double percent) {
        Product target = null;
        for (Product product : this.products) {
            if (product.getCrop().getId() != crop.getId()) continue;
            target = product;
            break;
        }
        if (target == null) {
            target = new Product(0.0, crop);
            this.products.add(target);
        }
        double currentTotal = this.products.stream().mapToDouble(Product::getChance).sum();
        double availableSpace = 100.0 - currentTotal;
        double actualAdd = Math.min(percent, availableSpace);
        target.addChance(actualAdd);
        double overflow = percent - actualAdd;
        if (overflow > 0.0) {
            double toReduce = overflow;
            Product finalTarget = target;
            List<Product> others = this.products.stream().filter(p -> p != finalTarget).sorted(Comparator.comparingDouble(Product::getChance).reversed()).toList();
            for (Product other : others) {
                if (toReduce <= 0.0) break;
                double chance = other.getChance();
                double reducible = Math.min(chance, toReduce);
                other.addChance(-reducible);
                toReduce -= reducible;
            }
            this.products.removeIf(p -> p.getChance() <= 0.0);
        }
    }

    @Override
    public void removeAllPercent(double range) {
        Iterator<Product> iter = this.products.iterator();
        while (iter.hasNext()) {
            Product product = iter.next();
            product.removeChance(range);
            if (!(product.getChance() <= 0.0)) continue;
            iter.remove();
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void readPacket(CustomPacketBuffer buffer) {
    }

    @Override
    public CustomPacketBuffer writePacket() {
        return null;
    }
}

